FormManager.afterCreateAllForms.subscribe(function () {
  let form = FormManager.byname('TnCtbDMPlanoPadrao', '');
  const acronym = FormManager.getUtil('Acronym');


  form.getcomponent('APELIDOCONTA').on('focus', PreencherApelido);
	form.getcomponent('TIPOCONTACALC').change(HabilitarAbaContasCalculadas);
	form.getcomponent('CLASSIFCONTA').keyup(FormatarMaskaraGrupo);

	function HabilitarAbaContasCalculadas(){
	    
		if ( form.getvalue('TIPOCONTACALC') == 2){
			RestoreTabsCadastro();
		}else{
			RemoverTabCadastro('TnCtbDMCalcPlanoPadrao');
		}		
	}

	function GetConfigPlano(){
		let codigoPadrao = form.getvalue('CODIGOPADRAO');

		return form.configextra.Configuracoes.find( (config) => (config.CodigoPadrao == codigoPadrao) ); 
	}

	function FormatarMaskaraGrupo(){
		let configplano = GetConfigPlano();	

		if (configplano){
			var AClassifConta = form.getvalue('CLASSIFCONTA');
			if ((AClassifConta != null) && (AClassifConta != '')){
				var AMaskara = configplano.MascGrupos[AClassifConta[0] - 1];
				var field = form.fieldbyName('CLASSIFCONTA');

				field.componente.get(0).dataset['mask'] = AMaskara;
				form.setarmascaracampo('CLASSIFCONTA', AMaskara);
				
				var naturezasaldo = form.getvalue('NATURSALDO');
				if ((naturezasaldo == null) || (naturezasaldo == '')){
					form.setvalue('NATURSALDO', configplano.NatuGrupos[AClassifConta[0]-1]);
				}
			}
		}
	}

	function PreencherApelido(event) {
    if (event.target.value == '') {
      if (acronym) {
        var apelido = acronym({
          separator: [' ', '.', ';', ',', '.', '(', ')', '-'], 
          length: 10, 
          str: form.getvalue('DESCRCONTA')
        });

        form.setfieldvalue('APELIDOCONTA', apelido);
      }
    }
	}
});