{
  FormManager.afterCreateAllForms.subscribe(function () {
    var wizardSteps =
      [
        {
          element: {
            class: "wizard-step",
            indexClass: 0
          },
          title: "Plano de Contas",
          text: "Neste primeiro passo do <b> Plano de Contas </b>, você pode cadastrar o Plano Grupo de Empresas. Para que esse cadastro seja concluído, deve-se preencher todos os campos obrigatórios. Importante mencionar que o campo: <b> Máscara da Classificação </b>: é a estrutura do Plano Grupo de Empresas. Exemplo: 9.9.99.99.999.99999. <br /> <br /> Agora sim, você pode passar para o próximo passo, ou clicar sobre qualquer um dos passos, caso não necessite seguir essa ordem.",
          step: 1,
          group: "TNCTBDMPLANOGRUPOEMPRESACFG"
        },
        {
          element: {
            class: 'wizard-step',
            indexClass: 1
          },
          title: 'Grupo Empresarial',
          text: 'Neste segundo passo do <b> Grupo Empresarial </b>, você pode cadastrar o Grupo Empresarial. Para que esse cadastro seja concluído, deve-se preencher todos os campos obrigatórios. <br /> <br /> Importante mencionar que nos seguintes campos: "Percentual Participação" deve ser informado o % de participação acionária da empresa titular da ECF; e no campo: "Percentual Consolidação" deve ser informado o % de consolidação da empresa no final do período.',
          step: 2,
          group: 'TNCTBDMPLANOGRUPOEMPRESACFG'
        },

        {
          element: {
            class: 'wizard-step',
            indexClass: 2
          },
          title: 'Relacionar Plano Padrão',
          text: 'Neste terceiro passo de <b> Relacionar Plano Padrão </b>, você pode relacionar o Plano o Padrão com o Plano Consolidado, essa forma o relacionamento pode ser usado por todas as empresas que utilizam o mesmo Plano Padrão.',
          step: 3,
          group: 'TNCTBDMPLANOGRUPOEMPRESACFG'
        },
        {
          element: {
            class: 'wizard-step',
            indexClass: 3
          },
          title: 'Relacionar Plano Específico',
          text: 'Neste quarto passo de <b> Relacionar Plano Específico </b>, você pode relacionar o Plano o Específico com o Plano Consolidado. <br /> <br /> Muito importante lembrar! Que mesmo utilizando o relacionamento do Plano Padrão com o Plano Consolidado, é necessário relacionar as contas específicas da empresa.',
          step: 4,
          group: 'TNCTBDMPLANOGRUPOEMPRESACFG'
        },
        {
          element: {
            class: 'wizard-step',
            indexClass: 4
          },
          title: 'Configurar Demonstrações',
          text: 'Neste quinto passo de <b> Configurar Demonstrações </b> é possível efetuar a configuração das demonstrações já cadastradas no sistema (são elas: DRE, DFCD e DFCI) com ao Plano Grupo de Empresas.',
          step: 5,
          group: 'TNCTBDMPLANOGRUPOEMPRESACFG'
        },
        {
          element: {
            class: 'wizard-step',
            indexClass: 5
          },
          title: 'Definição de Contas',
          text: 'Neste sexto passo da <b> Definição de Contas </b> pode ser definida a Natureza das Contas: Patrimônio Líquido, Contas de Compensação e Outras. Esta informação será gerada no registro K200 da ECD. <br /> <br /> Importante mencionar que no campo: <b> Conta Grupo de Empresarial </b> ao informar uma conta contábil sintética, todas as contas filhas serão geradas com a mesma natureza no registro K200. <br /> <br /> Porém ao informar uma conta analítica, apenas esta conta será gerada com a natureza no registro K200.',
          step: 6,
          group: 'TNCTBDMPLANOGRUPOEMPRESACFG'
        },
      ]

    var stepConfig = {
      TNCTBDPAREATRABALHOMOEDAFUNCIONAL: {
        steps: [
          {
            element: {
              class: "card-title",
              indexClass: 0
            },
            title: "Bem vindo(a) ao Grupo de Empresas Holding!",
            text: "Os termos 'Grupo Empresarial', 'Grupo Econômico', 'Conglomerado Econômico', 'Conglomerado Empresarial' e 'Conglomerado Industrial' se referem a um conjunto de empresas que dependem de uma mesma empresa matriz (holding).",
            group: 'TNCTBDPAREATRABALHOMOEDAFUNCIONAL',
            step: 1,
          },
          {
            element: {
              class: "kt-portlet__head-toolbar kt-portlet__head-tabs",
              indexClass: 0
            },
            text: " No menu <b> Cadastro </b>, você pode cadastrar um Plano de Contas, um Grupo Empresarial, Relacionar Plano Padrão ou Plano Específico, configurar as demonstrações e efetuar a Definição das Contas. <br /> <br /> Além dessas opções, também é possível realizar o cadastro de <b> Valores de Eliminação </b> e <b> Eventos Societários </b> ",
            group: "TNCTBDPAREATRABALHOMOEDAFUNCIONAL",
            step: 2
          },
        ]
      },
      TNCTBDPGRUPOEMPCONSULTABALANCETE: {
        steps: [
          {
            element: {
              class: "nav-item",
              indexClass: 3
            },
            text: "No menu <b> Consultas </b>, você pode consultar os valores do Balancete, do Balanço e das Demonstrações. <br /> <br /> Além de consultar as demonstrações, também é possível listar o relatório dessas consultas.",
            group: "TNCTBDPGRUPOEMPCONSULTABALANCETE",
            step: 1
          }
        ]
      },
      TNCTBDPGRUPOEMPRESACONSULTABALANCO: {
        steps: [
          {
            element: {
              class: "nav-item",
              indexClass: 3
            },
            text: "No menu <b> Consultas </b>, você pode consultar os valores do Balancete, do Balanço e das Demonstrações. <br /> <br /> Além de consultar as demonstrações, também é possível listar o relatório dessas consultas.",
            group: "TNCTBDPGRUPOEMPRESACONSULTABALANCO",
            step: 1
          }
        ]
      },

      TNCTBDPGRUPOEMPCONSULTADEMONSTRACOES: {
        steps: [
          {
            element: {
              class: "nav-item",
              indexClass: 3
            },
            text: "No menu <b> Consultas </b>, você pode consultar os valores do Balancete, do Balanço e das Demonstrações. <br /> <br /> Além de consultar as demonstrações, também é possível listar o relatório dessas consultas.",
            group: "TNCTBDPGRUPOEMPCONSULTADEMONSTRACOES",
            step: 1
          }
        ]
      },

      TNCTBDMPLANOGRUPOEMPRESACFG: {
        steps: wizardSteps
      },
      TNCTBDMRELACAOEMPCONSOLIDADAS: {
        steps: wizardSteps
      },
      TNCTBDPGRUPOEMPRESARELACIONARPLANOPADRAO: {
        steps: wizardSteps
      },
      TNCTBDPGRUPOEMPRESARELACIONARPLANOESPECIFICO: {
        steps: wizardSteps
      },
      TNCTBDPCFGDEMONSTRACOESPLANOGRUPOEMP: {
        steps: wizardSteps
      },
      TNCTBDMDEFPLANOGRUPOEMP: {
        steps: wizardSteps
      },
      TNCTBDMVALORELIMINADOEMPDETENTORA: {
        steps: [
          {
            element: {
              id: 'TNCTBDMVALORELIMINADOEMPDETENTORA'
            },
            title: 'Valores de Eliminação',
            text: 'Através desse menu <b> Valores de Eliminação </b> é possível informar os valores de eliminação que serão gerados nos registros K310 e K315 do arquivo da ECD.',
            step: 1,
            group: 'TNCTBDMVALORELIMINADOEMPDETENTORA'
          },
          {
            element: {
              id: 'formFieldCOMPETENCIATNCTBDMVALORELIMINADOEMPDETENTORA'
            },
            title: 'Competência',
            text: 'Este campo deve ser utilizado quando houver a necessidade de gerar o arquivo em períodos distintos, como por exemplo, o período mensal. Já na geração do arquivo Anual deve ser informada apenas a competência do mês 12.',
            step: 2,
            group: 'TNCTBDMVALORELIMINADOEMPDETENTORA'
          },
          {
            element: {
              id: 'formFieldCODIGORELACAOEMPTNCTBDMVALORELIMINADOEMPDETENTORA'
            },
            title: 'Grupo Empresarial',
            text: 'Neste campo deve ser informado o grupo empresarial onde o sistema identificará o saldo para posterior geração do arquivo da ECD.',
            step: 3,
            group: 'TNCTBDMVALORELIMINADOEMPDETENTORA'
          },
        ]
      },
      TNCTBDMEVENTOSSOCIETARIOS: {
        steps: [
          {
            element: {
              id: 'TNCTBDMEVENTOSSOCIETARIOS'
            },
            title: 'Eventos Societários',
            text: 'Através desse menu <b> Valores de Eliminação </b>, é possível informar os eventos societários gerados nos registros K110 e K115, do arquivo da ECD.',
            step: 1,
            group: 'TNCTBDMEVENTOSSOCIETARIOS'
          }
        ]
      }

    }

    let helperConfig = {
      hint: "Está com duvidas? Clique aqui e faça um tour no Grupo de Empresas - Holding",
      defaultStep: "TNCTBDPAREATRABALHOMOEDAFUNCIONAL",
      stepConfig: stepConfig
    }

    let DynamicImport = FormManager.getUtil('DynamicImport');

    DynamicImport.execute(DynamicImport.Import('helpUtility', 'insertHelpButton'), helperConfig);
  })
}