FormManager.afterCreateAllForms.subscribe(function() {
	let formAtual = FormManager.byname('TnCtbDPCredenciamentoEmpEquals');
	let gridEmpresas;

	formAtual.afterCreateGridConteudo.subscribe(function(gridName) {
		if (gridName == 'dataGridConteudonClientDataSet'){
			let grid = $(`#${gridName}`).exists();

			if (grid) {
				gridEmpresas = dxDataGrid.getInstance(grid);
				gridEmpresas.option('selection.mode', 'multiple');
				gridEmpresas.on('selectionChanged', (prop) => {
					AjustarSelecionados(prop);
					AjustarDeselecionados(prop);
				});
			}
		}
	});
	
	formAtual.AfterExecuteActionProcess.subscribe(function() {
		var datagridlocal = dxDataGrid.getInstance($(`#dataGridConteudonClientDataSet`));	  			
		
		MostrarColunaStatus(datagridlocal);
			
		setTimeout(function() {
			datagridlocal.state({});
		}, 500)    
    });
	
	function MostrarColunaStatus(grid){
		var exibeColuna = formAtual.fieldbyName('PACAOCREDENCIAMENTO').getvalue() ==  1;
		
		grid.option('columns').find((e) => e.dataField == 'STATUS').visible = exibeColuna;		
    }

	function AjustarSelecionados(prop) {
		if (prop.currentSelectedRowKeys.length >= 0) {
			prop.currentSelectedRowKeys.forEach(element => {
				gridEmpresas.cellValue(element.INDICE -1, 'GRAVAR', '1');
			});
		}
	};

	function AjustarDeselecionados(prop) {
		if (prop.currentDeselectedRowKeys.length >= 0) {
			prop.currentDeselectedRowKeys.forEach(element => {
				gridEmpresas.cellValue(element.INDICE -1, 'GRAVAR', '0');
			});
		}
	}
});