const _AFormName = 'TnCtrDMCreditoEstadual';
const _ABaseJS = 'PageScripts/nCtr/TnCtrContabilizacaoBase';

FormManager.afterCreateAllForms.subscribe(function () {
	let FormularioCreditoEstadual = FormManager.byname(_AFormName, '');
	var DynamicImport = FormManager.getUtil('DynamicImport');
    const AfterSave = DynamicImport.Import(_ABaseJS, 'AfterSave');
    const FrameModal = DynamicImport.Import(_ABaseJS, 'FrameModal');
    const ExecutarValidarContabilizacaoCloud = DynamicImport.Import(_ABaseJS, 'ExecutarValidarContabilizacaoCloud');

	const requestData = function () {
		if (FormularioCreditoEstadual.getvalue('CHAVEDEBITOEST') && (!FormularioCreditoEstadual.getvalue('DATAPAGAMENTO'))) {
			$achave = FormularioCreditoEstadual.getvalue('CODIGOEMPRESA') + ';' +
					  FormularioCreditoEstadual.getvalue('CODIGOESTAB') + ';' +
					  FormularioCreditoEstadual.getvalue('CHAVEDEBITOEST');

			AJaxCadastroExecuteMethodGetProperty(_AFormName, 'CarregarDadosDebito', $achave, 'DataVencimento;ValorDebito', requestDataSucesso);
		}
	}

	const requestDataSucesso = function (retorno) {
		FormularioCreditoEstadual.setvalue('DATAPAGAMENTO', retorno.data.DataVencimento);
		FormularioCreditoEstadual.setvalue('VALORCREDITO', retorno.data.ValorDebito);
	}

	$('.ctrlDATAPAGAMENTO').on('focus.request', requestData);
	
	AfterSave.then((method) => {
        method(FormularioCreditoEstadual);
    });
	
	$("#framemodal").on("load", function() {		
		const contentWindow = this.contentWindow;
		
		FrameModal.then((method) => {
			method(contentWindow);
		});		
	});
	
	$("#detalheModal").on("hide.bs.modal", function(e) {
		const contentWindow = $("#framemodal").get(0).contentWindow;
		
		ExecutarValidarContabilizacaoCloud.then((method) => {
			method(contentWindow);
		});	
    });
});