const _AFormName = 'TnCtrDMCreditoFGTS';
const _ABaseJS = 'PageScripts/nCtr/TnCtrContabilizacaoBase';

FormManager.afterCreateAllForms.subscribe(function () {
	let FormularioCreditoFGTS = FormManager.byname(_AFormName, '');
	var DynamicImport = FormManager.getUtil('DynamicImport');
	const AfterSave = DynamicImport.Import(_ABaseJS, 'AfterSave');
	const FrameModal = DynamicImport.Import(_ABaseJS, 'FrameModal');
	const ExecutarValidarContabilizacaoCloud = DynamicImport.Import(_ABaseJS, 'ExecutarValidarContabilizacaoCloud');

	const requestData = function () {
		if (FormularioCreditoFGTS.getvalue('CHAVEDEBITOFGTS') && (!FormularioCreditoFGTS.getvalue('DATAPAGAMENTO'))) {
			$achave = SessionManager.selecao.CODIGOEMPRESA + ';' +
								SessionManager.selecao.CODIGOESTAB + ';' +
								FormularioCreditoFGTS.getvalue('CHAVEDEBITOFGTS');
			
			AJaxCadastroExecuteMethodGetProperty(_AFormName, 'CarregarDadosDebito', $achave, 'DataVencimento;ValorDebito', requestDataSucesso);
		}
	}

	const requestDataSucesso = function (retorno) {
		FormularioCreditoFGTS.setvalue('DATAPAGAMENTO', retorno.data.DataVencimento);
		FormularioCreditoFGTS.setvalue('VALORCREDITO', retorno.data.ValorDebito);
	}

	$('.ctrlDATAPAGAMENTO').on('focus.request', requestData);

	AfterSave.then((method) => {
		method(FormularioCreditoFGTS);
	});
	
	$("#framemodal").on("load", function() {		
		const contentWindow = this.contentWindow;
		
		FrameModal.then((method) => {
			method(contentWindow);
		});		
	});
	
	$("#detalheModal").on("hide.bs.modal", function(e) {
		const contentWindow = $("#framemodal").get(0).contentWindow;
		
		ExecutarValidarContabilizacaoCloud.then((method) => {
			method(contentWindow);
		});	
	});
});