const _AFormName = 'TnCtrDMCreditoFederalCIDE';
const _ABaseJS = 'PageScripts/nCtr/TnCtrContabilizacaoBase';

FormManager.afterCreateAllForms.subscribe(function () {
	let FormularioCreditoFederalCIDE = FormManager.byname(_AFormName, '');
	var DynamicImport = FormManager.getUtil('DynamicImport');
    const AfterSave = DynamicImport.Import(_ABaseJS, 'AfterSave');
    const FrameModal = DynamicImport.Import(_ABaseJS, 'FrameModal');
    const ExecutarValidarContabilizacaoCloud = DynamicImport.Import(_ABaseJS, 'ExecutarValidarContabilizacaoCloud');

	const requestData = function () {
		if (FormularioCreditoFederalCIDE.getvalue('CHAVEDEBITOFED') && (!FormularioCreditoFederalCIDE.getvalue('DATAPAGAMENTO'))) {
			$achave = FormularioCreditoFederalCIDE.getvalue('CODIGOEMPRESA') + ';' +
					  FormularioCreditoFederalCIDE.getvalue('CODIGOESTAB') + ';' +
					  FormularioCreditoFederalCIDE.getvalue('CHAVEDEBITOFED');
					  
			AJaxCadastroExecuteMethodGetProperty(_AFormName, 'CarregarDadosDebito', $achave, 'DataVencimento;ValorDebito;TipoInscr;InscrFed', requestDataSucesso);
		}
	}

	const requestDataSucesso = function requestDataSucesso(retorno) {
		FormularioCreditoFederalCIDE.setvalue('DATAPAGAMENTO', retorno.data.DataVencimento);
		FormularioCreditoFederalCIDE.setvalue('VALORCREDITO', retorno.data.ValorDebito);
		FormularioCreditoFederalCIDE.setvalue('DARFTIPOINSCRFED', retorno.data.TipoInscr);
		FormularioCreditoFederalCIDE.setvalue('DARFINSCRFED', retorno.data.InscrFed);
	}

	$('.ctrlDATAPAGAMENTO').on('focus.request', requestData);
	
	AfterSave.then((method) => {
        method(FormularioCreditoFederalCIDE);
    });
	
	$("#framemodal").on("load", function() {		
		const contentWindow = this.contentWindow;
		
		FrameModal.then((method) => {
			method(contentWindow);
		});		
	});
	
	$("#detalheModal").on("hide.bs.modal", function(e) {
		const contentWindow = $("#framemodal").get(0).contentWindow;
		
		ExecutarValidarContabilizacaoCloud.then((method) => {
			method(contentWindow);
		});	
    });
});