const _AFormName = 'TnCtrDMCreditoFederalOutComp';
const _ABaseJS = 'PageScripts/nCtr/TnCtrContabilizacaoBase';

FormManager.afterCreateAllForms.subscribe(function () {
	FormularioCreditoFederalOutComp = FormManager.byname(_AFormName, '');
	var DynamicImport = FormManager.getUtil('DynamicImport');
    const AfterSave = DynamicImport.Import(_ABaseJS, 'AfterSave');
    const FrameModal = DynamicImport.Import(_ABaseJS, 'FrameModal');
    const ExecutarValidarContabilizacaoCloud = DynamicImport.Import(_ABaseJS, 'ExecutarValidarContabilizacaoCloud');

	const requestData = function () {
		if (FormularioCreditoFederalOutComp.getvalue('CHAVEDEBITOFED') && (!FormularioCreditoFederalOutComp.getvalue('DATAPAGAMENTO'))) {
			$achave = FormularioCreditoFederalOutComp.getvalue('CODIGOEMPRESA') + ';' +
					  FormularioCreditoFederalOutComp.getvalue('CODIGOESTAB') + ';' +
					  FormularioCreditoFederalOutComp.getvalue('CHAVEDEBITOFED');

			AJaxCadastroExecuteMethodGetProperty(_AFormName, 'CarregarDadosDebito', $achave, 'DataVencimento;ValorDebito', requestDataSucesso);
		}
	}

	const requestDataSucesso = function (retorno) {
		FormularioCreditoFederalOutComp.setvalue('DATAPAGAMENTO', retorno.data.DataVencimento);
		FormularioCreditoFederalOutComp.setvalue('VALORCREDITO', retorno.data.ValorDebito);
	}

	$('.ctrlDATAPAGAMENTO').on('focus.request', requestData);
	
	AfterSave.then((method) => {
        method(FormularioCreditoFederalOutComp);
    });
	
	$("#framemodal").on("load", function() {		
		const contentWindow = this.contentWindow;
		
		FrameModal.then((method) => {
			method(contentWindow);
		});		
	});
	
	$("#detalheModal").on("hide.bs.modal", function(e) {
		const contentWindow = $("#framemodal").get(0).contentWindow;
		
		ExecutarValidarContabilizacaoCloud.then((method) => {
			method(contentWindow);
		});	
    });
})