const _AFormName = 'TnCtrDMCreditoFederalParcela';
const _ABaseJS = 'PageScripts/nCtr/TnCtrContabilizacaoBase';

FormManager.afterCreateAllForms.subscribe(function () {
	let FormularioCreditoFederalParcela = FormManager.byname(_AFormName, '');
	var DynamicImport = FormManager.getUtil('DynamicImport');
    const AfterSave = DynamicImport.Import(_ABaseJS, 'AfterSave');
    const FrameModal = DynamicImport.Import(_ABaseJS, 'FrameModal');
    const ExecutarValidarContabilizacaoCloud = DynamicImport.Import(_ABaseJS, 'ExecutarValidarContabilizacaoCloud');

	const requestData = function () {
		if (FormularioCreditoFederalParcela.getvalue('CHAVEDEBITOFED') && (!FormularioCreditoFederalParcela.getvalue('DATAPAGAMENTO'))) {
			$achave = FormularioCreditoFederalParcela.getvalue('CODIGOEMPRESA') + ';' +
					  FormularioCreditoFederalParcela.getvalue('CODIGOESTAB') + ';' +
					  FormularioCreditoFederalParcela.getvalue('CHAVEDEBITOFED');
								
			AJaxCadastroExecuteMethodGetProperty(_AFormName, 'CarregarDadosDebito', $achave, 'DataVencimento;ValorDebito', requestDataSucesso);
		}
	}

	const requestDataSucesso = function (retorno) {
		FormularioCreditoFederalParcela.setvalue('DATAPAGAMENTO', retorno.data.DataVencimento);
		FormularioCreditoFederalParcela.setvalue('VALORCREDITO', retorno.data.ValorDebito);
	}

	$('.ctrlDATAPAGAMENTO').on('focus.request', requestData);
	
	AfterSave.then((method) => {
        method(FormularioCreditoFederalParcela);
    });
	
	$("#framemodal").on("load", function() {		
		const contentWindow = this.contentWindow;
		
		FrameModal.then((method) => {
			method(contentWindow);
		});		
	});
	
	$("#detalheModal").on("hide.bs.modal", function(e) {
		const contentWindow = $("#framemodal").get(0).contentWindow;
		
		ExecutarValidarContabilizacaoCloud.then((method) => {
			method(contentWindow);
		});	
    });
})