const _AFormName = 'TnCtrDMCreditoFederalSimples';
const _ABaseJS = 'PageScripts/nCtr/TnCtrContabilizacaoBase';

FormManager.afterCreateAllForms.subscribe(function () {
	let FormularioCreditoFederalSimples = FormManager.byname(_AFormName, '');
	var DynamicImport = FormManager.getUtil('DynamicImport');
    const AfterSave = DynamicImport.Import(_ABaseJS, 'AfterSave');
    const FrameModal = DynamicImport.Import(_ABaseJS, 'FrameModal');
    const ExecutarValidarContabilizacaoCloud = DynamicImport.Import(_ABaseJS, 'ExecutarValidarContabilizacaoCloud');
	
	const requestData = function () {
		if (FormularioCreditoFederalSimples.getvalue('CHAVEDEBITOFED') && (!FormularioCreditoFederalSimples.getvalue('DATAPAGAMENTO'))) {
			$achave = FormularioCreditoFederalSimples.getvalue('CODIGOEMPRESA') + ';' +
					  FormularioCreditoFederalSimples.getvalue('CODIGOESTAB') + ';' +
					  FormularioCreditoFederalSimples.getvalue('CHAVEDEBITOFED');
			
			AJaxCadastroExecuteMethodGetProperty(_AFormName, 'CarregarDadosDebito', $achave, 'DataVencimento;ValorDebito;ValorMulta;ValorJuros', requestDataSucesso);
		}
	}

	const requestDataSucesso = function (retorno) {
		FormularioCreditoFederalSimples.setvalue('DATAPAGAMENTO', retorno.data.DataVencimento);
		FormularioCreditoFederalSimples.setvalue('VALORCREDITO', retorno.data.ValorDebito);
		FormularioCreditoFederalSimples.setvalue('VALORMULTA', retorno.data.ValorMulta);
		FormularioCreditoFederalSimples.setvalue('VALORJUROS', retorno.data.ValorJuros);
	}

	$('.ctrlDATAPAGAMENTO').on('focus.request', requestData);
	
	AfterSave.then((method) => {
        method(FormularioCreditoFederalSimples);
    });
	
	$("#framemodal").on("load", function() {		
		const contentWindow = this.contentWindow;
		
		FrameModal.then((method) => {
			method(contentWindow);
		});		
	});
	
	$("#detalheModal").on("hide.bs.modal", function(e) {
		const contentWindow = $("#framemodal").get(0).contentWindow;
		
		ExecutarValidarContabilizacaoCloud.then((method) => {
			method(contentWindow);
		});	
    });
});