const _AFormName = 'TnCtrDMCreditoFederalSuspensao';
const _ABaseJS = 'PageScripts/nCtr/TnCtrContabilizacaoBase';

FormManager.afterCreateAllForms.subscribe(function () {
	let FormularioCreditoFederalSuspensao = FormManager.byname(_AFormName, '');
	var DynamicImport = FormManager.getUtil('DynamicImport');
    const AfterSave = DynamicImport.Import(_ABaseJS, 'AfterSave');
    const FrameModal = DynamicImport.Import(_ABaseJS, 'FrameModal');
    const ExecutarValidarContabilizacaoCloud = DynamicImport.Import(_ABaseJS, 'ExecutarValidarContabilizacaoCloud');

	const requestData = function () {
		if (FormularioCreditoFederalSuspensao.getvalue('CHAVEDEBITOFED') && (!FormularioCreditoFederalSuspensao.getvalue('DATAPAGAMENTO'))) {
			$achave = FormularioCreditoFederalSuspensao.getvalue('CODIGOEMPRESA') + ';' +
					  FormularioCreditoFederalSuspensao.getvalue('CODIGOESTAB') + ';' +
					  FormularioCreditoFederalSuspensao.getvalue('CHAVEDEBITOFED');

			AJaxCadastroExecuteMethodGetProperty(_AFormName, 'CarregarDadosDebito', $achave, 'DataVencimento;ValorDebito;TipoInscr;InscrFed', requestDataSucesso);
		}
	}

	const requestDataSucesso = function (retorno) {
		FormularioCreditoFederalSuspensao.setvalue('DATAPAGAMENTO', retorno.data.DataVencimento);
		FormularioCreditoFederalSuspensao.setvalue('VALORCREDITO', retorno.data.ValorDebito);
		FormularioCreditoFederalSuspensao.setvalue('DARFTIPOINSCRFED', retorno.data.TipoInscr);
		FormularioCreditoFederalSuspensao.setvalue('DARFINSCRFED', retorno.data.InscrFed);
	}

	$('.ctrlDATAPAGAMENTO').on('focus.request', requestData);
	
	AfterSave.then((method) => {
        method(FormularioCreditoFederalSuspensao);
    });
	
	$("#framemodal").on("load", function() {		
		const contentWindow = this.contentWindow;
		
		FrameModal.then((method) => {
			method(contentWindow);
		});		
	});
	
	$("#detalheModal").on("hide.bs.modal", function(e) {
		const contentWindow = $("#framemodal").get(0).contentWindow;
		
		ExecutarValidarContabilizacaoCloud.then((method) => {
			method(contentWindow);
		});	
    });
})