const _AFormName = 'TnCtrDMCreditoMunicipal';
const _ABaseJS = 'PageScripts/nCtr/TnCtrContabilizacaoBase';

FormManager.afterCreateAllForms.subscribe(function () {
	let FormularioCreditoMunicipal = FormManager.byname(_AFormName, '');
	var DynamicImport = FormManager.getUtil('DynamicImport');
    const AfterSave = DynamicImport.Import(_ABaseJS, 'AfterSave');
    const FrameModal = DynamicImport.Import(_ABaseJS, 'FrameModal');
    const ExecutarValidarContabilizacaoCloud = DynamicImport.Import(_ABaseJS, 'ExecutarValidarContabilizacaoCloud');

	const requestData = function () {
		if (FormularioCreditoMunicipal.getvalue('CHAVEDEBITOMUN') && (!FormularioCreditoMunicipal.getvalue('DATAPAGAMENTO'))) {
			$achave = FormularioCreditoMunicipal.getvalue('CODIGOEMPRESA') + ';' +
				      FormularioCreditoMunicipal.getvalue('CODIGOESTAB') + ';' +
				      FormularioCreditoMunicipal.getvalue('CHAVEDEBITOMUN');
					  
			AJaxCadastroExecuteMethodGetProperty(_AFormName, 'CarregarDadosDebito', $achave, 'DataVencimento;ValorDebito', requestDataSucesso);
		}
	}

	const requestDataSucesso = function (retorno) {
		FormularioCreditoMunicipal.setvalue('DATAPAGAMENTO', retorno.data.DataVencimento);
		FormularioCreditoMunicipal.setvalue('VALORCREDITO', retorno.data.ValorDebito);
	}

	$('.ctrlDATAPAGAMENTO').on('focus.request', requestData);
		
	AfterSave.then((method) => {
        method(FormularioCreditoMunicipal);
    });
	
	$("#framemodal").on("load", function() {		
		const contentWindow = this.contentWindow;
		
		FrameModal.then((method) => {			
			method(contentWindow);
		});		
	});
	
	$("#detalheModal").on("hide.bs.modal", function(e) {
		const contentWindow = $("#framemodal").get(0).contentWindow;
		
		ExecutarValidarContabilizacaoCloud.then((method) => {
			method(contentWindow);
		});	
    });
});