FormManager.afterCreateAllForms.subscribe(function () {
	// Begin Declarations/Implementations

	const TnTPDia = "0";
	const TnTPSemana = "1";
	const TnTPMes = "2";
	//const TnTPAno = "3";
	const TnTPSIM = "1";
	const TnTPNAO = "0";
	
	const FRMDMJOBAGENDA = "TNDMJOBAGENDA";
	let FFrmDMJobAgenda = null;
	let FParamsDPJobAgenda = null;

	const HabilitarDebug = function (){
		/* Descomentar a linha 'debugger;' e abrir o console do navegador para depurar */
		//debugger;
	}

	const ModoEdicao = function (){
		return (FParamsDPJobAgenda != null) &&
					 (FParamsDPJobAgenda.PCODIGOJOBAGENDA != null) &&
					 (FParamsDPJobAgenda.PCODIGOJOBAGENDA != "");
	}

	const CarregarDMJobAgenda = function (){
		FormManager.loadCadastro({
			_ACadastro: FRMDMJOBAGENDA,
			_AAlias: '',
			_AFiltros: {CODIGOJOB: FParamsDPJobAgenda.PCODIGOJOB, CODIGOJOBAGENDA: FParamsDPJobAgenda.PCODIGOJOBAGENDA}
		});

		FFrmDMJobAgenda.focusFirstField();
	}

	const ConfigurarPeriodico = function () {
		let periodicoEnabled = FFrmDMJobAgenda.fieldbyName('PERIODICO').getvalue() == TnTPSIM;

		if (!periodicoEnabled) {
			disableCheck('REPETIRSEMANA_checkbox');
			ConfigurarNenhum();
		}

		FFrmDMJobAgenda.setvisible('REPETIRCADA', periodicoEnabled);
		FFrmDMJobAgenda.setenabled('REPETIRCADA', periodicoEnabled);
		FFrmDMJobAgenda.setrequired('REPETIRCADA', periodicoEnabled);

		FFrmDMJobAgenda.setvisible('PERIODICIDADE', periodicoEnabled);
		FFrmDMJobAgenda.setenabled('PERIODICIDADE', periodicoEnabled);
		FFrmDMJobAgenda.setrequired('PERIODICIDADE', periodicoEnabled);
		FFrmDMJobAgenda.setvalue('PERIODICIDADE', '0');
	}

	const disableCheck = function (fieldName) {
		FFrmDMJobAgenda.fields.forEach((field, index) => {
			if (field.nome.indexOf(fieldName) > -1) {
				if (!field.disabled()) {
					FFrmDMJobAgenda.setfieldvalue(field.nome, false);
					field.componente.change();
				}
			}
		});
	}

	const ConfigurarNenhum = function () {
		disableCheck('REPETIRSEMANA_checkbox');
		$("#ctrlREPETIRMES").html("");

		if (FFrmDMJobAgenda.fieldbyName('PERIODICO').getvalue() == TnTPNAO) {
			FFrmDMJobAgenda.fieldbyName('REPETIRCADA').setvalue(null);
		}

		FFrmDMJobAgenda.setvisible('REPETIRMES', false);
		FFrmDMJobAgenda.setrequired('REPETIRMES', false);
		FFrmDMJobAgenda.setvisible('ACAOFERIADOFINALSEMANA', false);		

		FFrmDMJobAgenda.setvisibleCheckListBox('REPETIRSEMANA', false);
		FFrmDMJobAgenda.setrequired('REPETIRSEMANA', false);
	}

	const ConfigurarDiaInteiro = function () {
		let periodicoEnabled = FFrmDMJobAgenda.fieldbyName('PERIODICO').getvalue() == TnTPSIM;
		let diaInteiroEnabled = FFrmDMJobAgenda.fieldbyName('DIAINTEIRO').getvalue() == TnTPSIM;

		if (periodicoEnabled) {
			FFrmDMJobAgenda.setfieldvalue("DIAINTEIRO_checkbox_1", !periodicoEnabled);
		}
		
		if(diaInteiroEnabled) {
			FFrmDMJobAgenda.setvisible('PERIODICIDADE', FFrmDMJobAgenda.getvalue("DIAINTEIRO_checkbox_1"));
			FFrmDMJobAgenda.setvalue('PERIODICIDADE', '0');

			FFrmDMJobAgenda.setvisible('REPETIRCADA', FFrmDMJobAgenda.getvalue("DIAINTEIRO_checkbox_1"));
			FFrmDMJobAgenda.setvisible('REPETIRSEMANA', FFrmDMJobAgenda.getvalue("DIAINTEIRO_checkbox_1"));
			FFrmDMJobAgenda.setvisible('REPETIRMES', FFrmDMJobAgenda.getvalue("DIAINTEIRO_checkbox_1"));
			FFrmDMJobAgenda.setvisible('ACAOFERIADOFINALSEMANA', FFrmDMJobAgenda.getvalue("DIAINTEIRO_checkbox_1"));
			ConfigurarNenhum();
		}
		else
		{
			FFrmDMJobAgenda.setvisible('PERIODICIDADE', !FFrmDMJobAgenda.getvalue("DIAINTEIRO_checkbox_1"));
			FFrmDMJobAgenda.setvisible('REPETIRCADA', !FFrmDMJobAgenda.getvalue("DIAINTEIRO_checkbox_1"));
			FFrmDMJobAgenda.setvisibleCheckListBox('REPETIRSEMANA', !FFrmDMJobAgenda.getvalue("DIAINTEIRO_checkbox_1"));
			FFrmDMJobAgenda.setvisible('REPETIRMES', !FFrmDMJobAgenda.getvalue("DIAINTEIRO_checkbox_1"));
			FFrmDMJobAgenda.setvisible('ACAOFERIADOFINALSEMANA', !FFrmDMJobAgenda.getvalue("DIAINTEIRO_checkbox_1"));			
			ConfigurarNenhum();
		}
		
		FFrmDMJobAgenda.setenabled('REPETIRMINUTOS', !FFrmDMJobAgenda.getvalue("DIAINTEIRO_checkbox_1"));
		FFrmDMJobAgenda.setrequired('REPETIRMINUTOS', !FFrmDMJobAgenda.getvalue("DIAINTEIRO_checkbox_1"));

		FFrmDMJobAgenda.setenabledCheckListBox("DIAINTEIRO", !periodicoEnabled)
		
		FFrmDMJobAgenda.setenabled('HORARIO', (!FFrmDMJobAgenda.getvalue("DIAINTEIRO_checkbox_1")));
		FFrmDMJobAgenda.setvisible('HORARIO', (!FFrmDMJobAgenda.getvalue("DIAINTEIRO_checkbox_1")));
	}

	const ConfigurarComboBox = function () {
		let AData = FFrmDMJobAgenda.fieldbyName("DATAINICIAL").getvalue();
		let periodicoEnabled = FFrmDMJobAgenda.fieldbyName('PERIODICO').getvalue() == TnTPSIM;

		$("#ctrlREPETIRMES").html("");
		DesabilitarActionsPadrao();

		if (AData && periodicoEnabled) {
			let ADataArray = AData.split("-");
			if (ADataArray[0] && ADataArray[1] && ADataArray[2]) {
				let Data = new Date(ADataArray[0], ADataArray[1] - 1, ADataArray[2]);
				let AValor = weekAndDay(Data);
				$("#ctrlREPETIRMES").append(`<option value="${parseInt(ADataArray[2])}">Mensal no dia ${ADataArray[2]}</option>`);								
				$("#ctrlREPETIRMES").append(`<option value="${AValor.diaDaSemana}#${AValor.semanaDoMes}">Mensal no(a) ${AValor.weekOfMonth}</option>`);
			}
		}
	}

	const DesabilitarActionsPadrao = function () {
		$("#btnActDataSetPostExecuteOptsTNDMJOBAGENDA").addClass("disabled");
		$("#btnActDataSetPostExecuteOptsTNDMJOBAGENDA").html("");
	}

	const weekAndDay = function (date) {
		let days = ["º Domingo", "ª Segunda-Feira", "ª Terça-Feira", "ª Quarta-Feira", "ª Quinta-Feira", "ª Sexta-Feira", "º Sábado"],
			prefixes = ["1", "2", "3", "4", "5"];

		let obj = {
			diaDaSemana: date.getDay() + 1,
			semanaDoMes: prefixes[Math.floor(date.getDate() / 7)],
			weekOfMonth: prefixes[Math.floor(date.getDate() / 7)] + " " + days[date.getDay()]
		};
		return obj;
	}

	const ConfigurarPeriodicidade = function () {
		switch (FFrmDMJobAgenda.fieldbyName('PERIODICIDADE').getvalue()) {
			case TnTPSemana: ConfigurarSemana();
				break;
			case TnTPMes: ConfigurarMes();
				break;
			default: ConfigurarNenhum();
		}
	}

	const ConfigurarSemana = function () {
		$("#ctrlREPETIRMES").html("");
		FFrmDMJobAgenda.setvisible('REPETIRMES', false);
		FFrmDMJobAgenda.setrequired('REPETIRMES', false);
		
		FFrmDMJobAgenda.setvisible('ACAOFERIADOFINALSEMANA', false);

		FFrmDMJobAgenda.setvisibleCheckListBox('REPETIRSEMANA', true);
		FFrmDMJobAgenda.setrequired('REPETIRSEMANA', true);
	}

	const ConfigurarMes = function () {
		disableCheck('REPETIRSEMANA_checkbox');
		FFrmDMJobAgenda.setvisible('REPETIRMES', true);
		FFrmDMJobAgenda.setrequired('REPETIRMES', true);
		FFrmDMJobAgenda.setvisible('ACAOFERIADOFINALSEMANA', true);

		FFrmDMJobAgenda.setvisibleCheckListBox('REPETIRSEMANA', false);
		FFrmDMJobAgenda.setrequired('REPETIRSEMANA', false);
		ConfigurarComboBox();
	}
	
	const CloseModal = function() {
		setTimeout(() => {
			window.parent.$('#detalheModal').modal('hide');        
		}, 500);
	}	

	const DefaultRepetirCada = function (){
		if (FFrmDMJobAgenda.fieldbyName('PERIODICO').getvalue() == TnTPNAO) {
			FFrmDMJobAgenda.fieldbyName('REPETIRCADA').setvalue(null);
		} else {
			FFrmDMJobAgenda.fieldbyName('REPETIRCADA').setvalue(1);
		}
	}	
	

  // End Declarations/Implementations
  // =================================================================
  // Begin

  //primeiro método sempre
  HabilitarDebug();
  //primeiro método sempre

	if (WizardManager.context.DetalheAtivo == FRMDMJOBAGENDA) {
		FFrmDMJobAgenda = FormManager.byname(FRMDMJOBAGENDA);
		FParamsDPJobAgenda = WizardManager.context.Params;

		let Horario = new Date();
		Horario.setMinutes(Horario.getMinutes() + 5);
		Horario = moment(Horario).format('HH:mm');

		FFrmDMJobAgenda.getcomponent('PERIODICO').change(DefaultRepetirCada);
		FFrmDMJobAgenda.fieldbyName('REPETIRMINUTOS').setvalue(30);
		FFrmDMJobAgenda.fieldbyName('SOBDEMANDA').setvalue(TnTPNAO);
		FFrmDMJobAgenda.fieldbyName('HORARIO').setvalue(Horario);
		FFrmDMJobAgenda.getcomponent("PERIODICO").change(ConfigurarPeriodico);
		FFrmDMJobAgenda.getcomponent("PERIODICIDADE").change(ConfigurarPeriodicidade);
		FFrmDMJobAgenda.getcomponent("DATAINICIAL").change(ConfigurarComboBox);
		FFrmDMJobAgenda.getcomponent("DIAINTEIRO").change(ConfigurarDiaInteiro);

		if (ModoEdicao()){
			CarregarDMJobAgenda()
			setTimeout(function () { $('#btnFiltrar').click() }, 100);
		}

		FFrmDMJobAgenda.setvalue('CODIGOJOB', WizardManager.context.Params.PCODIGOJOB);
		FFrmDMJobAgenda.setvalue('CODIGOJOBRESULT', WizardManager.context.Params.PCODIGOJOBRESULT);
		FFrmDMJobAgenda.fieldbyName('PERIODICO').setvalue(TnTPNAO);
		FFrmDMJobAgenda.fieldbyName('PERIODICIDADE').setvalue(TnTPDia);
		ConfigurarPeriodico();
		ConfigurarPeriodicidade();
		DesabilitarActionsPadrao();

		FFrmDMJobAgenda.AfterSave.subscribe((options) => {
			let wizardContext = options.wizardContext;
	
			if (options.success) {
				GoToWizardItem(wizardContext.DetalheProximo);
			}
		});
	
		FFrmDMJobAgenda.fieldbyName('PERIODICO').setvalue(TnTPNAO);
		ConfigurarComboBox();
		ConfigurarPeriodico();
		
		if (FParamsDPJobAgenda.POBJETOJOBIMPORTACAOCOTACOES_CHECKBOX_0.toLowerCase() == 'true') {
			FFrmDMJobAgenda.OnWizardNext.subscribe(CloseModal);
		}		
		
	}

	WizardManager.setCustomEvent(FRMDMJOBAGENDA, function() {
		$("#btnActDataSetPostExecuteTNDMJOBAGENDA").click();
	});

});

$(".card-header").eq(1).hide();


$('#btnFiltrar').hide();

$("#ctrlREPETIRSEMANAcheck").removeClass('checkbox-wrapper');
$("#ctrlREPETIRSEMANAcheck").addClass('kt-checkbox-inline');