const FORMNAMEJOBCONFIGSERVICO = "TNDMJOBCONFIGSERVICO";

var FFormJobConfigServico;

function VerificaRetornoConfigServico (json) {
	if (json.data.result != null){	
		if (json.data.result.Mensagem != null){
			criarDialogOk(json.data.result.Mensagem, 'Informação');
		}else if (json.data.result.Error != null){
			FormatErrorMessage(json.data.result.Error);
		} else {
			FormatErrorMessage('Não foi possível carregar o retorno!');
		}
	} else {
		FormatErrorMessage('Mensagem de retorno não é válida!');
	}
}

function ActVerificarQuantidadeExecutores(){
	let AServer = FFormJobConfigServico.fieldbyName('SERVIDOR').getvalue();
	let APorta = FFormJobConfigServico.fieldbyName('PORTANWEB').getvalue();
	let parametro = ' ';

	if ((AServer.trim() !== '') && (APorta.trim() !== ''))
		parametro = 'http://' + AServer + ':' + APorta + '/';

	AJaxProcessoExecuteMethodGetProperty({_AClass: 'TnQuiuDPTestarConexao',
										  _AMethodName: 'VerificarQtdExecutores',
										  _AValues: parametro,
										  _ANamePropertys: '',
										  onSuccess: VerificaRetornoConfigServico});
}

FormManager.afterCreateAllForms.subscribe(function () {
	FFormJobConfigServico = FormManager.byname(FORMNAMEJOBCONFIGSERVICO);

	const ConfigurarCampo = function () {
		let ABool = FFormJobConfigServico.fieldbyName('ATIVO').getvalue() == "1";
		ConfigurarVisual(ABool);
	}

	const ConfigurarVisual = function (_ABool) {
		EdEnabledRequiredField("USUARIO", _ABool);
		EdEnabledRequiredField("SENHA", _ABool);
		FFormJobConfigServico.setrequired("CHAVEACESSO", _ABool);
		EdEnabledRequiredField("SERVIDOR", _ABool);
		EdEnabledRequiredField("PORTA", _ABool);
	}

	const EdEnabledRequiredField = function (_AField, _ABool) {
		FFormJobConfigServico.setrequired(_AField, _ABool);

		FFormJobConfigServico.setenabled(_AField, _ABool);
		if (!_ABool) FFormJobConfigServico.setvalue(_AField, "");
	}

	FFormJobConfigServico.getcomponent("ATIVO").change(ConfigurarCampo);

	FFormJobConfigServico.setvalue("CODIGOJOBCONFIGSERVICO", "1");

	setTimeout(() => {
		$("#tbtnactDataSetRefreshExecuteTNDMJOBCONFIGSERVICO").click();
		ConfigurarCampo();
	}, 500);
});