FormManager.afterCreateAllForms.subscribe(function() {

    $("#framemodal").on("load", function() {
        const contentWindow = this.contentWindow;
        if (!contentWindow.FormManager) return;

        contentWindow.FormManager.runAfterCreateAllForms((FormManagerModal, items) => {                       
            let form205 = FormManagerModal.byname('TnFisDMEfdUnidImobCustoInc', '');                                                                
            if(form205 && form205.nome == 'TnFisDMEfdUnidImobCustoInc') {                
                config205(form205);
            }             
            let form210 = FormManagerModal.byname('TnFisDMEfdUnidImobCustoOrc', '');                                                    
            if (form210 && form210.nome == 'TnFisDMEfdUnidImobCustoOrc') {                     
                config210(form210);             
            }        
        })   
    })

    // #region F205 - Custo Incorrido Unidade Imobiliária
    function config205 (form) {
        SetEnableTotalizadoresdUnidImobCustoInc();
        form.getcomponent('VLCUSINCACUMANT').blur(RecalcTotCustoBaseCalc);
        form.getcomponent('VLCUSINCPERESC').blur(RecalcTotCustoBaseCalc);
        form.getcomponent('VLEXCBCCUSINCACUM').blur(RecalcTotCustoBaseCalc);                        
        form.getcomponent('ALIQPIS').blur(RecalcCSTPISPASEP);
        form.getcomponent('ALIQCOFINS').blur(RecalcTotCSTCofins);     

        function SetEnableTotalizadoresdUnidImobCustoInc() {                
            form.setenabled('VLCUSINCACUM', false);   
            form.setenabled('VLBCCUSINC', false);                                   
            form.setenabled('VLCREDPISACUM', false);   
            form.setenabled('VLCREDPISDESC', false);                   
            form.setenabled('VLCREDPISDESCANT', false);
            form.setenabled('VLCREDPISDESCFUT', false);
            form.setenabled('VLCREDCOFINSACUM', false);
            form.setenabled('VLCREDCOFINSDESCANT', false);                
            form.setenabled('VLCREDCOFINSDESC', false);                                
            form.setenabled('VLCREDCOFINSDESCFUT', false);                                                                
        }        

        // #region Cálculo Custo Base de Cálculo
        function RecalcTotCustoBaseCalc() {
            var AliqPIS = (form.getvalue('ALIQPIS'));         
            var AliqCofins = (form.getvalue('ALIQCOFINS'));                         

            CalcTotCustoIncAcumuladoPeriodoAtual();
            CalcCreditoCustoIncAcumuPeriodo();                

            if (![null,''].includes(AliqPIS)) {                    
                RecalcCSTPISPASEP();
            };             

            if (![null, ''].includes(AliqCofins)){
                RecalcTotCSTCofins();    
            };
        }

        function CalcTotCustoIncAcumuladoPeriodoAtual() {               
            var TotCustIncAcumuladoMesAnt = (form.getvalue('VLCUSINCACUMANT').replaceAll('.','').replaceAll(',','.'));                                           
            var TotCustIncPeriodo = (form.getvalue('VLCUSINCPERESC').replaceAll('.','').replaceAll(',','.'));                
            // Vl. Tot Custo Inc. Acumulado Período Atual                                               
            form.setvalue('VLCUSINCACUM', ((TotCustIncAcumuladoMesAnt*1)+(TotCustIncPeriodo*1)));
        }           

        function  CalcCreditoCustoIncAcumuPeriodo() {
            var TotCustIncAcumuladoMesAnt = (form.getvalue('VLCUSINCACUMANT').replaceAll('.','').replaceAll(',','.'));           
            var TotCustIncPeriodo = (form.getvalue('VLCUSINCPERESC').replaceAll('.','').replaceAll(',','.'));        
            var CusIncSemDireitoCredAcumuladoPer =(form.getvalue('VLEXCBCCUSINCACUM').replaceAll('.','').replaceAll(',','.'));                        
            // Vl. Base Calculo Credito Sobre Custo Inc. Acumulado Periodo
            form.setvalue('VLBCCUSINC', ( (TotCustIncAcumuladoMesAnt*1) + (TotCustIncPeriodo*1)) - (CusIncSemDireitoCredAcumuladoPer*1));        
        } 
        // #endregion          

        // #region Cálculo CST PIS/PASEP
        function RecalcCSTPISPASEP() {
            CalcTotCredPISAcumuladoCustoIncorrido();
            CalcCredPISDescontadoPeriodoAnt();    
            CalcCredPISDescontarPeriodo();               
            CalcularCreditoPISDescPeriodosFuturos();
        }

        function CalcTotCredPISAcumuladoCustoIncorrido(){
            var VlBaseCalcCredCustIncAcumuPeriodo = (form.getvalue('VLBCCUSINC').replaceAll('.','').replaceAll(',','.'));
            var AliqPIS = (form.getvalue('ALIQPIS').replaceAll('.','').replaceAll(',','.'));
          
            form.setvalue('VLCREDPISACUM', ((VlBaseCalcCredCustIncAcumuPeriodo) * ((AliqPIS*1)/100) ).toFixed(2));                
        }

        function CalcCredPISDescontadoPeriodoAnt() {
            var VlCredPISDescontadoPeriodoAnt = (form.getvalue('VLCREDPISDESCANT').replaceAll('.','').replaceAll(',','.'));           
            var vlCredPISDescontarPeriodo  = (form.getvalue('VLCREDPISDESC').replaceAll('.','').replaceAll(',','.'));                   
            //Crédito PIS Descontado Período Anterior
            // Será verificado com o analista.
            // if ([null, ''].includes(VlCredPISDescontadoPeriodoAnt)) {
                // form.setvalue('VLCREDPISDESCANT', VlCredPISDescontadoPeriodoAnt + vlCredPISDescontarPeriodo );             
            // } else {
                form.setvalue('VLCREDPISDESCANT', 0.00 );             
            // }               
        }           

        function CalcCredPISDescontarPeriodo() {
            var PerctRecF200 = gridManager.grids.get("TnFisDMEfdUnidImobVendida").getSelectedRowsData()[0].PERCRECRECEB;
            var TotCredPisAcumuladoCusIncorrido = (form.getvalue('VLCREDPISACUM').replaceAll('.','').replaceAll(',','.'));
            var VlCredPisDescPeriodoAnt = (form.getvalue('VLCREDPISDESCANT').replaceAll('.','').replaceAll(',','.'));               
            //Crédito PIS a Descontar no Período                        
            form.setvalue('VLCREDPISDESC',( ((TotCredPisAcumuladoCusIncorrido*1) - (VlCredPisDescPeriodoAnt*1)) * PerctRecF200 / 100 ));
        }
     
        function CalcularCreditoPISDescPeriodosFuturos(){
            var TotCredPisAcumuladoCusIncorrido = (form.getvalue('VLCREDPISACUM').replaceAll('.','').replaceAll(',','.'));            
            var VlCredPisDescPeriodoAnt = (form.getvalue('VLCREDPISDESCANT').replaceAll('.','').replaceAll(',','.'));            
            var VlCredPISDescontarPeriodo = (form.getvalue('VLCREDPISDESC').replaceAll('.','').replaceAll(',','.'));
            //Crédito PIS Descontar Períodos Futuros 
            form.setvalue('VLCREDPISDESCFUT',( (TotCredPisAcumuladoCusIncorrido*1) - ((VlCredPisDescPeriodoAnt*1) + (VlCredPISDescontarPeriodo*1))));
        }       
        // #endregion

        // #region Cálculo CST COFINS
        function RecalcTotCSTCofins() {
            CalcCreditoCOFINSAcumCustoIncorrido(); 
            CalcCreditoCOFINSDescPerAnterior();
            CalcCreditoOFINSDescPeriodo();
            CalcCreditoCOFINSDescPeriodosFuturos();
        }

        function CalcCreditoCOFINSAcumCustoIncorrido() {
            var VlBaseCalcCredCustIncAcumuPeriodo = (form.getvalue('VLBCCUSINC').replaceAll('.','').replaceAll(',','.'));                
            var AliqCofins = (form.getvalue('ALIQCOFINS').replaceAll('.','').replaceAll(',','.'));         

            // Vl. Tot Crédito COFINS Acum. Custo Incorrido                                           
            form.setvalue('VLCREDCOFINSACUM', ( (VlBaseCalcCredCustIncAcumuPeriodo*1) * ((AliqCofins*1) / 100)));                                       
        }

        function CalcCreditoCOFINSDescPerAnterior(){                       
            var VlCredCOFINSDescAnt = (form.getvalue('VLCREDCOFINSDESCANT').replaceAll('.','').replaceAll(',','.'));
            var VlCredCOFINSDesc = (form.getvalue('VLCREDCOFINSDESC').replaceAll('.','').replaceAll(',','.'));
            // Será verificado com o analista.
            // Crédito COFINS Desc. Período Anterior                                
            // if ([null, ''].includes(VlCredCOFINSDescAnt)){
            //     form.setvalue('VLCREDCOFINSDESCANT', ((VlCredCOFINSDescAnt*1) + (VlCredCOFINSDesc*1)));   
            // } else {
                form.setvalue('VLCREDCOFINSDESCANT', 0.00);    
            // }
        }           

        function CalcCreditoOFINSDescPeriodo() {
            var TotCredCOFINSAcumCustoIncorrido = (form.getvalue('VLCREDCOFINSACUM').replaceAll('.','').replaceAll(',','.'));
            var VlCredCOFINSDescAnt = (form.getvalue('VLCREDCOFINSDESCANT').replaceAll('.','').replaceAll(',','.'));
            var PerctRecF200 = gridManager.grids.get("TnFisDMEfdUnidImobVendida").getSelectedRowsData()[0].PERCRECRECEB; 
            // Crédito COFINS Desc. Período 
            form.setvalue('VLCREDCOFINSDESC',(((TotCredCOFINSAcumCustoIncorrido*1)-(VlCredCOFINSDescAnt*1))*((PerctRecF200*1)/100) ));                                   
        }       
        
        function CalcCreditoCOFINSDescPeriodosFuturos(){
            var TotCredCOFINSAcumCustoIncorrido = (form.getvalue('VLCREDCOFINSACUM').replaceAll('.','').replaceAll(',','.'));                
            var VlCredCOFINSDescAnt = (form.getvalue('VLCREDCOFINSDESCANT').replaceAll('.','').replaceAll(',','.'));                
            var VlCredCOFINSDescPeriodo =(form.getvalue('VLCREDCOFINSDESC').replaceAll('.','').replaceAll(',','.'));                                  
            // Crédito COFINS Desc. Períodos Futuros 
            form.setvalue('VLCREDCOFINSDESCFUT',( (TotCredCOFINSAcumCustoIncorrido*1)-(VlCredCOFINSDescAnt*1)-(VlCredCOFINSDescPeriodo*1)));
        }        
        // #endregion      
    }
    // #endregion 

    // #region F210 - Custo Orçado Unidade Imobiliária
    function config210 (form) {
                      
        SetEnableTotalizadoresdUnidImobCustoOrc();
        form.getcomponent('VLCUSORC').blur(RecalculoBaseCalcCredito);
        form.getcomponent('VLEXC').blur(RecalculoBaseCalcCredito);                
        form.getcomponent('ALIQPIS').blur(CalcularValorCreditoPIS);                                                
        form.getcomponent('ALIQCOFINS').blur(CalcularValorCreditoCOFINS);                      

        function SetEnableTotalizadoresdUnidImobCustoOrc() {
            form.setenabled('VLCUSORCAJU', false);
            form.setenabled('VLBCCRED', false);
            form.setenabled('VLCREDPISUTIL', false);
            form.setenabled('VLCREDCOFINSUTIL', false);
        }          

        // #region Cálculo Base de Cálculo Crédito
        function RecalculoBaseCalcCredito() {
            var AliqPIS = (form.getvalue('ALIQPIS'));  
            var AliqCOFINS = (form.getvalue('ALIQCOFINS'));   

            CalcularBCCredCustoOrcadoAjustado();
            CalcularBaseCalculoCredito();

            if (![null, ''].includes(AliqPIS)){
                CalcularValorCreditoPIS();  
            }

            if (![null, ''].includes(AliqCOFINS)){
                CalcularValorCreditoCOFINS();
            }               
        }
        
        function CalcularBCCredCustoOrcadoAjustado() {                
            var TotCusOrcado  = (form.getvalue('VLCUSORC').replaceAll('.','').replaceAll(',','.'));
            var VlExclusao = (form.getvalue('VLEXC').replaceAll('.','').replaceAll(',','.'));
            console.log('caiu 1')
            // Vl. Base Calc. Crédito Custo Orçado Ajustado                              
            console.log('TotCusOrcado = ' + TotCusOrcado);
            console.log('VlExclusao = ' + VlExclusao);
            form.setvalue('VLCUSORCAJU', ((TotCusOrcado*1)-(VlExclusao*1)));                                
        }

        function CalcularBaseCalculoCredito() {
            var PerctRecF200 = gridManager.grids.get("TnFisDMEfdUnidImobVendida").getSelectedRowsData()[0].PERCRECRECEB;
            var VlCredCustoOrcadoAjustado = (form.getvalue('VLCUSORCAJU').replaceAll('.','').replaceAll(',','.'));
            // Base de Cálculo do Crédito             
            form.setvalue('VLBCCRED', ((VlCredCustoOrcadoAjustado*1) * ( (PerctRecF200*1) / 100)));                                
        }          
        // #endregion

        function CalcularValorCreditoPIS(){
            var VlBaseCalcCredito = (form.getvalue('VLBCCRED').replaceAll('.','').replaceAll(',','.')); 
            var AliqPIS = (form.getvalue('ALIQPIS').replaceAll('.','').replaceAll(',','.'));  
            // Vl. Crédito PIS Utilizado
            form.setvalue('VLCREDPISUTIL', ((VlBaseCalcCredito*1) * ((AliqPIS*1) / 100)));                                
        }

        function CalcularValorCreditoCOFINS(){
            var VlBaseCalcCredito = (form.getvalue('VLBCCRED').replaceAll('.','').replaceAll(',','.')); 
            var AliqCOFINS = (form.getvalue('ALIQCOFINS').replaceAll('.','').replaceAll(',','.'));  
            // Vl. Crédito COFINS Utilizado
            form.setvalue('VLCREDCOFINSUTIL', ((VlBaseCalcCredito*1) * ((AliqCOFINS*1) / 100)));                                
        }            
    }

    // #endregion
})