FormManager.afterCreateAllForms.subscribe(function () {
	let form = FormManager.byname('TnFisDMLctoFisEnt', '');
	let saved = false;
	let formDetalheOutraEmpPgto = FormManager.byname('TnFisDMOutraEmpPgto', '');
	let CODIGOCFOP = '';
	
	form.getcomponent('SIGLAESTADOORIGEM').change(EnabledCamposLcto);
	form.getcomponent('SIGLAESTADODESTINO').change(EnabledCamposLcto);

	const DoAfterLoadData = function (data) {
		if (form.estado === FormState.cadInsert && data._EstadoCadastro === FormState.cadNavegando) {
			FormManager.itens.forEach((_AForm) => {
				if (_AForm.ehdetalhe && _AForm.masterclass === form.classe && _AForm.classe != 'TnFisDMDuplicataEntParcelaLcto') {
					_AForm.loadfromdata(data, _AForm.multiColumn);
				}
			});
		}
		VerificarHabilitarDetalhes();
	}
	
	let formNatureza = FormManager.byname('TnFisDMLctoFisEntCFOP', '');
	if (formNatureza) {
		formNatureza.getcomponent('CODIGOCFOP').on('blur', DoLeaveCodigoCFOP);	
		formNatureza.AfterSave.subscribe(function() {
			CadastrarOutrosNatureza();
			VerificarHabilitarDetalhes();		
		});
		formNatureza.afterDelete.subscribe(() => {
			VerificarHabilitarDetalhes();
		});
    }
	function DoLeaveCodigoCFOP() { CODIGOCFOP = formNatureza.getvalue('CODIGOCFOP'); };
	
	function CadastrarOutrosNatureza() {
		KTApp.blockPage();
		
		let formAtual = FormManager.byname('TnFisDMLctoFisEntCFOP', '');
		let params = JSON.stringify({
			'CODIGOEMPRESA': form.getvalue('CODIGOEMPRESA'),
			'CODIGOESTAB': form.getvalue('CODIGOESTAB'),
			'CODIGOCFOP': CODIGOCFOP.replace('.', '')
		});
		
		AJaxCadastroExecuteMethodGetProperty('TnFisDMLctoFisEnt', 'GetTemINSSRetidoAjax', params, '', (retorno) => {
            if (retorno.data.result) {
				params = JSON.stringify({
					'CODIGOEMPRESA': form.getvalue('CODIGOEMPRESA'),
					'CODIGOPESSOA': form.getvalue('CODIGOPESSOA')
				});
				AJaxCadastroExecuteMethodGetProperty('TnFisDMLctoFisEnt', 'CadastrarOutraEmpAjax', params, '',(retorno) => {
				});
            }
        });		
		KTApp.unblockPage();
	}
	
	function VerificarHabilitarDetalhes () {
		if (form.getvalue('CHAVELCTOFISENT') == '') return;
		KTApp.blockPage();
		AJaxCadastroExecuteMethodGetProperty('TnFisDMLctoFisEnt', 'VerificarHabilitarDetalhesCloudAjax', form.getvalue('CHAVELCTOFISENT'), '', (retorno) => {
			if (retorno.data.result.detalharItens) {
                $('li[data-id=tabTnFisDMLctoFisEntProduto]').show();
			} else {
                $('li[data-id=tabTnFisDMLctoFisEntProduto]').hide();
			}		
			if (retorno.data.result.complementares) {
				$('li[data-id=tabTnFisDMLctoFisEntCompl]').show();
			} else {
				$('li[data-id=tabTnFisDMLctoFisEntCompl]').hide();
			}
            if (retorno.data.result.difal) {
                $('li[data-id=tabTnFisDMLctoFisEntDIFAL]').show();
            } else {
                $('li[data-id=tabTnFisDMLctoFisEntDIFAL]').hide();
            }
            if (retorno.data.result.contabil) {
                $('li[data-id=tabTnFisDMLctoFisEntContabil]').show();
            } else {
                $('li[data-id=tabTnFisDMLctoFisEntContabil]').hide();
            }
            if (retorno.data.result.retidos) {
                $('li[data-id=tabTnFisDMLctoFisEntRetido]').show();
            } else {
                $('li[data-id=tabTnFisDMLctoFisEntRetido]').hide();
            }
            if (retorno.data.result.spedc120) {
                $('li[data-id=tabTnFisDMLctoFisEntSPEDC120]').show();
            } else {
                $('li[data-id=tabTnFisDMLctoFisEntSPEDC120]').hide();
            }
            if (retorno.data.result.substituicao) {
                $('li[data-id=tabTnFisDMLctoFisEntSubTribut]').show();
            } else {
                $('li[data-id=tabTnFisDMLctoFisEntSubTribut]').hide();
            }
            if (retorno.data.result.piscofins) {
                $('li[data-id=tabTnFisDMLctoFisEntPISCOFINS]').show();
            } else {
                $('li[data-id=tabTnFisDMLctoFisEntPISCOFINS]').hide();
            }
            if (retorno.data.result.spedc111) {
                $('li[data-id=tabTnFisDMLctoFisEntSpedC111]').show();
            } else {
                $('li[data-id=tabTnFisDMLctoFisEntSpedC111]').hide();
            }
            if (retorno.data.result.speda120) {
                $('li[data-id=tabTnFisDMLctoFisEntSPEDA120]').show();
            } else {
                $('li[data-id=tabTnFisDMLctoFisEntSPEDA120]').hide();
            }
            if (retorno.data.result.consumo) {
                $('li[data-id=tabTnFisDMLctoFisEntSPEDC500]').show();
            } else {
                $('li[data-id=tabTnFisDMLctoFisEntSPEDC500]').hide();
            }
            if (retorno.data.result.retencaoinss) {
                $('li[data-id=tabTnFisDMOutraEmpPgto]').show();
            } else {
                $('li[data-id=tabTnFisDMOutraEmpPgto]').hide();
            } if (retorno.data.result.funrural) {
                $('li[data-id=tabTnFisDMLctoFisEntFunrural]').show();
            } else {
                $('li[data-id=tabTnFisDMLctoFisEntFunrural]').hide();
            }
			if (retorno.data.result.AnexoRS) {
                $('li[data-id=tabTnFisDMLctoFisEntAnexoRS]').show();
            } else {
                $('li[data-id=tabTnFisDMLctoFisEntAnexoRS').hide();
            }
			
			$('li[data-id=tabTnFisDMDuplicataEntParcelaLcto]').hide();
			
            KTApp.unblockPage();
        });
    }

    const PreencherCampoNoDetalhe = function (e) {
		if (form.estado === FormState.cadInsert) {
			let ADicionario = $(e.currentTarget).data('dicionario');
			if (!ADicionario) {
				if ($(e.currentTarget).hasClass('datepicker')) {
					ADicionario = $(e.currentTarget).parents('div.input-group').find('input.hasdatepicker').attr('name');
				} else {
					ADicionario = $(e.currentTarget).attr('name');
				}
				ADicionario = ADicionario.substring(2); //remove o "p."		
			}
			const AValue = form.getvalue(ADicionario);
			if (AValue) {
				let formLctoFisEntRetido = FormManager.byname('TnFisDMLctoFisEntRetido', '');
				if (formLctoFisEntRetido){
					formLctoFisEntRetido.setvalue(ADicionario, AValue);
				}
			}
		}
	}

	const PreencherCampo = function (ACampo, AValor) {
		if (form.getvalue(ACampo) == '') {
			form.setvalue(ACampo, AValor);
			form.getcomponent(ACampo).change();
		}
	}

	function EnabledCamposLcto(){
		var tipodocsintegra = form.getvalue('CODIGOTIPODCTOSINTEGRA');
		var AEnabled = (form.configextra.UsaSINTEGRA) && (
			((tipodocsintegra >= 7) && (tipodocsintegra <= 11)) ||
			(tipodocsintegra == 26) || (tipodocsintegra == 27) || (tipodocsintegra == 57)
		);
		form.setenabled('MODALIDADEFRETE', AEnabled);
		form.setrequired('MODALIDADEFRETE', AEnabled);

		form.setenabled('CODIGOTIPODCTOSINTEGRA', !form.configextra.EhOpetanteSPED);
		form.setrequired('CODIGOTIPODCTOSINTEGRA', !form.configextra.EhOpetanteSPED);
		form.setenabled('CDMODELO', form.configextra.EhOpetanteSPED);
		form.setrequired('CDMODELO', form.configextra.EhOpetanteSPED);

		var cdmodelo = form.configextra.EhOpetanteSPED ? form.getvalue('CDMODELO') : form.getvalue('CODIGOTIPODCTOSINTEGRA');
		var AEnabled = (cdmodelo == '8') || (cdmodelo == '9') || (cdmodelo == '10') || (cdmodelo == '11') ||
			(cdmodelo == '1') || (cdmodelo == '1B') || (cdmodelo == '4') || (cdmodelo == '55') ||
			(cdmodelo == '57') || (cdmodelo == '65');
		
		form.setenabled('MODALIDADEFRETE', AEnabled);
		form.setrequired('MODALIDADEFRETE', AEnabled);
		
		form.setrequired('SIGLAESTADOORIGEM', (form.configextra.CFOPTransporte));														  
	    form.setenabled('SIGLAESTADOORIGEM', (form.configextra.CFOPTransporte));
		
		form.setrequired('SIGLAESTADODESTINO', (form.configextra.CFOPTransporte));														  
	    form.setenabled('SIGLAESTADODESTINO', (form.configextra.CFOPTransporte));
														 
		if ((form.configextra.CFOPTransporte) && (form.getvalue('SIGLAESTADOORIGEM') != '')){
	      form.setrequired('CODIGOMUNICORIGEM', new Date(form.configextra.DataLcto).getFullYear() >= 2018);
	      form.setenabled('CODIGOMUNICORIGEM', true);
		}
	    else{
	      form.setrequired('CODIGOMUNICORIGEM', false);
	      form.setenabled('CODIGOMUNICORIGEM', false);
	    };
														 
		if ((form.configextra.CFOPTransporte) && (form.getvalue('SIGLAESTADODESTINO') != '')){
	      form.setrequired('CODIGOMUNICDESTINO', new Date(form.configextra.DataLcto).getFullYear() >= 2018);
	      form.setenabled('CODIGOMUNICDESTINO', true);
		}
	    else{
	      form.setrequired('CODIGOMUNICDESTINO', false);
	      form.setenabled('CODIGOMUNICDESTINO', false);
	    };

		AEnabled = (cdmodelo == '1') || (cdmodelo == '4') ||
			(cdmodelo == '1B') || (cdmodelo == '55') ||
			(cdmodelo == '99') || (cdmodelo == '65') ||
			(cdmodelo == '3') || (cdmodelo == '3A') ||
			(cdmodelo == '3B');
		form.setenabled('INDPAGTO', AEnabled);

		AEnabled = (cdmodelo == '57') || (cdmodelo == '8') ||
			       (cdmodelo == '67') || (cdmodelo == '7') ||
			       (cdmodelo == '8b');
			
		if (document.getElementById('ctrlSIGLAESTADOORIGEM').disabled) {				   
			form.setenabled('SIGLAESTADOORIGEM', AEnabled);
		}
		
		if (document.getElementById('ctrlCODIGOMUNICORIGEM').disabled) {
			form.setenabled('CODIGOMUNICORIGEM', AEnabled);
		}
		
		if (document.getElementById('ctrlSIGLAESTADODESTINO').disabled) {				   
			form.setenabled('SIGLAESTADODESTINO', AEnabled);
		}
		
		if (document.getElementById('ctrlCODIGOMUNICDESTINO').disabled) {
			form.setenabled('CODIGOMUNICDESTINO', AEnabled);
		}

		AEnabled = (cdmodelo == '55') || (cdmodelo == '57') || (cdmodelo == '59') || (cdmodelo == '65') || (cdmodelo == '99');
		form.setenabled('CHAVENFEENT', AEnabled);
		if (form.configextra.EhOpetanteSPED) {
			form.setenabled('CHAVENFEENTREF', AEnabled);
		}

		KTApp.blockPage();
		AEnabled = (cdmodelo == '1') || (cdmodelo == '1B') || 
				   (cdmodelo == '4') || (cdmodelo == '55') || 
				   (cdmodelo == '65');
		
		if (AEnabled) {
			$('li[data-id=tabTnFisDMLCTOFISENTSPEDC105]').show();
			$('li[data-id=tabTnFisDMLctoFisEntSPEDC112]').show();
			$('li[data-id=tabTnFisDMLctoFisEntSPEDC113]').show();
			$('li[data-id=tabTnFisDMLctoFisEntSPEDC114]').show();
			$('li[data-id=tabTnFisDMLctoFisEntSPEDC116]').show();
		} else {
			$('li[data-id=tabTnFisDMLCTOFISENTSPEDC105]').hide();
			$('li[data-id=tabTnFisDMLctoFisEntSPEDC112]').hide();
			$('li[data-id=tabTnFisDMLctoFisEntSPEDC113]').hide();
			$('li[data-id=tabTnFisDMLctoFisEntSPEDC114]').hide();
			$('li[data-id=tabTnFisDMLctoFisEntSPEDC116]').hide();
		}
		
		AEnabled = (cdmodelo == '21') || (cdmodelo == '22');
		
		if (AEnabled) {
			$('li[data-id=tabTnFisDMLctoFisEntSPEDD500]').show();
		} else {
			$('li[data-id=tabTnFisDMLctoFisEntSPEDD500]').hide();
		}		
		KTApp.unblockPage();
		
		if (document.getElementById('ctrlSIGLAESTADOORIGEM').disabled) {				   
			form.setrequired('SIGLAESTADOORIGEM', false);
		}
		
		if (document.getElementById('ctrlSIGLAESTADODESTINO').disabled) {				   
			form.setrequired('SIGLAESTADODESTINO', false);
		}
		
		if (document.getElementById('ctrlCODIGOMUNICORIGEM').disabled) {				   
			form.setrequired('CODIGOMUNICORIGEM', false);
		}
		
		if (document.getElementById('ctrlCODIGOMUNICDESTINO').disabled) {				   
			form.setrequired('CODIGOMUNICDESTINO', false);
		}

		AEnabled = form.configextra.ApuraIPI;
		form.setenabled('BASECALCULOIPI', AEnabled);
		form.setenabled('VALORIPI', AEnabled);
		form.setenabled('ISENTASIPI', AEnabled);
		form.setenabled('OUTRASIPI', AEnabled);
		
		AEnabled = form.configextra.ApuraFunRural;
		form.setenabled('BASECALCULOFUNRURAL', AEnabled);
		form.setenabled('ALIQFUNRURAL', AEnabled);
		form.setenabled('VALORFUNRURAL', AEnabled);

		form.setrequired('CODIGOTIPODCTOSINTEGRA', !form.configextra.EhOpetanteSPED);
		form.setenabled('CODIGOTIPODCTOSINTEGRA', !form.configextra.EhOpetanteSPED);
		form.setrequired('EMITENTENF', form.configextra.UsaSINTEGRA);
		form.setenabled('EMITENTENF', form.configextra.UsaSINTEGRA);
		VerificarHabilitarDetalhes;
	}

	form.AfterLoadData = DoAfterLoadData;
	form.getcomponent('CODIGOTIPODCTOSINTEGRA').change(EnabledCamposLcto);
	form.getcomponent('DATALCTOFIS').focus(function () { PreencherCampo('DATALCTOFIS', form.configextra.DataLcto); });
	form.getcomponent('DATAEMISSAO').focus(function () { PreencherCampo('DATAEMISSAO', form.configextra.DataLcto); });
	form.getcomponent('CHAVELCTOFISENT').change(PreencherCampoNoDetalhe);
	form.getcomponent('CODIGOPESSOA').change(PreencherCampoNoDetalhe);
	form.getcomponent('NUMERONF').change(PreencherCampoNoDetalhe);
	form.getcomponent('ESPECIENF').change(PreencherCampoNoDetalhe);
	form.getcomponent('SERIENF').change(PreencherCampoNoDetalhe);
	form.getcomponent('SUBSERIENF').change(PreencherCampoNoDetalhe);
	form.getcomponent('DATALCTOFIS').change(PreencherCampoNoDetalhe);
	form.getcomponent('DATAEMISSAO').change(PreencherCampoNoDetalhe);
	form.getcomponent('VALORCONTABIL').change(PreencherCampoNoDetalhe);
	form.fieldbyName('CDMODELO').componente.on('change', function(e, options) {
		setTimeout(() => {
			ModeloChange(e, options);
		});	
	});


	function ModeloChange(e, options) {
		EnabledCamposLcto();
		if (options === undefined || !options.loadFromData) {
			setTimeout(function() { 
				nextFocus(e.currentTarget);	
			}, 300)
		}
	}

	EnabledCamposLcto();
	$('.ctrlCHAVENFEENT').on('focus.request', GerarChaveAcessoEmitente);

	function GerarChaveAcessoEmitente() {
		var cdmodelo = form.configextra.EhOpetanteSPED ? form.getvalue('CDMODELO') : form.getvalue('CODIGOTIPODCTOSINTEGRA');	
		if ((cdmodelo == '55') || (cdmodelo == '57') || (cdmodelo == '67')){	
			$achave = form.getvalue('CODIGOPESSOA') + ';' + form.getvalue('CODIGOEMPRESA') + ';' 
					+ form.getvalue('CODIGOESTAB') + ';' + form.getvalue('DATAEMISSAO') + ';' 
					+ form.getvalue('EMITENTENF') + ';' + form.getvalue('SERIENF') + ';'
					+ form.getvalue('NUMERONF');	
		
			if (form.getvalue('DATAEMISSAO')!='' &&
				form.getvalue('EMITENTENF') !='' &&
				form.getvalue('SERIENF')    !='' &&
				form.getvalue('NUMERONF')   !='' &&
				form.getvalue('CHAVENFEENT') == '')	{
				AJaxCadastroExecuteMethodGetProperty('TnFisDMLctoFisEnt', 'GerarChaveAcessoEmitenteAjax', $achave, '', (retorno) => {
					if (retorno.data.result) {
						form.setvalue('CHAVENFEENT', retorno.data.result);        
					}
				});		
			}
		}		
	}	
	$("#framemodal").on("load", function() {
		const contentWindow = this.contentWindow;
		if (!contentWindow.FormManager) return;
		saved = false;

		contentWindow.FormManager.runAfterCreateAllForms((FormManagerModal, items) => {
			form = FormManagerModal.byname('TnFpaDMOutraEmpPgtoServico', '');

			if(form && form.nome == 'TnFpaDMOutraEmpPgtoServico'){ 
				setTimeout(function() {
					
					if (!formDetalheOutraEmpPgto){
						formDetalheOutraEmpPgto = FormManager.byname('TnFisDMOutraEmpPgto', '');
					}

					if (formDetalheOutraEmpPgto) {
						form.setvalue('GPSORIGEM', formDetalheOutraEmpPgto.getvalue('GPSORIGEM'));
						HabilitarCamposConformePagamentosOutrasEmpresasServicos();
					
						form.setvalue('CODIGOOUTEMP', formDetalheOutraEmpPgto.getvalue('CODIGOOUTEMP'));
						form.setvalue('TIPOPAGAMENTO', formDetalheOutraEmpPgto.getvalue('TIPOPAGAMENTO')); 
						form.setvalue('CODIGOESTAB', formDetalheOutraEmpPgto.getvalue('CODIGOESTAB')); 
						form.setvalue('CLASSIFORGAN', formDetalheOutraEmpPgto.getvalue('CLASSIFORGAN'));
						form.setvalue('COMPET', formDetalheOutraEmpPgto.getvalue('COMPET'));
					}
				}, 300)
			}

			function HabilitarCamposConformePagamentosOutrasEmpresasServicos() {
				let form = FormManagerModal.byname('TnFpaDMOutraEmpPgtoServico', '');
				form.setenabled('BASESAT15ANOS', [1,2,3,6].includes(parseInt(form.getvalue('GPSORIGEM'))));
				form.setenabled('VALORSAT15ANOS', [1,2,3,6].includes(parseInt(form.getvalue('GPSORIGEM'))));
				
				form.setenabled('BASESAT20ANOS', [1,2,3,6].includes(parseInt(form.getvalue('GPSORIGEM'))));
				form.setenabled('VALORSAT20ANOS', [1,2,3,6].includes(parseInt(form.getvalue('GPSORIGEM'))));
				
				form.setenabled('BASESAT25ANOS', [1,2,3,6].includes(parseInt(form.getvalue('GPSORIGEM'))));
				form.setenabled('VALORSAT25ANOS', [1,2,3,6].includes(parseInt(form.getvalue('GPSORIGEM'))));
			}

			const formfirstUsable = items.firstUsable();
			if (formfirstUsable) {
				formfirstUsable.AfterSave.subscribe(function() {
					saved = true;
				});
			}				

		});
	
	});

	$("#detalheModal").on("hide.bs.modal", function(e) {
		let modal = $("#framemodal").get(0).contentWindow.FormManager.byname('TnFisDMContabilizacaoTemp');
		if (modal) {
			let params = {};
			params.sequencial = modal.getvalue('SEQUENCIAL');
			if (saved) {
				AJaxCadastroExecuteMethodGetProperty('TnFisDMLctoFisEnt', 'ValidarContabilizacaoCloud', JSON.stringify(params), '', ValidarContabilizacaoCloud);
			}
		}
    });	
});

function ActAbrirComplementarExecute() { AbrirDetalhe("TnFisDMLctoFisEntCompl"); }
function ActAbrirDifalFcpExecute() { AbrirDetalhe("TnFisDMLctoFisEntDIFAL"); }
function ActAbrirDetMunicExecute() { AbrirDetalhe("TnFisDMLctoFisEntDetMunicipioOrigem"); }
function ActAbrirRetidoExecute() { AbrirDetalhe("TnFisDMLctoFisEntRetido"); }

function AbrirDetalhe(_ADetalhe) {
	let form = FormManager.byname('TnFisDMLctoFisEnt', '');

	Scope = {};
	Scope.Class = _ADetalhe;
	Scope.Filtros = {};
	Scope.Filtros["CODIGOEMPRESA"] = form.getvalue('CODIGOEMPRESA');
	Scope.Filtros["CHAVELCTOFISENT"] = form.getvalue('CHAVELCTOFISENT');
	window.open("Cadastro?Scope=" + JSON.stringify(Scope), '_blank');
}

function AbrirCadastro(retorno){
	let result = retorno.data.result; 
	let filtro = {};

	if (result.InformarLcto) {
		filtro.SEQUENCIAL = result.Sequencial;
		filtro.INFORMAR   = 1;

		AbrirCadastroModal({
			_AClasse: 'TnFisDMContabilizacaoTemp',
			AFiltros: filtro,
			AGrid: null,
			ANovo: false,
			AChaveMestre: ['SEQUENCIAL', 'CODIGOEMPRESA', 'CHAVEORIGEM', 'SEQ'],
			AClasseForm: null,
		  });
	}
}

function actContabilizarCloudExecute(){
	AbrirContabilizacao();
}

function AbrirContabilizacao(){
	let form = FormManager.byname('TnFisDMLctoFisEnt', '');
	let params = form.getValues();
    AJaxCadastroExecuteMethodGetProperty('TnFisDMLctoFisEnt', 'ContabilizarCloud', JSON.stringify(params), '', finalizarContabilizacao);	
}

function ValidarContabilizacaoCloud(retorno) {
    let form = FormManager.byname('TnFisDMLctoFisEnt', '');
	let result = retorno.data.result; 
    let params = {};

	if (result.PossuiDiferenca) {
		criarDialogSimNao('Existem diferenças nos lançamentos contábeis! Deseja corrigir os lançamentos?', 
		                  'Confirmação', 
    		              (a) => { AbrirCadastro(retorno) }); 
	} else {
		params.params     = form.getValues(); 
		params.Sequencial = result.Sequencial;
		AJaxCadastroExecuteMethodGetProperty('TnFisDMLctoFisEnt', 'FinalizarContabilizacaoCloud', JSON.stringify(params), '', finalizarContabilizacao);
	}
}

function finalizarContabilizacao(){
	console.log('Contabilização finalizada!');
 }