FormManager.afterCreateAllForms.subscribe(function() {
    let formMestre = FormManager.byname('TnFisDMLctoFisEnt', '');
    let form = FormManager.byname('TnFisDMLctoFisEntCFOP', '');

    CarregarCamposConformeNatureza();
    
    form.getcomponent('VALORCONTABILIMPOSTO').change(AlterandoValorContabilImposto);
    form.getcomponent('BASECALCULOIMPOSTO').change(AlterandoBaseCalculoImposto);
    form.getcomponent('ALIQIMPOSTO').change(AlterandoAliqImposto);
    form.getcomponent('ISENTASIMPOSTO').change(AlterandoIsentasImposto);   
    form.getcomponent('CODIGOCFOP').blur(CarregarTipoImposto);
	form.getcomponent('CODIGOCFOP').blur(CarregarTabCTBFis);  	

    function CarregarCamposConformeNatureza(){
        if (form) {
            var subscriber = form.AfterLoadDataSubject.subscribe(function() {
                if (form.estado === FormState.cadInsert){
                    form.setvalue('VALORCONTABILIMPOSTO', formMestre.getvalue('VALORCONTABIL'));
                    form.setvalue('BASECALCULOIMPOSTO', formMestre.getvalue('VALORCONTABIL'));
                }
            });
        }
    }

    function AlterandoValorContabilImposto(){
    	CalcularValorIsentasImposto();
		CalcularValorOutrasImposto();
    }

    function AlterandoBaseCalculoImposto(){
        CalcularValorImposto();
		CalcularValorIsentasImposto();
		CalcularValorOutrasImposto();
    }

    function AlterandoAliqImposto(){
        CalcularValorImposto();
    }

    function AlterandoIsentasImposto(){
		CalcularValorOutrasImposto();
    }

    function CalcularValorImposto(){

        var BaseCalculoImposto  = (form.getvalue('BASECALCULOIMPOSTO').replace('.', '').replace(',', '.'));
        var AliqImposto         = (form.getvalue('ALIQIMPOSTO').replace('.', '').replace(',', '.'));
        form.setvalue('VALORIMPOSTO', ((BaseCalculoImposto * AliqImposto) / 100).toFixed(2));
    }
	
	function CalcularValorIsentasImposto(){
		
		var ValorContabilImposto = (form.getvalue('VALORCONTABILIMPOSTO').replace('.', '').replace(',', '.'));
		var BaseCalculoImposto 	 = (form.getvalue('BASECALCULOIMPOSTO').replace('.', '').replace(',', '.'));
		form.setvalue('ISENTASIMPOSTO', (ValorContabilImposto - BaseCalculoImposto).toFixed(2));
	}
	
	function CalcularValorOutrasImposto(){
		
		var ValorContabilImposto = (form.getvalue('VALORCONTABILIMPOSTO').replace('.', '').replace(',', '.'));
		var BaseCalculoImposto 	 = (form.getvalue('BASECALCULOIMPOSTO').replace('.', '').replace(',', '.'));
		var IsentasImposto 		 = (form.getvalue('ISENTASIMPOSTO').replace('.', '').replace(',', '.'));			
		form.setvalue('OUTRASIMPOSTO', ((ValorContabilImposto - BaseCalculoImposto) - IsentasImposto).toFixed(2));
	}

    function CarregarTipoImposto () {

        if (form.estado != FormState.cadInsert || form.getvalue('CODIGOCFOP') == '') return;
   
        $achave = formMestre.getvalue('CODIGOEMPRESA') + ';' + formMestre.getvalue('CODIGOESTAB') + ';' + form.getvalue('CODIGOCFOP');
		AJaxCadastroExecuteMethodGetProperty('TnFisDMLctoFisEntCFOP', 'GetTipoImpostoCloudAjax', $achave, '', (retorno) => {
		    if (retorno.data.result) {
                form.setvalue('TIPOIMPOSTO', retorno.data.result);        
			}
        });
    }
	function CarregarTabCTBFis () {

        if (form.estado != FormState.cadInsert || form.getvalue('CODIGOCFOP') == '') return;
   
        $achave = formMestre.getvalue('CODIGOEMPRESA') + ';' + formMestre.getvalue('CODIGOESTAB') + ';' + form.getvalue('CODIGOCFOP');
		AJaxCadastroExecuteMethodGetProperty('TnFisDMLctoFisSaiCFOP', 'GetTabCTBFisCloudAjax', $achave, '', (retorno) => {
		    if (retorno.data.result) {
                form.setvalue('CODIGOTABCTBFIS', retorno.data.result);        
			}
        });
    }	
});