FormManager.afterCreateDynamicForm.subscribe(function() {
    let form = FormManager.byname('TnFisDMLctoFisEntPISCOFINS', '');
    var DACONTIPORECEITA = 0;
    form.setenabledrequired('QUANTIDADE', false);
    form.getcomponent('SEQ').blur(VerificaItemSequencia);
    form.getcomponent('CODIGOPRODUTO').blur(VerificaItemProduto);

    function VerificaItemSequencia() {
        let formMaster = FormManager.byname('TnFisDMLctoFisEnt', '');
		if (form.getvalue('SEQ') !=''){
			$achave = formMaster.getvalue('CODIGOEMPRESA') + ';' + formMaster.getvalue('CHAVELCTOFISENT') + ';' + form.getvalue('SEQ');
			AJaxCadastroExecuteMethodGetProperty('TnFisDMLctoFisEntPISCOFINS', 'PossuiItemSequenciaCloud', $achave, '', (retorno) => {

				if (!retorno.data.result) {
					bootbox.dialog({
						message: 'Sequência Inexistente na Tela Detalhamento do Item e Serviço',
						title: '',
						buttons: {
							OK: {
								label: 'OK',
								className: "btn-success",
							}
						}
					});
				}
			});
		}
    }
 
    function VerificaItemProduto() {
        let formMaster = FormManager.byname('TnFisDMLctoFisEnt', '');
        if (formMaster.getvalue('CODIGOEMPRESA') && formMaster.getvalue('CHAVELCTOFISENT') && form.getvalue('CODIGOPRODUTO')) {
            $achave = formMaster.getvalue('CODIGOEMPRESA') + ';' + formMaster.getvalue('CHAVELCTOFISENT') + ';' + form.getvalue('CODIGOPRODUTO');

            AJaxCadastroExecuteMethodGetProperty('TnFisDMLctoFisEntPISCOFINS', 'PossuiItemProdutoCloud', $achave, '', (retorno) => {

                if (!retorno.data.result) {
                    form.setvalue('CODIGOPRODUTO','');
                    bootbox.dialog({
                        message: 'Produto Inexistente na Tela Detalhamento de Itens',
                        title: '',
                        buttons: {
                            OK: {
                                label: 'OK',
                                className: "btn-success",
                            }
                        }
                    });
                }
            });
        }
    }

    const EnableQuantidade = function() {

        var aenabled = false;
        if ((DACONTIPORECEITA == 10) || (DACONTIPORECEITA == 17) || (DACONTIPORECEITA == 34)) {
            aenabled = true;
        }

        form.setenabledrequired('QUANTIDADE', aenabled);
        if ((!aenabled) && (form.getvalue('QUANTIDADE') == '')) {
            form.setvalue('QUANTIDADE', 0);
        }
    }

    const RecalculaImpostoPIS = function() {
        if ((form.getvalue('QUANTIDADE') == 0) || (form.getvalue('QUANTIDADE') == '') || (form.getvalue('QUANTIDADE') == '0,0000')) {
            CalcularValorImposto('BASECALCULOPISCOFINS', 'ALIQPIS', 'VALORPIS');
        } else {
            CalcularValorQuantidade('ALIQPIS', 'VALORPIS');
        }
    }

    const RecalculaImpostoCofins = function() {
        if ((form.getvalue('QUANTIDADE') == 0) || (form.getvalue('QUANTIDADE') == '') || (form.getvalue('QUANTIDADE') == '0,0000')) {
            CalcularValorImposto('BASECALCULOPISCOFINS', 'ALIQCOFINS', 'VALORCOFINS');
        } else {
            CalcularValorQuantidade('ALIQCOFINS', 'VALORCOFINS');
        }
    }

    const CalcularValorQuantidade = function(_AFldAliq, _AFldValor) {
        var base = form.getvalueasnumeric('QUANTIDADE');
        var aliquota = form.getvalueasnumeric(_AFldAliq);
        form.setvalue(_AFldValor, (base * aliquota).toFixed(2));
    }

    const CalcularValorImposto = function(_AFldBase, _AFldAliq, _AFldValor) {
        var base = form.getvalueasnumeric(_AFldBase);
        var aliquota = form.getvalueasnumeric(_AFldAliq);
        form.setvalue(_AFldValor, ((base * aliquota) / 100).toFixed(2));
    }

    const requestDetalheProduto = function() {
        if (form.getvalue('CODIGOPRODUTO') != '') {
            let keys = [];

            if (form.getvalue('CODIGOEMPRESA') == '') {
                keys.push(SessionManager.selecao.CODIGOEMPRESA);
            } else {
                keys.push(form.getvalue('CODIGOEMPRESA'));
            };

            keys.push(form.getvalue('CODIGOPRODUTO'));

            AJaxCadastroExecuteMethodGetProperty('TnFisDMLctoFisEntPISCOFINS', 'GetDACONTIPORECEITA', keys.join(';'), '', requestDetalheProdutoSucessoAjax);
        }
    }

    const requestDetalheProdutoSucessoAjax = function(retorno) {

        var result = retorno.data.result;
	
        DACONTIPORECEITA = result.DACONTIPORECEITA;

        EnableQuantidade();

		form.setvalue('ALIQPIS',result.DACONALIQPISENT);	
		form.setvalue('ALIQCOFINS',result.DACONALIQCOFINSENT);	

        if (result.Mensagem != null) {
            bootbox.dialog({
                message: result.Mensagem,
                title: '',
                buttons: {
                    OK: {
                        label: 'OK',
                        className: "btn-success",

                    }
                }
            });
        }
    }

    const enableProdutoCfop = function() {
        var aenabled = form.getvalue('CODIGOPRODUTO') == '';
        form.setenabled('CODIGOPRODUTO', aenabled);
        form.setenabled('CODIGOCFOP', aenabled);
    }
	
	const requestDetalheProdutoPrenchimentoAutomatico = function () {
		if (form.getvalue('SEQ') != '') {
			let keys = [];

			if (form.getvalue('CODIGOEMPRESA') == '') {
				keys.push(SessionManager.selecao.CODIGOEMPRESA);
			}
			else {
				keys.push(form.getvalue('CODIGOEMPRESA'));
			};

			if (form.masterclass != null && ((form.getvalue('CHAVELCTOFISENT') == '') || (form.getvalue('CHAVELCTOFISENT') == '0'))) {
				const masterForm = FormManager.byname(form.masterclass);

				keys.push(masterForm.getvalue('CHAVELCTOFISENT'));
			}
			else {
				keys.push(form.getvalue('CHAVELCTOFISENT'));
			};

			keys.push(form.getvalue('SEQ'));
			keys.push('True');
			AJaxCadastroExecuteMethodGetProperty('TnFisDMLctoFisEntPISCOFINS', 'VerificaExisteLctoProduto', keys.join(';'), '', resultDetalheProdutoPrenchimentoAutomatico);
		}
	}

    const resultDetalheProdutoPrenchimentoAutomatico = function(retorno) {

		var result = retorno.data.result.data;
		form.setvalue('CODIGOPRODUTO',result.CODIGOPRODUTO);	
		form.setvalue('CODIGOCFOP',result.CODIGOCFOP);	
		form.setvalue('BASECALCULOPISCOFINS',result.BASECALCULOPISCOFINS);	
		form.setvalue('TIPOCREDITOPIS',result.TIPOCREDITOPIS);			
		form.setvalue('TIPOCREDITO',result.TIPOCREDITO);			
		form.setvalue('CDSITUATRIBUTCOFINS',result.CDSITUATRIBUTCOFINS);			
		form.setvalue('CDSITUATRIBUTPIS',result.CDSITUATRIBUTPIS);		
		form.setvalue('VALORPIS',result.VALORPIS);	
		form.setvalue('VALORCOFINS',result.VALORCOFINS);	
		form.setvalue('RECEITAPISCOFINS',result.RECEITAPISCOFINS);
    }	

    form.getcomponent('SEQ').blur(enableProdutoCfop);
	form.getcomponent('SEQ').blur(requestDetalheProdutoPrenchimentoAutomatico);	
    form.getcomponent('RECEITAPISCOFINS').focus(requestDetalheProduto);
    form.getcomponent('CODIGOPRODUTO').change(requestDetalheProduto);
    form.getcomponent('ALIQPIS').blur(RecalculaImpostoPIS);
    form.getcomponent('ALIQCOFINS').blur(RecalculaImpostoCofins);
});