FormManager.afterCreateDynamicForm.subscribe(function (form) {
    let formAtual = FormManager.byname('TnFisDMLctoFisEntProduto', '');
	
	var Executor = new nExpressionExecutor();
	
	formAtual.getcomponent('VALORUNITARIO').change(CalcularTotal);
	formAtual.getcomponent('QUANTIDADE').change(CalcularTotal);
	formAtual.getcomponent('VALORTOTAL').change(CalcularUnitario);
	formAtual.getcomponent('QUANTIDADE').change(PegarMascara);

    var controleICMS = new ControleBaseIsentaOutras(formAtual, 'BASECALCULOICMS', 'ISENTASICMS', 'OUTRASICMS', 'VALORTOTAL', 'ALIQICMS', 'VALORICMS');
    var controleIPI = new ControleBaseIsentaOutras(formAtual, 'BASECALCULOIPI', 'ISENTASIPI', 'OUTRASIPI', 'VALORTOTAL', 'ALIQIPI', 'VALORIPI');
    var controleISS = new ControleBaseIsentaOutras(formAtual, 'BASECALCULOISS', 'ISENTASISS', 'OUTRASISS', 'VALORTOTAL', 'ALIQISS', 'VALORISS');
    var controleST = new ControleBaseIsentaOutras(formAtual, 'BASECALCULOSUBTRIBUT', 'ISENTASSUBTRIB', 'OUTRASSUBTRIB', 'VALORTOTAL', 'ALIQSUBTRIBUT', 'VALORSUBTRIBUT');

    formAtual.setrequired('OUTRASSUBTRIB', true);
    formAtual.setrequired('ISENTASSUBTRIB', true);

    formAtual.BeforePost = EnabledCamposProduto;

    EnabledCamposProduto();
	
	async function PegarMascara() {
		var decimalCount = Executor.execute(`EXTERNO("PEGARQTDCASASDECIMAIS", [${formAtual.getvalue("CODIGOEMPRESA")},${formAtual.getvalue("CODIGOESTAB")}])`);
		let mask = '#,##0.';
		let newMask = mask.padEnd(mask.length + (await decimalCount), '0');
		changeDataMask('QUANTIDADE', newMask);
		KTApp.unblockPage();
	}
});

function EnabledCamposProduto() {
    formAtual = FormManager.byname('TnFisDMLctoFisEntProduto', '');

    var FormLcto = FormManager.byname('TnFisDMLctoFisEnt', '');
    if (FormLcto != null) {
        formAtual.setvalue('DATALCTOFIS', FormLcto.getvalue('DATALCTOFIS'));
    }
    formAtual.setenabled('TIPOESTOQUE', formAtual.configextra.Industria);
    return Promise.resolve();
}

function actProdutos() {
    Scope = {};
    Scope.Class = 'TnGemDMProduto';
    window.open("Cadastro?Scope=" + JSON.stringify(Scope), '_blank');
}

function CalcularTotal(){
	formAtual = FormManager.byname('TnFisDMLctoFisEntProduto', '');
	
	if ((formAtual.getvalue('VALORUNITARIO') != '') && 
	    (formAtual.getvalue('QUANTIDADE') != '')) {
		var unitario = formAtual.getvalueasnumeric('VALORUNITARIO');
		var quantidade = formAtual.getvalueasnumeric('QUANTIDADE');
		var valor = (quantidade * unitario).toFixed(2);

		formAtual.setvalue('VALORTOTAL', valor);
	}	
}

function CalcularUnitario() {
	formAtual = FormManager.byname('TnFisDMLctoFisEntProduto', '');

	if ((formAtual.getvalue('VALORTOTAL') != '') && 
		(formAtual.getvalue('QUANTIDADE') != '') && 
		(formAtual.getvalue('VALORUNITARIO') == '')) {
		var total = formAtual.getvalueasnumeric('VALORTOTAL');
		var quantidade = formAtual.getvalueasnumeric('QUANTIDADE');
		var valor = (total / quantidade).toFixed(2);
		formAtual.setvalue('VALORUNITARIO', valor);
	}
}

function changeDataMask(fieldName, mask) {
    formAtual = FormManager.byname('TnFisDMLctoFisEntProduto', '');
	
    let field = formAtual.fieldbyName(fieldName);

	field.mudarMascaraValorMonetario(mask);
}