FormManager.afterCreateDynamicForm.subscribe(function () {
	ExecutarEntradaRetido();
});

FormManager.afterCreateAllForms.subscribe(function () {
	ExecutarEntradaRetido();
});

function ExecutarEntradaRetido() {
    let formAtual = FormManager.byname('TnFisDMLctoFisEntRetido', '');

    formAtual.getcomponent('CODIGOESTAB').change(DoChangeCodigoEstab);

	formAtual.getcomponent('CODIGOCFOP').attr('data-haschange', true);
	formAtual.fieldbyName('CODIGOCFOP').loadExpression.subscribe(ConfigCFOP);
	formAtual.getcomponent('CHAVELCTOFISENTRETIDO').change(requestConfigNota);
	formAtual.getcomponent('BASECALCULOIRRF').change(EnabledCamposRetido);
	formAtual.getcomponent('BASECALCULOPIS').change(EnabledCamposRetido);
	formAtual.getcomponent('BASECALCULOCOFINS').change(EnabledCamposRetido);
	formAtual.getcomponent('BASECALCULOINSS').change(EnabledCamposRetido);
	formAtual.getcomponent('BASECALCULOISSQN').change(EnabledCamposRetido);
	formAtual.getcomponent('BASECALCULOCSLL').change(EnabledCamposRetido);
	formAtual.getcomponent('CHAVELCTOFISENT').change(EnabledCamposRetido);
	  
	formAtual.getcomponent('DATALCTOFIS').focusin(CalcularDataLctFis);
	formAtual.getcomponent('DATAEMISSAO').focusin(CalcularDataEmissao);
	formAtual.getcomponent('DATAIRRF').focusin(CalcularDataIRRF);
	formAtual.getcomponent('DATAPGTOPISCOFINSCSLL').focusin(CalcularDataPgtoPisCofinsCsll);

	formAtual.getcomponent('CHAVELCTOFISENTRETIDO').change(DoFocusInChaveLctoFisEntRetido);
    formAtual.getcomponent('TOTALPISCOFINSCSLL').focusin(CalcularValorTotal);

	formAtual.getcomponent('BASECALCULOINSS').focusin(function () {
	    PreencherCampoRetidoEntrada('BASECALCULOINSS', formAtual.configextra.BaseCalculoINSS);
		EnabledCamposRetido('INSS');
	});
	formAtual.getcomponent('BASECALCULOISSQN').focusin(function () {
		PreencherCampoRetidoEntrada('BASECALCULOISSQN', formAtual.configextra.BaseCalculoISSQN);
		EnabledCamposRetido('ISSQN');
	});
	formAtual.getcomponent('BASECALCULOIRRF').focusin(function () {
		PreencherCampoRetidoEntrada('BASECALCULOIRRF', formAtual.configextra.BaseCalculoIRRF);
		EnabledCamposRetido('IRRF');
	});
	formAtual.getcomponent('BASECALCULOPIS').focusin(function () {
		PreencherCampoRetidoEntrada('BASECALCULOPIS', formAtual.configextra.BaseCalculoPIS);
		EnabledCamposRetido('PISCOFINSCSLL');
	});
	formAtual.getcomponent('BASECALCULOCOFINS').focusin(function () {
		PreencherCampoRetidoEntrada('BASECALCULOCOFINS', formAtual.configextra.BaseCalculoCOFINS);
		EnabledCamposRetido('PISCOFINSCSLL');
	});
	formAtual.getcomponent('BASECALCULOCSLL').focusin(function () {
		PreencherCampoRetidoEntrada('BASECALCULOCSLL', formAtual.configextra.BaseCalculoCSLL);
		EnabledCamposRetido('PISCOFINSCSLL');
	});
	formAtual.getcomponent('BASECALCULOIRPJ').focusin(function () {
		PreencherCampoRetidoEntrada('BASECALCULOIRPJ', formAtual.configextra.BaseCalculoIRPJ);
		EnabledCamposRetido('IRPJ');
	});

	formAtual.getcomponent('ALIQIRRF').focusin(function () { PreencherCampoRetidoEntrada('ALIQIRRF', formAtual.configextra.AliquotaIRRF); });
	formAtual.getcomponent('ALIQPIS').focusin(function () { PreencherCampoRetidoEntrada('ALIQPIS', formAtual.configextra.AliquotaPIS); });
	formAtual.getcomponent('ALIQIRPJ').focusin(function () { PreencherCampoRetidoEntrada('ALIQIRPJ', formAtual.configextra.AliquotaIRPJ); });
	formAtual.getcomponent('ALIQISSQN').focusin(function () { PreencherCampoRetidoEntrada('ALIQISSQN', formAtual.configextra.AliquotaISSQN); });
	formAtual.getcomponent('ALIQINSS').focusin(function () { PreencherCampoRetidoEntrada('ALIQINSS', formAtual.configextra.AliquotaINSS); });
	formAtual.getcomponent('ALIQCOFINS').focusin(function () { PreencherCampoRetidoEntrada('ALIQCOFINS', formAtual.configextra.AliquotaCOFINS); });
	formAtual.getcomponent('ALIQCSLL').focusin(function () { PreencherCampoRetidoEntrada('ALIQCSLL', formAtual.configextra.AliquotaCSLL); });

	formAtual.getcomponent('VALORIRRF').focusin(function () { CalcularImposto('BASECALCULOIRRF', 'ALIQIRRF', 'VALORIRRF'); });
	formAtual.getcomponent('VALORIRPJ').focusin(function () { CalcularImposto('BASECALCULOIRPJ', 'ALIQIRPJ', 'VALORIRPJ'); });
	formAtual.getcomponent('VALORISSQN').focusin(function () { CalcularImposto('BASECALCULOISSQN', 'ALIQISSQN', 'VALORISSQN'); });
	formAtual.getcomponent('VALORINSS').focusin(function () { CalcularImposto('BASECALCULOINSS', 'ALIQINSS', 'VALORINSS'); });
	formAtual.getcomponent('VALORPIS').focusin(function () { CalcularImposto('BASECALCULOPIS', 'ALIQPIS', 'VALORPIS'); });
	formAtual.getcomponent('VALORCOFINS').focusin(function () { CalcularImposto('BASECALCULOCOFINS', 'ALIQCOFINS', 'VALORCOFINS'); });
	formAtual.getcomponent('VALORCSLL').focusin(function () { CalcularImposto('BASECALCULOCSLL', 'ALIQCSLL', 'VALORCSLL'); });
}

function DoFocusInChaveLctoFisEntRetido() {
  formAtual = FormManager.byname('TnFisDMLctoFisEntRetido', '');
  const AFormMestre = FormManager.byname('TnFisDMLctoFisEnt', '');
  if (AFormMestre) {
	AFormMestre.fields.forEach((_AFieldMaster) => {
	  for (var i = 0; i < formAtual.fields.length; ++i) {
		const AFieldDet = formAtual.fields[i];
		if (_AFieldMaster.nome === AFieldDet.nome) {
		  AFieldDet.setvalue(_AFieldMaster.getvalue());
		  break;
		}
	  }
	});
	const AFormProduto = FormManager.byname('TnFisDMLctoFisEntProduto', '');
	if (AFormProduto) {
	  formAtual.setvalue('CODIGOCFOP', AFormProduto.getvalue('CODIGOCFOP'));
	}
  }
  formAtual.getcomponent('CODIGOCFOP').change();
}

function DoChangeCodigoEstab() {
  formAtual = FormManager.byname('TnFisDMLctoFisEntRetido', '');
  if (formAtual.estado === FormState.cadNavegando) {
	requestConfigNota();
  }
}

function CalcularValorTotal() {
  if (isCalcular('TOTALPISCOFINSCSLL')) {
	formAtual = FormManager.byname('TnFisDMLctoFisEntRetido', '');
	const valorContabil = +formAtual.getvalueasnumeric('VALORCONTABIL');
	var valor = CalcularValorImposto(valorContabil, formAtual.configextra.AliquotaPIS) +
	  CalcularValorImposto(valorContabil, formAtual.configextra.AliquotaCOFINS) +
	  CalcularValorImposto(valorContabil, formAtual.configextra.AliquotaCSLL);
	formAtual.setvalue('TOTALPISCOFINSCSLL', valor);
  }
}

function CalcularDataLctFis() {
  formAtual = FormManager.byname('TnFisDMLctoFisEntRetido', '');

  if (isCalcular('DATALCTOFIS')) {
	if (SessionManager.selecao.DATALCTOFIS_MAIORIGUAL) {
	  formAtual.setvalue('DATALCTOFIS', SessionManager.selecao.DATALCTOFIS_MAIORIGUAL);
	}
  }
}

function CalcularDataEmissao() {
  formAtual = FormManager.byname('TnFisDMLctoFisEntRetido', '');

  if (isCalcular('DATAEMISSAO')) {
	if (SessionManager.selecao.DATALCTOFIS_MAIORIGUAL) {
	  formAtual.setvalue('DATAEMISSAO', formAtual.getvalue('DATALCTOFIS'));
	}
  }
}

function CalcularDataIRRF() {
  formAtual = FormManager.byname('TnFisDMLctoFisEntRetido', '');

  if (isCalcular('DATAIRRF')) {
	formAtual.setvalue('DATAIRRF', formAtual.getvalue('DATALCTOFIS'));
  }
}

function CalcularDataPgtoPisCofinsCsll() {
  formAtual = FormManager.byname('TnFisDMLctoFisEntRetido', '');

  if (isCalcular('DATAPGTOPISCOFINSCSLL')) {
	if (SessionManager.selecao.DATALCTOFIS_MAIORIGUAL) {
	  formAtual.setvalue('DATAPGTOPISCOFINSCSLL', formAtual.getvalue('DATALCTOFIS'));
	}
  }
}

function isCalcular(Acampo) {
  formAtual = FormManager.byname('TnFisDMLctoFisEntRetido', '');

  const formInEditModes = formAtual.estado === FormState.cadInsert || formAtual.estado === FormState.cadAlterando;
  return (formInEditModes && !formAtual.getvalue(Acampo))
}

function PreencherCampoRetidoEntrada(Acampo, AValor) {
  formAtual = FormManager.byname('TnFisDMLctoFisEntRetido', '');

  if ((AValor > 0) && (formAtual.getvalue(Acampo) == '')) {
	formAtual.setvalue(Acampo, AValor);
	formAtual.fieldbyName(Acampo).componente.trigger('change');
  } else if (Acampo.indexOf('BASE') > -1) {
	formAtual.setvalue(Acampo, formAtual.getvalue('VALORCONTABIL'));
  }
}

function EnabledCamposRetido(_ANomeImposto) {
  const imposto = _ANomeImposto || '';

  formAtual = FormManager.byname('TnFisDMLctoFisEntRetido', '');

  if (!imposto) {
	// CONTABILIZA
	AEnabled = formAtual.configextra.Contabiliza != 0;
	formAtual.setenabled('CODIGOTABCTBFIS', AEnabled);

		AEnabled = formAtual.getvalue('CHAVELCTOFISENTRETIDO') == '';
		formAtual.setenabled('CODIGOPESSOA', AEnabled);
		formAtual.setenabled('NUMERONF', AEnabled);
		formAtual.setenabled('ESPECIENF', AEnabled);
		formAtual.setenabled('SERIENF', AEnabled);
		formAtual.setenabled('DATALCTOFIS', AEnabled);
		formAtual.setenabled('DATAEMISSAO', AEnabled);
		formAtual.setenabled('VALORCONTABIL', AEnabled);
		formAtual.setenabled('CODIGOCFOP', AEnabled);
	}
}

function PreencherAliquota(Acampo, Aliquota) {
  formAtual = FormManager.byname('TnFisDMLctoFisEntRetido', '');

  if ((Aliquota > 0) && (formAtual.getvalue(Acampo) == '')) {
	formAtual.setvalue(Acampo, Aliquota);
	formAtual.focarfield(Acampo);
  }
}

function CalcularImposto(_ABase, _AAliquota, _AImposto) {
  formAtual = FormManager.byname('TnFisDMLctoFisEntRetido', '');

  var base = formAtual.getvalueasnumeric(_ABase);
  var aliquota = formAtual.getvalueasnumeric(_AAliquota);

  result = CalcularValorImposto(base, aliquota);

  formAtual.setvalue(_AImposto, result);
  formAtual.focarfield(_AImposto);
}

function CalcularValorImposto(_ABase, _AAliquota) {
  if (_AAliquota != 0) {
	return +((_ABase * _AAliquota) / 100).toFixed(2);
  }
  return 0;
}

function ConfigCFOP(e) {
  requestConfigNota();

  if (e && e.originalEvent && e.originalEvent.which === 13) {
	nextFocus(formAtual.getcomponent('CODIGOCFOP'));
  }
}

function requestConfigNota() {
  formAtual = FormManager.byname('TnFisDMLctoFisEntRetido', '');

  if (formAtual.getvalue('CODIGOCFOP')) {
	KTApp.blockPage();
	var achave = +formAtual.getvalue('CHAVELCTOFISENT') + ';' +
	  +formAtual.getvalue('CODIGOEMPRESA') + ';' +
	  +formAtual.getvalue('CODIGOESTAB') + ';' +
	  +formAtual.getvalueasnumeric('CODIGOCFOP');

	var campos = 'Contabiliza;' +
	  'BaseCalculoINSS;BaseCalculoISSQN;BaseCalculoIRPJ;BaseCalculoIRRF;BaseCalculoPIS;BaseCalculoCOFINS;BaseCalculoCSLL;' +
	  'AliquotaPIS;AliquotaIRRF;AliquotaIRPJ;AliquotaISSQN;AliquotaINSS;AliquotaCOFINS;AliquotaCSLL';

	AJaxCadastroExecuteMethodGetProperty('TnFisDMLctoFisEntRetido', 'PegarConfig', achave, campos, requestConfigNotaSucessoAjax);
  } else {
	EnabledCamposRetido();
  }
}

function requestConfigNotaSucessoAjax(retorno) {
  formAtual = FormManager.byname('TnFisDMLctoFisEntRetido', '');

  var data = retorno.data;
  formAtual.configextra.Contabiliza = data.Contabiliza;
  formAtual.configextra.BaseCalculoINSS = data.BaseCalculoINSS;
  formAtual.configextra.BaseCalculoISSQN = data.BaseCalculoISSQN;
  formAtual.configextra.BaseCalculoIRPJ = data.BaseCalculoIRPJ;
  formAtual.configextra.BaseCalculoIRRF = data.BaseCalculoIRRF;
  formAtual.configextra.BaseCalculoPIS = data.BaseCalculoPIS;
  formAtual.configextra.BaseCalculoCOFINS = data.BaseCalculoCOFINS;
  formAtual.configextra.BaseCalculoCSLL = data.BaseCalculoCSLL;
  formAtual.configextra.AliquotaINSS = data.AliquotaINSS;
  formAtual.configextra.AliquotaISSQN = data.AliquotaISSQN;
  formAtual.configextra.AliquotaIRPJ = data.AliquotaIRPJ;
  formAtual.configextra.AliquotaIRRF = data.AliquotaIRRF;
  formAtual.configextra.AliquotaPIS = data.AliquotaPIS;
  formAtual.configextra.AliquotaCOFINS = data.AliquotaCOFINS;
  formAtual.configextra.AliquotaCSLL = data.AliquotaCSLL;
  formAtual.configextra.CodigoCFOP = data.CodigoCFOP;
  formAtual.configextra.CodigoEmpresa = data.CodigoEmpresa;
  formAtual.configextra.CodigoEstab = data.CodigoEstab;

  EnabledCamposRetido();

  KTApp.unblockPage();
}