FormManager.afterCreateAllForms.subscribe(function () {
	let form = FormManager.byname('TnFisDMLctoFisSai', '');
	let formDetRecebimento = FormManager.byname('TnFisDMRecebimento', '');
	form.AfterLoadData = DoAfterLoadData;

	form.getcomponent('CHAVELCTOFISSAI').change(PreencherCampoNoDetalhe);
	form.getcomponent('CODIGOTIPODCTOSINTEGRA').change(EnabledCamposLcto);
	form.getcomponent('SIGLAESTADOORIGEM').change(EnabledCamposLcto);
	form.getcomponent('DATALCTOFIS').focus(function(){PreencherCampoSai('DATALCTOFIS', form.configextra.DataLcto);});		
	form.fieldbyName('CDMODELO').componente.on('change', function(e, options) {
		setTimeout(() => {
			ModeloChange(e, options);
		});
	});

	var focadoNumeroNF = false;
	var ultimoNumeroNF = null;
	var ultimoNumeroNFSistema = null;

	form.getcomponent('NUMERONF').on('focus', DoEnterNumerNF);
	form.getcomponent('NUMERONF').on('blur', DoLeaveNumeroNF);
	form.getcomponent('NUMERONF').change(DoNumeroNFChange);

	EnabledCamposLcto();

	$("#framemodal").on("load", function() {

		const contentWindow = this.contentWindow;
	
		if (!contentWindow.FormManager) return;
	
		contentWindow.FormManager.runAfterCreateAllForms((FormManagerModal, items) => {
			const form = FormManagerModal.byname('TnFpaDMRecebimentoServico', '');
			if(form && form.nome == 'TnFpaDMRecebimentoServico'){ 
				setTimeout(function() {					
					
					if (!formDetRecebimento){
						formDetRecebimento = FormManager.byname('TnFpaDMRecebimentoServico', '');
					}
					
					if (formDetRecebimento) {
					    form.setvalue('GPSORIGEM', formDetRecebimento.getvalue('GPSORIGEM'));
					}
				}, 300)
			}
		});
	});

	function DoEnterNumerNF(){ focadoNumeroNF = true;}
	function DoLeaveNumeroNF(){ focadoNumeroNF = false;}

	function DoNumeroNFChange(){
	  if (focadoNumeroNF){
	    if (ultimoNumeroNFSistema != Number(form.getvalue('NUMERONF'))) {
	      ultimoNumeroNF = Number(form.getvalue('NUMERONF'));
	    }
	  }
	  else{
	    if (ultimoNumeroNF){
	      if (form.estado != FormState.cadNavegando){
	        form.setvalue('NUMERONF', Number(ultimoNumeroNF) + 1);
	        ultimoNumeroNF = Number(ultimoNumeroNF) +1;
	      }
	    }else {
	      ultimoNumeroNFSistema = Number(form.getvalue('NUMERONF'));
	    }    
	  }
	}

	function DoAfterLoadData(data) {
		if (form.estado === FormState.cadInsert && data._EstadoCadastro === FormState.cadNavegando) {
			FormManager.itens.forEach((_AForm) => {
				if (_AForm.ehdetalhe && _AForm.masterclass === form.classe && _AForm.classe != 'TnFisDMDuplicataSaiParcelaLcto') {
					_AForm.loadfromdata(data, _AForm.multiColumn);
				}
			});
		}
		VerificarHabilitarDetalhes();
	}
	let formNatureza = FormManager.byname('TnFisDMLctoFisSaiCFOP', '');
	if (formNatureza) {
		formNatureza.AfterSave.subscribe(function() {
			VerificarHabilitarDetalhes();
		});
		formNatureza.afterDelete.subscribe(() => {
			VerificarHabilitarDetalhes();
		});
	}

	function VerificarHabilitarDetalhes () {
		if (form.getvalue('CHAVELCTOFISSAI') == '') return;
		KTApp.blockPage();
		AJaxCadastroExecuteMethodGetProperty('TnFisDMLctoFisSai', 'VerificarHabilitarDetalhesCloudAjax', form.getvalue('CHAVELCTOFISSAI'), '', (retorno) => {
			if (retorno.data.result.detalharItens) {
                $('li[data-id=tabTnFisDMLctoFisSaiProduto]').show();
			} else {
                $('li[data-id=tabTnFisDMLctoFisSaiProduto]').hide();
			}			
			if (retorno.data.result.complementares) {
                $('li[data-id=tabTnFisDMLctoFisSaiCompl]').show();
			} else {
                $('li[data-id=tabTnFisDMLctoFisSaiCompl]').hide();
			}
            if (retorno.data.result.funrural) {
                $('li[data-id=tabTnFisDMLctoFisSaiFunrural]').show();
            } else {
                $('li[data-id=tabTnFisDMLctoFisSaiFunrural]').hide();
            }
			if (retorno.data.result.conhecimento) {
				$('li[data-id=tabTnFisDMLctoFisSaiConFrete]').show();
			} else {
				$('li[data-id=tabTnFisDMLctoFisSaiConFrete]').hide();
			}
            if (retorno.data.result.difal) {
                $('li[data-id=tabTnFisDMLctoFisSaiDIFAL]').show();
            } else {
                $('li[data-id=tabTnFisDMLctoFisSaiDIFAL]').hide();
            }
            if (retorno.data.result.retidos) {
                $('li[data-id=tabTnFisDMLctoFisSaiRetido]').show();
            } else {
                $('li[data-id=tabTnFisDMLctoFisSaiRetido]').hide();
            }
            if (retorno.data.result.contabil) {
                $('li[data-id=tabTnFisDMLctoFisSaiContabil]').show();
            } else {
                $('li[data-id=tabTnFisDMLctoFisSaiContabil]').hide();
            }
            if (retorno.data.result.substituicao) {
                $('li[data-id=tabTnFisDMLctoFisSaiSubTribut]').show();
            } else {
                $('li[data-id=tabTnFisDMLctoFisSaiSubTribut]').hide();
            }
            if (retorno.data.result.piscofins) {
                $('li[data-id=tabTnFisDMLctoFisSaiPISCOFINS]').show();
            } else {
                $('li[data-id=tabTnFisDMLctoFisSaiPISCOFINS]').hide();
            }
            if (retorno.data.result.spedc111) {
                $('li[data-id=tabTnFisDMLctoFisSaiSpedC111]').show();
            } else {
                $('li[data-id=tabTnFisDMLctoFisSaiSpedC111]').hide();
            }
            if (retorno.data.result.consumo) {
                $('li[data-id=tabTnFisDMLCTOFISSAISPEDC500]').show();
                $('li[data-id=tabTnFisDMLCTOFISSAIPRODUTOSPEDC510]').show();
            } else {
                $('li[data-id=tabTnFisDMLCTOFISSAISPEDC500]').hide();
                $('li[data-id=tabTnFisDMLCTOFISSAIPRODUTOSPEDC510]').hide();
            }
			if (retorno.data.result.retencoescontprevservpres) {
                $('li[data-id=tabTnFisDMRecebimento]').show();
            } else {
                $('li[data-id=tabTnFisDMRecebimento]').hide();
            }
			if (retorno.data.result.AnexoRS) {
                $('li[data-id=tabTnFisDMLctoFisSaiAnexoRS]').show();
            } else {
                $('li[data-id=tabTnFisDMLctoFisSaiAnexoRS').hide();
            }		

			$('li[data-id=tabTnFisDMDuplicataSaiParcelaLcto]').hide();

            KTApp.unblockPage();
        });
    }

	function PreencherCampoNoDetalhe(e) {
		
		if (form.estado === FormState.cadInsert) {
			let ADicionario = $(e.currentTarget).data('dicionario');
			if (!ADicionario) {
				if ($(e.currentTarget).hasClass('datepicker')) {
					ADicionario = $(e.currentTarget).parents('div.input-group').find('input.hasdatepicker').attr('name');
				} else {
					ADicionario = $(e.currentTarget).attr('name');				
				}	
				ADicionario = ADicionario.substring(2); //remove o "p."		
			}		
			const AValue = form.getvalue(ADicionario);
			if (AValue) {
				let formLctoFisSaiRetido = FormManager.byname('TnFisDMLctoFisSaiRetido', '');
				if (formLctoFisSaiRetido){
					formLctoFisSaiRetido.setvalue(ADicionario, AValue);
				}
			}		
		}	
	}

	function PreencherCampoSai(ACampo, AValor) {
	  if (form.getvalue(ACampo) == ''){
	    form.setvalue(ACampo, AValor); 
	    form.fieldbyName(ACampo).componente.trigger('change');	
	  }
	}

	$('.ctrlCHAVENFESAI').on('focus.request', GerarChaveAcessoEmitente);
	function GerarChaveAcessoEmitente() {
		var cdmodelo = form.configextra.EhOpetanteSPED ? form.getvalue('CDMODELO') : form.getvalue('CODIGOTIPODCTOSINTEGRA');	
		if ((cdmodelo == '55') || (cdmodelo == '57') || (cdmodelo == '67')){	
			$achave = form.getvalue('CODIGOPESSOA') + ';' + form.getvalue('CODIGOEMPRESA') + ';' 
					+ form.getvalue('CODIGOESTAB') + ';' + form.getvalue('DATALCTOFIS') + ';' 
					+ form.getvalue('SERIENF') + ';'+ form.getvalue('NUMERONF');	
			if (form.getvalue('DATALCTOFIS')!='' &&
				form.getvalue('SERIENF')    !='' &&
				form.getvalue('NUMERONF')   !='' &&
				form.getvalue('CHAVENFESAI') == '')	{
				AJaxCadastroExecuteMethodGetProperty('TnFisDMLctoFisSai', 'GerarChaveAcessoEmitenteAjax', $achave, '', (retorno) => {
					if (retorno.data.result) {
						form.setvalue('CHAVENFESAI', retorno.data.result);        
					}
				});		
			}
		}		
	}	

	function EnabledCamposLcto(){		
		var cddocsintegra = form.getvalue('CODIGOTIPODCTOSINTEGRA');
		var cdmodelo = form.configextra.EhOpetanteSPED ? form.getvalue('CDMODELO') : form.getvalue('CODIGOTIPODCTOSINTEGRA');	
		
		var AEnabled = form.configextra.ApuraIPI;
	    form.setenabled('BASECALCULOIPI', AEnabled);
	    form.setenabled('VALORIPI',       AEnabled);
	    form.setenabled('ISENTASIPI',     AEnabled);
	    form.setenabled('OUTRASIPI',      AEnabled);
		
		AEnabled = form.configextra.LancaAcrescimo;
		form.setenabled('ACRESCIMOFINANCEIRO',  AEnabled);
        form.setrequired('ACRESCIMOFINANCEIRO', AEnabled);
		
		form.setrequired('SIGLAESTADOORIGEM', (form.configextra.CFOPTransporte) ||
		                                      (form.configextra.CFOPEnergiaEletrica) || 
											  (form.configextra.CFOPComunicacao));
														  
	    form.setenabled('SIGLAESTADOORIGEM', (form.configextra.CFOPTransporte) || 
		                                     (form.configextra.CFOPEnergiaEletrica) || 
											 (form.configextra.CFOPComunicacao));
														 
		if (((form.configextra.CFOPTransporte)||(form.configextra.CFOPEnergiaEletrica)||(form.configextra.CFOPComunicacao)) && 
	        (form.getvalue('SIGLAESTADOORIGEM') != '')){
	      form.setrequired('CODIGOMUNICORIGEM', true);
	      form.setenabled('CODIGOMUNICORIGEM', true);
		}
	    else{
	      form.setrequired('CODIGOMUNICORIGEM', false);
	      form.setenabled('CODIGOMUNICORIGEM', false);
	    };
		
		form.setrequired('CODIGOTIPODCTOSINTEGRA', form.configextra.UsaSINTEGRA);
		form.setvisible('CODIGOTIPODCTOSINTEGRA', form.configextra.UsaSINTEGRA);
	    form.setrequired('EMITENTENF', form.configextra.UsaSINTEGRA);
	    form.setenabled('CODIGOTIPODCTOSINTEGRA', form.configextra.UsaSINTEGRA);
	    form.setenabled('EMITENTENF', form.configextra.UsaSINTEGRA);	    
		
		var AEnabled = (form.configextra.UsaSINTEGRA) &&
		  	   	       (( ((cddocsintegra >= 7) &&(cddocsintegra <= 11))||(cddocsintegra = 57) )||			       
					   (cdmodelo == '7')||(cdmodelo == '8')||(cdmodelo == '9')||(cdmodelo == '57'));

		form.setrequired('MODALIDADEFRETE', AEnabled);
		form.setenabled('MODALIDADEFRETE', AEnabled);		
		
		form.setenabled('CODIGOTIPODCTOSINTEGRA', !form.configextra.EhOpetanteSPED);
		form.setrequired('CODIGOTIPODCTOSINTEGRA', !form.configextra.EhOpetanteSPED);
		form.setenabled('CDMODELO', form.configextra.EhOpetanteSPED);
		form.setrequired('CDMODELO', form.configextra.EhOpetanteSPED);
		
		if (cdmodelo != ''){
	        var AEnabled = (cdmodelo == '7' ) || (cdmodelo == '8' ) || (cdmodelo == '9' ) ||
	                       (cdmodelo == '10') || (cdmodelo == '11') || (cdmodelo == '1')  ||
	                       (cdmodelo == '1B') || (cdmodelo == '4')  || (cdmodelo == '55') ||
	                       (cdmodelo == '57') || (cdmodelo == '65');

	        form.setenabled('MODALIDADEFRETE', AEnabled);
	        form.setrequired('MODALIDADEFRETE', AEnabled);

	        AEnabled = (cdmodelo == '1')  || (cdmodelo == '4')  ||
	                   (cdmodelo == '1B') || (cdmodelo == '55') ||
	                   (cdmodelo == '99') || (cdmodelo == '65') ||
	                   (cdmodelo == '3')  || (cdmodelo == '3A') ||
	                   (cdmodelo == '3B');
					   
	        form.setenabled('INDPAGTO', AEnabled);

			AEnabled = (cdmodelo == '55')  || (cdmodelo == '65')

			form.setenabled('INDICADORPRESENCA', AEnabled);			
			
			AEnabled = (cdmodelo == '57')  || (cdmodelo == '8')  ||
	                   (cdmodelo == '67') || (cdmodelo == '7') ||
	                   (cdmodelo == '8b');
					   
	        if (document.getElementById('ctrlSIGLAESTADOORIGEM').disabled) {				   
				form.setenabled('SIGLAESTADOORIGEM', AEnabled);
			}
			
			if (document.getElementById('ctrlCODIGOMUNICORIGEM').disabled) {
				form.setenabled('CODIGOMUNICORIGEM', AEnabled);
			}
			
			form.setenabled('SIGLAESTADODESTINO', AEnabled);
			form.setenabled('CODIGOMUNICDESTINO', AEnabled);
			
	        AEnabled = (cdmodelo == '55') || (cdmodelo == '57') || 
			           (cdmodelo == '59') || (cdmodelo == '65') || 
					   (cdmodelo == '99');
	        
			form.setenabled('CHAVENFESAI', AEnabled);
	        if (form.configextra.EhOpetanteSPED){
				form.setenabled('CHAVENFESAIREF', AEnabled);
			}

			KTApp.blockPage();
	        AEnabled = (cdmodelo == '1') || (cdmodelo == '1B') || 
			           (cdmodelo == '4') || (cdmodelo == '55') || 
					   (cdmodelo == '65');

            if (AEnabled) {
                $('li[data-id=tabTnFisDMLCTOFISSAISPEDC105]').show();
				$('li[data-id=tabTnFisDMLctoFisSaiSPEDC112]').show();
				$('li[data-id=tabTnFisDMLctoFisSaiSPEDC113]').show();
				$('li[data-id=tabTnFisDMLctoFisSaiSPEDC114]').show();
				$('li[data-id=tabTnFisDMLctoFisSaiSpedC115]').show();
				$('li[data-id=tabTnFisDMLctoFisSaiSPEDC116]').show();
            } else {
                $('li[data-id=tabTnFisDMLCTOFISSAISPEDC105]').hide();
				$('li[data-id=tabTnFisDMLctoFisSaiSPEDC112]').hide();
				$('li[data-id=tabTnFisDMLctoFisSaiSPEDC113]').hide();
				$('li[data-id=tabTnFisDMLctoFisSaiSPEDC114]').hide();
				$('li[data-id=tabTnFisDMLctoFisSaiSpedC115]').hide();
				$('li[data-id=tabTnFisDMLctoFisSaiSPEDC116]').hide();
            }
			
			AEnabled = (cdmodelo == '21') || (cdmodelo == '22');
			
			if (AEnabled) {
				$('li[data-id=tabTnFisDMLctoFisSaiSPEDD500]').show();
				$('li[data-id=tabTnFisDMLctoFisSaiProdutoSPEDD510]').show();
				$('li[data-id=tabTnFisDMLctoFisSaiSPEDD530]').show();
			} else {
				$('li[data-id=tabTnFisDMLctoFisSaiSPEDD500]').hide();
				$('li[data-id=tabTnFisDMLctoFisSaiProdutoSPEDD510]').hide();
				$('li[data-id=tabTnFisDMLctoFisSaiSPEDD530]').hide();
			}				
			$('li[data-id=tabTnFisDME115VALDECLARATORIO]').show();
            KTApp.unblockPage();
	    }  
		
		if (document.getElementById('ctrlSIGLAESTADOORIGEM').disabled) {				   
	      form.setenabled('SIGLAESTADOORIGEM', (form.configextra.TemDataOpcaoSF) && 
		                                       ([2/*ISS*/, 3/*ISS/ICMS*/].indexOf(form.configextra.TipoImposto) > -1));
		}
			
		if (document.getElementById('ctrlCODIGOMUNICORIGEM').disabled) {
		  form.setenabled('CODIGOMUNICORIGEM', (form.configextra.TemDataOpcaoSF) && 
		                                       ([2/*ISS*/, 3/*ISS/ICMS*/].indexOf(form.configextra.TipoImposto) > -1));
		}

		if ((form.configextra.EhOpetanteSPED) && (cdmodelo != '')){
			form.setenabled('CODIGOSAT',  cdmodelo == '59');
			form.setrequired('CODIGOSAT', cdmodelo == '59');
		}
		else{		
			if ((!(form.configextra.EhOpetanteSPED)) && (cddocsintegra != '')){
				form.setenabled('CODIGOSAT',  cddocsintegra == '59');
				form.setrequired('CODIGOSAT', cddocsintegra == '59');
			}
		}	
		VerificarHabilitarDetalhes;
	}

	function ModeloChange(e, options) {
		EnabledCamposLcto();
		if (options === undefined || !options.loadFromData) {
			setTimeout(function() { 
				nextFocus(e.currentTarget);	
			}, 300)
		}
	}

	function AbrirDetalhe(_ADetalhe){
		Scope = {};
		Scope.Class = _ADetalhe;
		Scope.Filtros = {};
		Scope.Filtros["CODIGOEMPRESA"] = form.getvalue('CODIGOEMPRESA');
		Scope.Filtros["CHAVELCTOFISSAI"] = form.getvalue('CHAVELCTOFISSAI');
		window.open("Cadastro?Scope="+ JSON.stringify(Scope), '_blank');
	}

	$('#ctrlGPSORIGEM').change(HabilitarGridConformeOrigemGPS);
	HabilitarGridConformeOrigemGPS;
});

function HabilitarGridConformeOrigemGPS(){
	
	let AHabilitarGridConformeOrigemGPS	= $('#ctrlGPSORIGEM').val();
	let GridProcessoAquisicaoRural 		= document.getElementById('dataGridConteudoTnFpaDMProcessoAquisicaoRural');
	let GridRecebimentoServico 			= document.getElementById('dataGridConteudoTnFpaDMRecebimentoServico');
	let GridDMRecebimentoProcessoJudAdm = document.getElementById('dataGridConteudoTnFpaDMRecebimentoProcessoJudAdm');

	if (AHabilitarGridConformeOrigemGPS == 1 || AHabilitarGridConformeOrigemGPS == 2 || AHabilitarGridConformeOrigemGPS == 3 || AHabilitarGridConformeOrigemGPS == 5 ){
		$(GridProcessoAquisicaoRural).closest('.card.card-custom').hide();
		$(GridRecebimentoServico).closest('.card.card-custom').show();
		$(GridDMRecebimentoProcessoJudAdm).closest('.card.card-custom').show();
	
	} else if (AHabilitarGridConformeOrigemGPS == 4 || AHabilitarGridConformeOrigemGPS == 7 || AHabilitarGridConformeOrigemGPS == 8){
		$(GridProcessoAquisicaoRural).closest('.card.card-custom').show();
		$(GridRecebimentoServico).closest('.card.card-custom').hide();
		$(GridDMRecebimentoProcessoJudAdm).closest('.card.card-custom').hide();
	}
}

function ActAbrirComplementarExecute(){AbrirDetalhe("TnFisDMLctoFisSaiCompl");}
function ActAbrirRetidoExecute(){AbrirDetalhe("TnFisDMLctoFisSaiRetido");}
function ActAbrirConFreteExecute(){AbrirDetalhe("TnFisDMLctoFisSaiConFrete");}
function ActAbrirExportacaoExecute(){AbrirDetalhe("TnFisDMLctoFisSaiExport");}
function ActAbrirDMEDExecute(){AbrirDetalhe("TnFisDMLCTOFISSAIDMED");}
function ActAbrirDetMunicOrigemExecute(){AbrirDetalhe("TnFisDMLctoFisSaiDetMunicipioOrigem");}
function ActAbirDIFALExecute(){AbrirDetalhe("TnFisDMLctoFisSaiDIFAL");}