FormManager.afterCreateDynamicForm.subscribe(function() {
    let formAtual = FormManager.byname('TnFisDMLctoFisSaiPISCOFINS', '');
    formAtual.setenabledrequired('QUANTIDADE', false);

    formAtual.getcomponent('SEQ').blur(enableProdutoCfop);
    formAtual.getcomponent('SEQ').blur(VerificaItemSequencia);
	formAtual.getcomponent('SEQ').blur(requestDetalheProdutoPrenchimentoAutomatico);	
    formAtual.getcomponent('RECEITAPISCOFINS').focus(requestDetalheProduto);
    formAtual.getcomponent('CODIGOPRODUTO').change(requestDetalheProduto);
    formAtual.getcomponent('ALIQPIS').blur(RecalculaImpostoPIS);
    formAtual.getcomponent('ALIQCOFINS').blur(RecalculaImpostoCofins);	

});

var $DACONTIPORECEITA = 0;

function VerificaItemSequencia() {
    let formMaster = FormManager.byname('TnFisDMLctoFisSai', '');
    $achave = formMaster.getvalue('CODIGOEMPRESA') + ';' + formMaster.getvalue('CHAVELCTOFISSAI') + ';' + formAtual.getvalue('SEQ');
    AJaxCadastroExecuteMethodGetProperty('TnFisDMLctoFisSaiPISCOFINS', 'PossuiItemSequenciaCloud', $achave, '', (retorno) => {

        if (!retorno.data.result) {
            bootbox.dialog({
                message: 'Sequência Inexistente na Tela Detalhamento do Item e Serviço',
                title: '',
                buttons: {
                    OK: {
                        label: 'OK',
                        className: "btn-success",
                    }
                }
            });
        }
    });
}

function EnableQuantidade() {
    formAtual = FormManager.byname('TnFisDMLctoFisSaiPISCOFINS', '');
    if ($DACONTIPORECEITA == undefined) {
        $DACONTIPORECEITA = 0;
    }

    var aenabled = false;
    if (($DACONTIPORECEITA == 10) || ($DACONTIPORECEITA == 17) || ($DACONTIPORECEITA == 34)) {
        aenabled = true;
    }

    formAtual.setenabledrequired('QUANTIDADE', aenabled);
    if ((!aenabled) && (formAtual.getvalue('QUANTIDADE') == '')) {
        formAtual.setvalue('QUANTIDADE', 0);
    }
}

function RecalculaImpostoPIS() {
    formAtual = FormManager.byname('TnFisDMLctoFisSaiPISCOFINS', '');

    if ((formAtual.getvalue('QUANTIDADE') == 0) || (formAtual.getvalue('QUANTIDADE') == '')|| (formAtual.getvalue('QUANTIDADE') == '0,0000')) {
        CalcularValorImposto('BASECALCULOPISCOFINS', 'ALIQPIS', 'VALORPIS');
    } else {
        CalcularValorQuantidade('ALIQPIS', 'VALORPIS');
    }
}

function RecalculaImpostoCofins() {
    formAtual = FormManager.byname('TnFisDMLctoFisSaiPISCOFINS', '');

    if ((formAtual.getvalue('QUANTIDADE') == 0) || (formAtual.getvalue('QUANTIDADE') == '')|| (formAtual.getvalue('QUANTIDADE') == '0,0000')) {
        CalcularValorImposto('BASECALCULOPISCOFINS', 'ALIQCOFINS', 'VALORCOFINS');
    } else {
        CalcularValorQuantidade('ALIQCOFINS', 'VALORCOFINS');
    }
}

function CalcularValorQuantidade(_AFldAliq, _AFldValor) {
    formAtual = FormManager.byname('TnFisDMLctoFisSaiPISCOFINS', '');

    var base = formAtual.getvalue('QUANTIDADE').replace('.', '').replace(',', '.');
    var aliquota = formAtual.getvalue(_AFldAliq).replace('.', '').replace(',', '.');
    formAtual.setvalue(_AFldValor, (base * aliquota).toFixed(2));
}

function CalcularValorImposto(_AFldBase, _AFldAliq, _AFldValor) {
    formAtual = FormManager.byname('TnFisDMLctoFisSaiPISCOFINS', '');

    var base = formAtual.getvalue(_AFldBase).replace('.', '').replace(',', '.');
    var aliquota = formAtual.getvalue(_AFldAliq).replace('.', '').replace(',', '.');
    formAtual.setvalue(_AFldValor, ((base * aliquota) / 100).toFixed(2));
}

function requestDetalheProduto() {
    const form = FormManager.byname('TnFisDMLctoFisSaiPISCOFINS', '');
    if (form.getvalue('CODIGOPRODUTO') != '') {
        let keys = [];

        if (form.getvalue('CODIGOEMPRESA') == '') {
            keys.push(SessionManager.selecao.CODIGOEMPRESA);
        } else {
            keys.push(form.getvalue('CODIGOEMPRESA'));
        }

        keys.push(form.getvalue('CODIGOPRODUTO'));

        AJaxCadastroExecuteMethodGetProperty('TnFisDMLctoFisSaiPISCOFINS', 'GetDACONTIPORECEITA', keys.join(';'), '', requestDetalheProdutoSucessoAjax);
    }
}

function requestDetalheProdutoSucessoAjax(retorno) {
    var result = retorno.data.result;
    $DACONTIPORECEITA = result.DACONTIPORECEITA;

    EnableQuantidade();

	formAtual.setvalue('ALIQPIS',result.DACONALIQPISSAI);	
	formAtual.setvalue('ALIQCOFINS',result.DACONALIQCOFINSSAI);		

    if (result.Mensagem != null) {
        bootbox.dialog({
            message: result.Mensagem,
            title: '',
            buttons: {
                OK: {
                    label: 'OK',
                    className: "btn-success",

                }
            }
        });
    }
}

const requestDetalheProdutoPrenchimentoAutomatico = function () {
	const form = FormManager.byname('TnFisDMLctoFisSaiPISCOFINS', '');
	if (form.getvalue('SEQ') != '') {
		let keys = [];

		if (form.getvalue('CODIGOEMPRESA') == '') {
			keys.push(SessionManager.selecao.CODIGOEMPRESA);
		}
		else {
			keys.push(form.getvalue('CODIGOEMPRESA'));
		};

		if (form.masterclass != null && ((form.getvalue('CHAVELCTOFISSAI') == '') || (form.getvalue('CHAVELCTOFISSAI') == '0'))) {
			const masterForm = FormManager.byname(form.masterclass);

			keys.push(masterForm.getvalue('CHAVELCTOFISSAI'));
		}
		else {
			keys.push(form.getvalue('CHAVELCTOFISSAI'));
		};

		keys.push(form.getvalue('SEQ'));
		keys.push('True');
		AJaxCadastroExecuteMethodGetProperty('TnFisDMLctoFisSaiPISCOFINS', 'VerificaExisteLctoProduto', keys.join(';'), '', resultDetalheProdutoPrenchimentoAutomatico);
	}
}

const resultDetalheProdutoPrenchimentoAutomatico = function(retorno) {

	var result = retorno.data.result.Data;

	formAtual.setvalue('CODIGOPRODUTO',result.CODIGOPRODUTO);	
	formAtual.setvalue('CODIGOCFOP',result.CODIGOCFOP);	
	formAtual.setvalue('BASECALCULOPISCOFINS',result.BASECALCULOPISCOFINS);	
	formAtual.setvalue('TIPODEBITOPIS',result.TIPODEBITOPIS);			
	formAtual.setvalue('TIPODEBITO',result.TIPODEBITO);			
	formAtual.setvalue('CDSITUATRIBUTCOFINS',result.CDSITUATRIBUTCOFINS);			
	formAtual.setvalue('CDSITUATRIBUTPIS',result.CDSITUATRIBUTPIS);		
	formAtual.setvalue('VALORPIS',result.VALORPIS);	
	formAtual.setvalue('VALORCOFINS',result.VALORCOFINS);	
	formAtual.setvalue('RECEITAPISCOFINS',result.RECEITAPISCOFINS);
}

function enableProdutoCfop() {
	formAtual = FormManager.byname('TnFisDMLctoFisSaiPISCOFINS', '');
    var aenabled = formAtual.getvalue('CODIGOPRODUTO') == '';
    formAtual.setenabled('CODIGOPRODUTO', aenabled);
    formAtual.setenabled('CODIGOCFOP', aenabled);
}