FormManager.afterCreateDynamicForm.subscribe(function() {
    let form = FormManager.byname('TnFisDMLctoFisSaiProduto', '');
	
	var Executor = new nExpressionExecutor();
	
	form.getcomponent('VALORUNITARIO').change(CalcularTotal);
	form.getcomponent('QUANTIDADE').change(CalcularTotal);
	form.getcomponent('VALORTOTAL').change(CalcularUnitario);
	form.getcomponent('QUANTIDADE').change(PegarMascara);

    const EnabledCamposProduto = function() {
        var FormLcto = FormManager.byname('TnFisDMLctoFisSai', '');

        if (FormLcto) {
            form.setvalue('DATALCTOFIS', FormLcto.getvalue('DATALCTOFIS'));
        }

        form.setenabled('TIPOESTOQUE', form.configextra.Industria);
    }

    const requestConfigCFOP = function() {
        if ((form.getvalue('CODIGOESTAB') != '') && (form.getvalue('CODIGOCFOP') != '')) {

            if (form.getvalue('CODIGOEMPRESA') == '') {
                $achave = SessionManager.selecao.CODIGOEMPRESA + ';' +
                    form.getvalue('CODIGOESTAB') + ';' +
                    form.getvalue('CODIGOCFOP').replace(".", "");
            } else {
                $achave = form.getvalue('CODIGOEMPRESA') + ';' +
                    form.getvalue('CODIGOESTAB') + ';' +
                    form.getvalue('CODIGOCFOP').replace(".", "");
            };
            AJaxCadastroExecuteMethodGetProperty('TnFisDMLctoFisSaiProduto', 'GetApuracao', $achave, 'Industria', requestConfigCFOPSucessoAjax);
        } else {
            EnabledCamposProduto();
        }
    }

    const requestConfigCFOPSucessoAjax = function(retorno) {
        form.configextra.Industria = retorno.data.Industria;
        EnabledCamposProduto();
    }

    var controleICMS = new ControleBaseIsentaOutras(form, 'BASECALCULOICMS', 'ISENTASICMS', 'OUTRASICMS', 'VALORTOTAL', 'ALIQICMS', 'VALORICMS');
    var controleIPI = new ControleBaseIsentaOutras(form, 'BASECALCULOIPI', 'ISENTASIPI', 'OUTRASIPI', 'VALORTOTAL', 'ALIQIPI', 'VALORIPI');
    var controleISS = new ControleBaseIsentaOutras(form, 'BASECALCULOISS', 'ISENTASISS', 'OUTRASISS', 'VALORTOTAL', 'ALIQISS', 'VALORISS');
    var controleST = new ControleBaseIsentaOutras(form, 'BASECALCULOSUBTRIBUT', 'ISENTASSUBTRIB', 'OUTRASSUBTRIB', 'VALORTOTAL', 'ALIQSUBTRIBUT', 'VALORSUBTRIBUT');

    form.getcomponent('CODIGOCFOP').change(requestConfigCFOP);

    form.setrequired('OUTRASSUBTRIB', true);
    form.setrequired('ISENTASSUBTRIB', true);

    EnabledCamposProduto();
	
	async function PegarMascara() {
		var decimalCount = Executor.execute(`EXTERNO("PEGARQTDCASASDECIMAIS", [${form.getvalue("CODIGOEMPRESA")},${form.getvalue("CODIGOESTAB")}])`);
		let mask = '#.##0,';
		let newMask = mask.padEnd(mask.length + (await decimalCount), '0');
		changeDataMask('QUANTIDADE', newMask);
		KTApp.unblockPage();
	}
});

function actProdutos() {
    Scope = {};
    Scope.Class = 'TnGemDMProduto';
    window.open("Cadastro?Scope=" + JSON.stringify(Scope), '_blank');
}

function CalcularTotal() {
	let form = FormManager.byname('TnFisDMLctoFisSaiProduto', '');
		
	if ((form.getvalue('VALORUNITARIO') != '') && (form.getvalue('QUANTIDADE') != '')) {
		var unitario = form.getvalue('VALORUNITARIO').replace('.', '').replace(',', '.');
		var quantidade = form.getvalue('QUANTIDADE').replace('.', '').replace(',', '.');
		var valor = (unitario * quantidade).toFixed(2);
		form.setvalue('VALORTOTAL', valor);
	}
}

function CalcularUnitario() {
	let form = FormManager.byname('TnFisDMLctoFisSaiProduto', '');

	if ((form.getvalue('VALORTOTAL') != '') && 
		(form.getvalue('QUANTIDADE') != '') && 
		(form.getvalue('VALORUNITARIO') == '')) {
		var total = form.getvalue('VALORTOTAL').replace('.', '').replace(',', '.');
		var quantidade = form.getvalue('QUANTIDADE').replace('.', '').replace(',', '.');
		var valor = (total / quantidade).toFixed(2);
		form.setvalue('VALORUNITARIO', valor);
	}
}

function changeDataMask(fieldName, mask) {
    let form = FormManager.byname('TnFisDMLctoFisSaiProduto', '');
	
    let field = form.fieldbyName(fieldName);
    field.componente.unmask();
    field.componente[0].dataset['mask'] = mask;
    $.applyDataMask(field.componente);
}