FormManager.afterCreateDynamicForm.subscribe(function () {
	let form = FormManager.byname('TnFisDMLctoFisSaiRetido', '');

	form.getcomponent('CHAVELCTOFISSAI').change(requestConfigNota);
	form.getcomponent('CHAVELCTOFISSAI').focusin(DoFocusInChave);
	form.getcomponent('TIPORETENCAO').focusin(DoFocusInChave);

	form.getcomponent('BASECALCULOINSS').focusin(function () { PreencherCampoRetidoSaida('BASECALCULOINSS', form.configextra.BaseCalculoINSS); });
	form.getcomponent('BASECALCULOISSQN').focusin(function () { PreencherCampoRetidoSaida('BASECALCULOISSQN', form.configextra.BaseCalculoISSQN); });
	form.getcomponent('BASECALCULOIRRF').focusin(function () { PreencherCampoRetidoSaida('BASECALCULOIRRF', form.configextra.BaseCalculoIRRF); });
	form.getcomponent('BASECALCULOPIS').focusin(function () { PreencherCampoRetidoSaida('BASECALCULOPIS', form.configextra.BaseCalculoPIS); });
	form.getcomponent('BASECALCULOCOFINS').focusin(function () { PreencherCampoRetidoSaida('BASECALCULOCOFINS', form.configextra.BaseCalculoCOFINS); });
	form.getcomponent('BASECALCULOCSLL').focusin(function () { PreencherCampoRetidoSaida('BASECALCULOCSLL', form.configextra.BaseCalculoCSLL); });
	form.getcomponent('BASECALCULOIRPJ').focusin(function () { PreencherCampoRetidoSaida('BASECALCULOIRPJ', form.configextra.BaseCalculoIRPJ); });

	form.getcomponent('ALIQIRRF').focusin(function () { PreencherCampoRetidoSaida('ALIQIRRF', form.configextra.AliquotaIRRF); });
	form.getcomponent('ALIQPIS').focusin(function () { PreencherCampoRetidoSaida('ALIQPIS', form.configextra.AliquotaPIS); });
	form.getcomponent('ALIQIRPJ').focusin(function () { PreencherCampoRetidoSaida('ALIQIRPJ', form.configextra.AliquotaIRPJ); });
	form.getcomponent('ALIQISSQN').focusin(function () { PreencherCampoRetidoSaida('ALIQISSQN', form.configextra.AliquotaISSQN); });
	form.getcomponent('ALIQINSS').focusin(function () { PreencherCampoRetidoSaida('ALIQINSS', form.configextra.AliquotaINSS); });
	form.getcomponent('ALIQCOFINS').focusin(function () { PreencherCampoRetidoSaida('ALIQCOFINS', form.configextra.AliquotaCOFINS); });
	form.getcomponent('ALIQCSLL').focusin(function () { PreencherCampoRetidoSaida('ALIQCSLL', form.configextra.AliquotaCSLL); });

    form.getcomponent('VALORIRRF').focusin(function() { CalcularImposto('BASECALCULOIRRF', 'ALIQIRRF', 'VALORIRRF'); });
    form.getcomponent('VALORIRPJ').focusin(function() { CalcularImposto('BASECALCULOIRPJ', 'ALIQIRPJ', 'VALORIRPJ'); });
    form.getcomponent('VALORISSQN').focusin(function() { CalcularImposto('BASECALCULOISSQN', 'ALIQISSQN', 'VALORISSQN'); });
    form.getcomponent('DATAPREVISSQN').focusin(() => {
        form = FormManager.byname('TnFisDMLctoFisSaiRetido', '');
        if (isCalcular('DATAPREVISSQN')) {
            form.setvalue('DATAPREVISSQN', FormManager.byname('TnFisDMLctoFisSai', '').getvalue('DATALCTOFIS'));
        }
    });
    form.getcomponent('VALORINSS').focusin(function() { CalcularImposto('BASECALCULOINSS', 'ALIQINSS', 'VALORINSS'); });
    form.getcomponent('VALORPIS').focusin(function() { CalcularImposto('BASECALCULOPIS', 'ALIQPIS', 'VALORPIS'); });
    form.getcomponent('VALORCOFINS').focusin(function() { CalcularImposto('BASECALCULOCOFINS', 'ALIQCOFINS', 'VALORCOFINS'); });
    form.getcomponent('VALORCSLL').focusin(function() { CalcularImposto('BASECALCULOCSLL', 'ALIQCSLL', 'VALORCSLL'); });
    form.getcomponent('DATAPREVIRRFIRPJ').focusin(() => {
        form = FormManager.byname('TnFisDMLctoFisSaiRetido', '');
        if (isCalcular('DATAPREVIRRFIRPJ')) {
            form.setvalue('DATAPREVIRRFIRPJ', FormManager.byname('TnFisDMLctoFisSai', '').getvalue('DATALCTOFIS'));
        }
    });
    form.getcomponent('TOTALPISCOFINSCSLL').focusin(DoFocusInTotalPisCofinsCsll);
    form.getcomponent('DATAPREVPISCOFINSCSLL').focusin(() => {
        form = FormManager.byname('TnFisDMLctoFisSaiRetido', '');
        if (isCalcular('DATAPREVPISCOFINSCSLL')) {
            form.setvalue('DATAPREVPISCOFINSCSLL', FormManager.byname('TnFisDMLctoFisSai', '').getvalue('DATALCTOFIS'));
        }
    });
});


function DoFocusInTotalPisCofinsCsll() {
	if (isCalcular('TOTALPISCOFINSCSLL')) {
		let form = FormManager.byname('TnFisDMLctoFisSaiRetido', '');
		const valorContabil = +FormManager.byname('TnFisDMLctoFisSai', '').getvalueasnumeric('VALORCONTABIL');
		var valor = CalcularValorImposto(valorContabil, form.configextra.AliquotaPIS) +
			CalcularValorImposto(valorContabil, form.configextra.AliquotaCOFINS) +
			CalcularValorImposto(valorContabil, form.configextra.AliquotaCSLL);
	
		form.setvalue('TOTALPISCOFINSCSLL', valor);
	}
}

function isCalcular(Acampo) {
	let form = FormManager.byname('TnFisDMLctoFisSaiRetido', '');
	const formInEditModes = form.estado === FormState.cadInsert || form.estado === FormState.cadAlterando;
	
	return (formInEditModes && !form.getvalue(Acampo))
}

function PreencherCampoRetidoSaida(Acampo, AValor) {
	let form = FormManager.byname('TnFisDMLctoFisSaiRetido', '');

	if ((AValor > 0) && (form.getvalue(Acampo) == '')) {
		form.setvalue(Acampo, AValor);
		form.fieldbyName(Acampo).componente.trigger('change');
	}
}

function CalcularImposto(_ABase, _AAliquota, _AImposto) {
	let form = FormManager.byname('TnFisDMLctoFisSaiRetido', '');

	var base = form.getvalueasnumeric(_ABase);
	var aliquota = form.getvalueasnumeric(_AAliquota);

	result = CalcularValorImposto(base, aliquota);

	form.setvalue(_AImposto, result);
	form.focarfield(_AImposto);
}

function CalcularValorImposto(_ABase, _AAliquota) {
	if (_AAliquota != 0) {
		return +((_ABase * _AAliquota) / 100).toFixed(2);
	}
	return 0;
}

function DoFocusInChave() {
  if (FormManager.byname('TnFisDMLctoFisSaiProduto', '')) {
    let form = FormManager.byname('TnFisDMLctoFisSaiRetido', '');
    if ((!form.getvalue('CHAVELCTOFISSAI'))||(form.getvalue('CHAVELCTOFISSAI') == 0)) {
      form.setvalue('CHAVELCTOFISSAI', FormManager.byname('TnFisDMLctoFisSai', '').getvalue('CHAVELCTOFISSAI'));
    }
    requestConfigNota();
  }
}

function requestConfigNota() {
	let form = FormManager.byname('TnFisDMLctoFisSaiRetido', '');
	if (form.getvalue('CHAVELCTOFISSAI')) {
		var $achave = form.getvalue('CHAVELCTOFISSAI');
		var campos = 'BaseCalculoINSS;BaseCalculoISSQN;BaseCalculoIRPJ;BaseCalculoIRRF;BaseCalculoPIS;BaseCalculoCOFINS;BaseCalculoCSLL;' +
								 'AliquotaPIS;AliquotaIRRF;AliquotaIRPJ;AliquotaISSQN;AliquotaINSS;AliquotaCOFINS;AliquotaCSLL';

		KTApp.blockPage();
		AJaxCadastroExecuteMethodGetProperty('TnFisDMLctoFisSaiRetido', 'VerificarRetencao', $achave, campos, requestConfigNotaSucessoAjax);
	}
}

function requestConfigNotaSucessoAjax(retorno) {
	var data = retorno.data;
	let form = FormManager.byname('TnFisDMLctoFisSaiRetido', '');

	form.configextra.BaseCalculoINSS = data.BaseCalculoINSS;
	form.configextra.BaseCalculoISSQN = data.BaseCalculoISSQN;
	form.configextra.BaseCalculoIRPJ = data.BaseCalculoIRPJ;
	form.configextra.BaseCalculoIRRF = data.BaseCalculoIRRF;
	form.configextra.BaseCalculoPIS = data.BaseCalculoPIS;
	form.configextra.BaseCalculoCOFINS = data.BaseCalculoCOFINS;
	form.configextra.BaseCalculoCSLL = data.BaseCalculoCSLL;
	form.configextra.AliquotaINSS = data.AliquotaINSS;
	form.configextra.AliquotaISSQN = data.AliquotaISSQN;
	form.configextra.AliquotaIRPJ = data.AliquotaIRPJ;
	form.configextra.AliquotaIRRF = data.AliquotaIRRF;
	form.configextra.AliquotaPIS = data.AliquotaPIS;
	form.configextra.AliquotaCOFINS = data.AliquotaCOFINS;
	form.configextra.AliquotaCSLL = data.AliquotaCSLL;

	KTApp.unblockPage();
}