FormManager.afterCreateAllForms.subscribe(function() {	
	let form = FormManager.byname('TnFisDMLctoReducaoZ', '');
	let formDetalhe = FormManager.byname('TnFisDMLctoFisSaiCFOP', '');
	let formstate = form.estado;
	let incrementoImpressora = 0;
    function getValorCampoFloat(aNomeCampo){
		if (form.getvalue(aNomeCampo) != '') {
			return parseFloat(form.getvalue(aNomeCampo).replace('.', '').replace(',', '.'))
		} else {
		  return 0;
		};
	}

	function baseCalculo() {
		let baseCalculo = 
			getValorCampoFloat('TOTALBRUTO') - (getValorCampoFloat('VALORCANCELADO') + 
				getValorCampoFloat('VALORDESCONTO') + 
				getValorCampoFloat('VALORSUBTRIBUT') + 
				getValorCampoFloat('VALORISENTO') + 
				getValorCampoFloat('VALORNAOINCIDENCIA') + 
				getValorCampoFloat('BASECALCULOICMS1') + 
				getValorCampoFloat('BASECALCULOICMS2') + 
				getValorCampoFloat('BASECALCULOICMS3') + 
				getValorCampoFloat('BASECALCULOICMS4') + 
				getValorCampoFloat('BASECALCULOICMS5') + 
				getValorCampoFloat('BASECALCULOICMS6') + 
				getValorCampoFloat('BASECALCUlOISS1') + 
				getValorCampoFloat('BASECALCUlOISS2') + 
				getValorCampoFloat('BASECALCUlOISS3'));
			if (baseCalculo < 0) {
				return 0;
			} else {
				return baseCalculo;
			};
	}

	$("#ctrlCODIGOIMPRESSORAFISCAL").change(function() {
		form.setvalue('SERIENF', $("#ctrlCODIGOIMPRESSORAFISCAL").val());
		AJaxCadastroExecuteMethodGetProperty('TnFisDMLctoReducaoZ', 'PegarIncrementoImpressora', '', '', (retorno) => {
			incrementoImpressora = retorno.data.result; 
		});
	});	
	
	$(".ctrlDATALCTOFIS").blur(function() {
		const [yearAux, monthAux, dayAux] = FormManager.byname('TnDMSelecao').getvalue('DATALCTOFIS_MAIORIGUAL').split('-');
        var dataAux = $('.ctrlDATALCTOFIS').val();
		if (dataAux.length >= 1  && dataAux.length <= 3) {
			const [dayMain] =  $('.ctrlDATALCTOFIS').val().split('/');
			form.setvalue('DATALCTOFIS', ("0" + dayMain).slice(-2) + '/' + monthAux + '/' + yearAux);
		} else if (dataAux.length >= 4  && dataAux.length <= 6) {
			const [dayMain, monthMain] =  $('.ctrlDATALCTOFIS').val().split('/');
			form.setvalue('DATALCTOFIS', dayMain + '/' + ("0" + monthMain).slice(-2) + '/' + yearAux);
		} else if (dataAux.length > 6 && dataAux.length < 10) {
			const [dayMain, monthMain, yearMain] =  $('.ctrlDATALCTOFIS').val().split('/');
			if (yearMain.length == 3) {
				form.setvalue('DATALCTOFIS', yearAux.substring(0, yearAux.length - 2) + yearMain.substring(1, 3))
			} else {
				form.setvalue('DATALCTOFIS', yearAux.substring(0, yearAux.length - yearMain.length) + yearMain)
			}
		};
		
	});

	$("#ctrlDCTOINICIAL").focus(function() {
		if (form.estado === FormState.cadInsert && form.getvalue('DCTOINICIAL') === '') {
			if (form.getvalue('CODIGOEMPRESA') != '' &&
				form.getvalue('CODIGOESTAB') != '' &&
				form.getvalue('DATALCTOFIS') != '' &&
				form.getvalue('CODIGOIMPRESSORAFISCAL') != '') {
				$AChave = 'DCTOFINAL;' + form.getvalue('CODIGOEMPRESA') + ';' + form.getvalue('CODIGOESTAB') + ';' + form.getvalue('DATALCTOFIS') + ';' + form.getvalue('CODIGOIMPRESSORAFISCAL');
				
				AJaxCadastroExecuteMethodGetProperty('TnFisDMLctoReducaoZ', 'GetUltimoLancamentoRegistro', $AChave, '', (retorno) => {
					form.setvalue('DCTOINICIAL', retorno.data.result + incrementoImpressora);
				});
			};
		};
	});

	$("#ctrlDCTOFINAL").focus(function() {
		if (form.estado === FormState.cadInsert && form.getvalue('DCTOFINAL') === '') {
			form.setvalue('DCTOFINAL', form.getvalue('DCTOINICIAL'));
		}
	});

	$("#ctrlESPECIENF").focus(function() {
		if (form.estado === FormState.cadInsert && form.getvalue('ESPECIENF') === '') {
			form.setvalue('ESPECIENF', 'CF');
		}
	});

	$("#ctrlCONTADORREDUCAOZ").focus(function() {
		if (form.estado === FormState.cadInsert && form.getvalue('CONTADORREDUCAOZ') === '') {
			if (form.getvalue('CODIGOEMPRESA') != '' &&
				form.getvalue('CODIGOESTAB') != '' &&
				form.getvalue('DATALCTOFIS') != '' &&
				form.getvalue('CODIGOIMPRESSORAFISCAL') != '') {
				$AChave = form.getvalue('CODIGOEMPRESA') + ';' + form.getvalue('CODIGOESTAB') + ';' + form.getvalue('DATALCTOFIS') + ';' + form.getvalue('CODIGOIMPRESSORAFISCAL');
				
				AJaxCadastroExecuteMethodGetProperty('TnFisDMLctoReducaoZ', 'GetContadorAnteriorCloud', $AChave, '', (retorno) => {
					if (retorno.data.result == null) {
						form.setvalue('CONTADORREDUCAOZ', incrementoImpressora);
					} else {
						form.setvalue('CONTADORREDUCAOZ', retorno.data.result + 1);
					};
				});
			};
		}
	});

	$("#ctrlCONTADORREINICIOOPERACAO").focus(function() {
		if (form.estado === FormState.cadInsert && form.getvalue('CONTADORREINICIOOPERACAO') === '') {
			if (form.getvalue('CODIGOEMPRESA') != '' &&
				form.getvalue('CODIGOESTAB') != '' &&
				form.getvalue('DATALCTOFIS') != '' &&
				form.getvalue('CODIGOIMPRESSORAFISCAL') != '') {
				$AChave = form.getvalue('CODIGOEMPRESA') + ';' + form.getvalue('CODIGOESTAB') + ';' + form.getvalue('DATALCTOFIS') + ';' + form.getvalue('CODIGOIMPRESSORAFISCAL');
				
				AJaxCadastroExecuteMethodGetProperty('TnFisDMLctoReducaoZ', 'GetContadorReinicioCloud', $AChave, '', (retorno) => {
					form.setvalue('CONTADORREINICIOOPERACAO', retorno.data.result);
				});
			};
		}
	});
	
	$("#ctrlTOTALGERAL").focus(function() {
		if (form.estado === FormState.cadInsert && form.getvalue('TOTALGERAL') === '') {
			if (form.getvalue('CODIGOEMPRESA') != '' &&
				form.getvalue('CODIGOESTAB') != '' &&
				form.getvalue('DATALCTOFIS') != '' &&
				form.getvalue('CODIGOIMPRESSORAFISCAL') != '') {
				$AChave = 'TOTALGERAL;' + form.getvalue('CODIGOEMPRESA') + ';' + form.getvalue('CODIGOESTAB') + ';' + form.getvalue('DATALCTOFIS') + ';' + form.getvalue('CODIGOIMPRESSORAFISCAL');
				AJaxCadastroExecuteMethodGetProperty('TnFisDMLctoReducaoZ', 'GetUltimoLancamentoRegistro', $AChave, '', (retorno) => {
					form.setvalue('TOTALGERAL', ((parseFloat(retorno.data.result) || 0) + (parseFloat($("#ctrlTOTALBRUTO").val().replace('.', '').replace(',', '.')) || 0)));
				});
			};
		};
	});

	$("#ctrlVALORCANCELADO").focus(function() {
		if (form.estado === FormState.cadInsert && form.getvalue('VALORCANCELADO') === '') {
			form.setvalue('VALORCANCELADO', baseCalculo());
		}
	});

	$("#ctrlVALORDESCONTO").focus(function() {
		if (form.estado === FormState.cadInsert && form.getvalue('VALORDESCONTO') === '') {
			form.setvalue('VALORDESCONTO', baseCalculo());
		}
	});

	$("#ctrlBASECALCULOICMS1").focus(function() {
		if (form.estado === FormState.cadInsert && form.getvalue('BASECALCULOICMS1') === '' && form.getvalue('ALIQICMS1') != '') {
			form.setvalue('BASECALCULOICMS1', baseCalculo());
		}
	});

	$("#ctrlBASECALCULOICMS2").focus(function() {
		if (form.estado === FormState.cadInsert && form.getvalue('BASECALCULOICMS2') === '' && form.getvalue('ALIQICMS2') != '') {
			form.setvalue('BASECALCULOICMS2', baseCalculo());
		}
	});

	$("#ctrlBASECALCULOICMS3").focus(function() {
		if (form.estado === FormState.cadInsert && form.getvalue('BASECALCULOICMS3') === '' && form.getvalue('ALIQICMS3') != '') {
			form.setvalue('BASECALCULOICMS3', baseCalculo());
		}
	});

	$("#ctrlBASECALCULOICMS4").focus(function() {
		if (form.estado === FormState.cadInsert && form.getvalue('BASECALCULOICMS4') === '' && form.getvalue('ALIQICMS4') != '') {
			form.setvalue('BASECALCULOICMS4', baseCalculo());
		}
	});

	$("#ctrlBASECALCULOICMS5").focus(function() {
		if (form.estado === FormState.cadInsert && form.getvalue('BASECALCULOICMS5') === '' && form.getvalue('ALIQICMS5') != '') {
			form.setvalue('BASECALCULOICMS5', baseCalculo());
		}
	});

	$("#ctrlBASECALCULOICMS6").focus(function() {
		if (form.estado === FormState.cadInsert && form.getvalue('BASECALCULOICMS6') === '' && form.getvalue('ALIQICMS6') != '') {
			form.setvalue('BASECALCULOICMS6', baseCalculo());
		}
	});

	$("#ctrlBASECALCULOISS1").focus(function() {
		if (form.estado === FormState.cadInsert && form.getvalue('BASECALCUlOISS1') === '' && form.getvalue('ALIQISS1') != '') {
			form.setvalue('BASECALCUlOISS1', baseCalculo());
		}
	});

	$("#ctrlBASECALCUlOISS2").focus(function() {
		if (form.estado === FormState.cadInsert && form.getvalue('BASECALCUlOISS2') === '' && form.getvalue('ALIQISS2') != '') {
			form.setvalue('BASECALCUlOISS2', baseCalculo());
		}
	});

	$("#ctrlBASECALCUlOISS3").focus(function() {
		if (form.estado === FormState.cadInsert && form.getvalue('BASECALCUlOISS3') === '' && form.getvalue('ALIQISS3') != '') {
			form.setvalue('BASECALCUlOISS3', baseCalculo());
		}
	});	

	$("#ctrlVALORSUBTRIBUT").focus(function() {
		if (form.estado === FormState.cadInsert && form.getvalue('VALORSUBTRIBUT') === '') {
			form.setvalue('VALORSUBTRIBUT', baseCalculo());
		}
	});

	$("#ctrlVALORISENTO").focus(function() {
		if (form.estado === FormState.cadInsert && form.getvalue('VALORISENTO') === '') {
			form.setvalue('VALORISENTO', baseCalculo());
		}
	});

	$("#ctrlVALORNAOINCIDENCIA").focus(function() {
		if (form.estado === FormState.cadInsert && form.getvalue('VALORNAOINCIDENCIA') === '') {
			form.setvalue('VALORNAOINCIDENCIA', baseCalculo());
		}
	});

	form.AfterLoadDataSubject.subscribe(() => {
		$('#ctrlCHAVELCTOFISSAI').attr('readonly', true);
		$('button[data-id="ctrlCHAVELCTOFISSAI"]').attr('disabled', 'disabled'); 
		$('button[data-id="ctrlnewCHAVELCTOFISSAI"]').attr('disabled', 'disabled'); 
		//$('button[data-id="ctrlCHAVELCTOFISSAI"]').attr('disabled', 'disabled'); 
	});

	formDetalhe.BeforePost = function() { 
		formstate = form.estado;
		form.estado = FormState.cadNavegando;
		return Promise.resolve();
	};

    formDetalhe.AfterSave.subscribe(function() {
		form.estado = formstate;
	});


	form.AfterLoadData = DoAfterLoadData;

	form.getcomponent('CHAVELCTOFISSAI').change(PreencherCampoNoDetalhe);

	EnabledCamposLcto();

	function DoAfterLoadData(data) {
		if (form.estado === FormState.cadInsert && data._EstadoCadastro === FormState.cadNavegando) {
			FormManager.itens.forEach((_AForm) => {
				if (_AForm.ehdetalhe && _AForm.masterclass === form.classe && _AForm.classe != 'TnFisDMDuplicataSaiParcelaLcto') {
					_AForm.loadfromdata(data, _AForm.multiColumn);
				}
			});
		}
		VerificarHabilitarDetalhes();
	}
	let formNatureza = FormManager.byname('TnFisDMLctoFisSaiCFOP', '');
	formNatureza.AfterSave.subscribe(function() {
		VerificarHabilitarDetalhes();
	});
	formNatureza.afterDelete.subscribe(() => {
		VerificarHabilitarDetalhes();
	});

	function VerificarHabilitarDetalhes () {
		if (form.getvalue('CHAVELCTOFISSAI') == '') return;
		KTApp.blockPage();
		AJaxCadastroExecuteMethodGetProperty('TnFisDMLctoFisSai', 'VerificarHabilitarDetalhesCloudAjax', form.getvalue('CHAVELCTOFISSAI'), '', (retorno) => {
			if (retorno.data.result.detalharItens) {
                $('li[data-id=tabTnFisDMLctoFisSaiProduto]').show();
			} else {
                $('li[data-id=tabTnFisDMLctoFisSaiProduto]').hide();
			}			
			if (retorno.data.result.complementares) {
                $('li[data-id=tabTnFisDMLctoFisSaiCompl]').show();
			} else {
                $('li[data-id=tabTnFisDMLctoFisSaiCompl]').hide();
			}
            if (retorno.data.result.funrural) {
                $('li[data-id=tabTnFisDMLctoFisSaiFunrural]').show();
            } else {
                $('li[data-id=tabTnFisDMLctoFisSaiFunrural]').hide();
            }
			if (retorno.data.result.conhecimento) {
				$('li[data-id=tabTnFisDMLctoFisSaiConFrete]').show();
			} else {
				$('li[data-id=tabTnFisDMLctoFisSaiConFrete]').hide();
			}
            if (retorno.data.result.difal) {
                $('li[data-id=tabTnFisDMLctoFisSaiDIFAL]').show();
            } else {
                $('li[data-id=tabTnFisDMLctoFisSaiDIFAL]').hide();
            }
            if (retorno.data.result.retidos) {
                $('li[data-id=tabTnFisDMLctoFisSaiRetido]').show();
            } else {
                $('li[data-id=tabTnFisDMLctoFisSaiRetido]').hide();
            }
            /*if (retorno.data.result.contabil) {
                $('li[data-id=tabTnFisDMLctoFisSaiContabil]').show();
            } else {
                $('li[data-id=tabTnFisDMLctoFisSaiContabil]').hide();
            }*/
            if (retorno.data.result.substituicao) {
                $('li[data-id=tabTnFisDMLctoFisSaiSubTribut]').show();
            } else {
                $('li[data-id=tabTnFisDMLctoFisSaiSubTribut]').hide();
            }
            if (retorno.data.result.piscofins) {
                $('li[data-id=tabTnFisDMLctoFisSaiPISCOFINS]').show();
            } else {
                $('li[data-id=tabTnFisDMLctoFisSaiPISCOFINS]').hide();
            }
            if (retorno.data.result.spedc111) {
                $('li[data-id=tabTnFisDMLctoFisSaiSpedC111]').show();
            } else {
                $('li[data-id=tabTnFisDMLctoFisSaiSpedC111]').hide();
            }
            if (retorno.data.result.duplicatas) {
                $('li[data-id=tabTnFisDMDuplicataSai]').show();
            } else {
                $('li[data-id=tabTnFisDMDuplicataSai]').hide();
            }
            if (retorno.data.result.consumo) {
                $('li[data-id=tabTnFisDMLCTOFISSAISPEDC500]').show();
                $('li[data-id=tabTnFisDMLCTOFISSAIPRODUTOSPEDC510]').show();
            } else {
                $('li[data-id=tabTnFisDMLCTOFISSAISPEDC500]').hide();
                $('li[data-id=tabTnFisDMLCTOFISSAIPRODUTOSPEDC510]').hide();
            }
			if (retorno.data.result.retencoescontprevservpres) {
                $('li[data-id=tabTnFpaDMRecebimento]').show();
            } else {
                $('li[data-id=tabTnFpaDMRecebimento]').hide();
            }

			$('li[data-id=tabTnFisDMDuplicataSaiParcelaLcto]').hide();

            KTApp.unblockPage();
        });
    }

	function PreencherCampoNoDetalhe(e) {
		
		if (form.estado === FormState.cadInsert) {
			let ADicionario = $(e.currentTarget).data('dicionario');
			if (!ADicionario) {
				if ($(e.currentTarget).hasClass('datepicker')) {
					ADicionario = $(e.currentTarget).parents('div.input-group').find('input.hasdatepicker').attr('name');
				} else {
					ADicionario = $(e.currentTarget).attr('name');				
				}	
				ADicionario = ADicionario.substring(2); //remove o "p."		
			}		
			const AValue = form.getvalue(ADicionario);
			if (AValue) {
				let formLctoFisSaiRetido = FormManager.byname('TnFisDMLctoFisSaiRetido', '');
				if (formLctoFisSaiRetido){
					formLctoFisSaiRetido.setvalue(ADicionario, AValue);
				}
			}		
		}	
	}

	function EnabledCamposLcto(){		
		KTApp.blockPage();	
		$('li[data-id=tabTnFisDMLctoFisSaiContabil]').hide();	
		$('li[data-id=tabTnFisDMLCTOFISSAISPEDC105]').hide();
		$('li[data-id=tabTnFisDMLctoFisSaiSPEDC112]').hide();
		$('li[data-id=tabTnFisDMLctoFisSaiSPEDC113]').hide();
		$('li[data-id=tabTnFisDMLctoFisSaiSPEDC114]').hide();
		$('li[data-id=tabTnFisDMLctoFisSaiSpedC115]').hide();
		$('li[data-id=tabTnFisDMLctoFisSaiSPEDC116]').hide();
		$('li[data-id=tabTnFisDMLctoFisSaiSPEDD500]').hide();
		$('li[data-id=tabTnFisDMLctoFisSaiProdutoSPEDD510]').hide();
		$('li[data-id=tabTnFisDMLctoFisSaiSPEDD530]').hide();		
		KTApp.unblockPage();
		VerificarHabilitarDetalhes;
	}
});

function AbrirDetalhe(_ADetalhe){
	Scope = {};
	Scope.Class = _ADetalhe;
	Scope.Filtros = {};
	Scope.Filtros["CODIGOEMPRESA"] = form.getvalue('CODIGOEMPRESA');
	Scope.Filtros["CHAVELCTOFISSAI"] = form.getvalue('CHAVELCTOFISSAI');
	window.open("Cadastro?Scope="+ JSON.stringify(Scope), '_blank');
}

function ActAbrirComplementarExecute(){AbrirDetalhe("TnFisDMLctoFisSaiCompl");}
function ActAbrirRetidoExecute(){AbrirDetalhe("TnFisDMLctoFisSaiRetido");}
function ActAbrirConFreteExecute(){AbrirDetalhe("TnFisDMLctoFisSaiConFrete");}
function ActAbrirExportacaoExecute(){AbrirDetalhe("TnFisDMLctoFisSaiExport");}
function ActAbrirDMEDExecute(){AbrirDetalhe("TnFisDMLCTOFISSAIDMED");}
function ActAbrirDetMunicOrigemExecute(){AbrirDetalhe("TnFisDMLctoFisSaiDetMunicipioOrigem");}
function ActAbirDIFALExecute(){AbrirDetalhe("TnFisDMLctoFisSaiDIFAL");}