FormManager.afterCreateAllForms.subscribe(function() {
	let form = FormManager.byname('TnFisDMTabSSimples', '');

	EsconderDetalhe();

    var subscriber = form.AfterLoadDataSubject.subscribe(function() {

		function DoChangeAnoBase(anoBase) {
			if (parseInt(anoBase) >= 2018) {
				MostrarDetalhe();
				HabilitarSalvar();	
			} else if (parseInt(anoBase) > 1900) {
				EsconderDetalhe();
				DesabilitarSalvar();
			}
		}
		
		form.fieldbyName('ANOBASE').componente.on('change', function(e, options) {
			var anoBase = parseInt(e.target.value);
			if(options && options.loadFromData) return;
			if (anoBase < 2018 && anoBase > 1900) MostrarMsgAntes2018();
		});
		
		form.fieldbyName('ANOBASE').componente.on('change', function (event) { 
			DoChangeAnoBase(event.target.value)
		});
		
		DoChangeAnoBase(form.getvalue('ANOBASE'));
		subscriber.unsubscribe();
		EsconderDetalhe();
	});
	
    form.AfterSave.subscribe(function() {
        $AChave = form.getvalue('CODIGO')  + ';' + form.getvalue('ANOBASE');
        const gridFaixaConfig = dxDataGrid.getInstance('#dataGridConteudoTnFisDMTabSSimplesFaixaConfig');
		const gridFaixa = dxDataGrid.getInstance('#dataGridConteudoTnFisDMTabSSimplesFaixa');		
		
        if ((form.getvalue('DESCRICAOTAB') != '') && (form.getvalue('TIPO') != '') && (form.getvalue('ANOBASE') != '')) {
            AJaxCadastroExecuteMethodGetProperty('TnFisDMTabSSimples', 'InserirTabelaCloud', $AChave, '', (retorno) => {
			if (parseInt(form.getvalue('ANOBASE')) >= 2018) {				
                if (gridFaixaConfig) gridFaixaConfig.refresh()
			} else {				
				if (gridFaixa) gridFaixa.refresh()			
			}
            });
        }
    });	

	function MostrarMsgAntes2018(){
		bootbox.dialog({
			message: "Não é permitido alterar ou incluir cadastros anterior a 2018. Dúvidas contate o suporte!",
			title: '',
			buttons: {
				OK: {
					label: 'OK',
					className: "btn-success",
					callback: function () { }
				}
			}
		});		
	}
	
	function DesabilitarSalvar(){
		$("#btnActDataSetPostExecuteTNFISDMTABSSIMPLES").prop('disabled', true);
		$("#btnActDataSetPostExecuteOptsTNFISDMTABSSIMPLES").prop('disabled', true);
	}
	
	function HabilitarSalvar(){
		$("#btnActDataSetPostExecuteTNFISDMTABSSIMPLES").prop('disabled', false);
		$("#btnActDataSetPostExecuteOptsTNFISDMTABSSIMPLES").prop('disabled', false);
	}
	
	function EsconderDetalhe(){
		$(".kt-wizard--4").hide();
	}
	
	function MostrarDetalhe(){
		$(".kt-wizard--4").show();
		$('#TnFisDMTabSSimplesFaixa').hide();
		$("[data-id='tabTnFisDMTabSSimplesFaixa']").hide();
		$('#TnFisDMTabSSimplesFaixaConfig').show();
		$("[data-id='tabTnFisDMTabSSimplesFaixaConfig']").show();
	}
});