FormManager.afterCreateAllForms.subscribe(function () {
    let form = FormManager.byname('TnFisDPConfigurarCFOPRegra', '');

    $(document).ajaxComplete(function (event, jqXHR, ajaxOptions) {
        if (ajaxOptions.url === 'nHttpServicos/ExecutarOperacaoDataset'
            && ajaxOptions.data.indexOf('actGravarExecute') > 0
            && jqXHR.status === 200
            && jqXHR.statusText === 'OK') {
            swal.fire({
                html: 'Processo de Totalização das Naturezas. <br>' +
                      'IMPORTANTE: Este procedimento é executado automaticamente nas apurações dos <br>' +
                      'Impostos Estaduais, caso o Estabelecimento não seja optante de nenhum Imposto <br>' +
                      'Estadual continue a execução. Deseja realmente gerar a totalização por natureza?',
                type: 'warning',
                showCancelButton: true,
                width: '800px',
                confirmButtonClass: 'btn btn-q-primary',
                cancelButtonClass: 'btn btn-q-secondary'
            }).then((result) => {
                if (result.value) {
                    AbrirProcessoModal({
                        form,
                        _AClasse: 'TnFisDPGerarTotalizacaoCFOP',
                    });
                } else {
                    qNotifier.error('Processo de totalização de naturezas cancelado pelo usuário!');
                }
            });
        }
    });

});