FormManager.afterCreateAllForms.subscribe(function() {
    let form = FormManager.byname('TnFisDPDemonstrativoSPEDPadrao', '');
    let mapPages = new Map();
    let mapTipoApuracao = new Map();

    mapTipoApuracao.set(1, "ICMS Próprio");
    mapTipoApuracao.set(2, "ICMS por Substituição Tributária");
    mapTipoApuracao.set(3, "ICMS Diferencial de Alíquotas Origem/Destino");
    mapTipoApuracao.set(4, "Outras Apurações (Sub-Apuração)");

    setTimeout(() => configurarControleTipoApuracao(), 1500);

    var els = document.getElementsByClassName("nav-item");

    function configurarControleTipoApuracao() {
        Array.prototype.forEach.call(els, function(item) {
            for (var [key, value] of mapTipoApuracao)
                if (item.outerText === value)
                    mapPages.set(key, "a[href='" + item.children[0].getAttribute("href") + "']");
        });
        form.getcomponent('PTIPOAPURACAO').change(HabilitarDesabilitarAbas);
        HabilitarDesabilitarAbas();
    };

    function HabilitarDesabilitarAbas() {
        let tipoApuracaoSelecionado = form.getcomponent('PTIPOAPURACAO').find(":selected").val();
        for (var [key, value] of mapPages) {
            if (key == tipoApuracaoSelecionado) { 
                $(value).show(); 
                $(value).click();
            } else { 
                $(value).hide();
            }
        }
    }

    form.AfterExecuteActionProcess.subscribe(() => window.scrollTo(500, 500));
});
