FormManager.afterCreateAllForms.subscribe(function() {
	let formAtual = FormManager.byname('TnFisDPGerarDRCSTICMSSC');
	let target = $('#Conteudo', formAtual).exists();

	$(document).on('shown.bs.tab', 'a[data-toggle="tab"]', function(Tab) {
		let grid2110 = dxDataGrid.getInstance('#dataGridConteudocdsDRCSTICMSSC2110');
		FiltrarGrids(grid2110.getSelectedRowsData(), Tab.currentTarget.innerText);
	});

	formAtual.afterCreateGridConteudo.subscribe(function(gridName) {
		if (gridName == 'dataGridConteudocdsDRCSTICMSSC2110'){
			let grid = $(`#${gridName}`, target).exists();

			if (grid) {
				let grid2110 = dxDataGrid.getInstance(grid);
				grid2110.option('selection.mode', 'multiple');
				grid2110.option('selection.allowSelectAll', false);
				grid2110.on('contentReady', () => {
					if (grid2110.getSelectedRowKeys().length == 0){
						grid2110.selectRowsByIndexes(0);
					}
				});
				grid2110.on('selectionChanged', (prop) => {
					if (prop.selectedRowsData.length > 0) {
						DeselectedRowKeys(grid2110, prop);
					} else {
						grid2110.selectRows(prop.currentDeselectedRowKeys[0]);
					}
				});
			}
		}
	});

	function DeselectedRowKeys(grid, prop) {
		if ((prop.selectedRowsData.length > 1)) {
			prop.selectedRowsData.forEach(function (row) {
				if (row.INDICE != prop.currentSelectedRowKeys[0].INDICE){
					grid.deselectRows(row);
				}
			});
		}
	}

	function FiltrarGrids(selectedRowsData, CurrentTab) {
		let grids = ['2112', '2113', '2114', '2120', '2121', '2130', '2132'];

		if (grids.find(element => element == CurrentTab)) {
			let grid = dxDataGrid.getInstance('#dataGridConteudocdsDRCSTICMSSC' + CurrentTab);

			if (selectedRowsData.length > 0) {
				AplicarFiltro(grid, selectedRowsData[0].CODIGOPRODUTO);
			}
		}
	}

	function AplicarFiltro(Grid, Filter) {
		Grid.clearFilter();
		Grid.filter([["CODIGOPRODUTO", "=", Filter]]);
	}
});