FormManager.afterCreateAllForms.subscribe(function() {
	var FormularioGerarSimplesNacional = FormManager.byname('TnFisDPGerarSimplesNacional', '');

	FormularioGerarSimplesNacional.AfterExecuteActionProcess.subscribe(() => configWidgetLink());
  FormularioGerarSimplesNacional.afterCreateGridConteudo.subscribe(function (gridName) {
    if (gridName == "dataGridConteudocdsReceita12Meses") {

      FormularioGerarSimplesNacional
        .gridContentReady
        .pipe(take(3))
        .subscribe((gridName) => {
          if (gridName !== "dataGridConteudocdsReceita12Meses") return;

          let PPERIODOSELECIONADO = moment(FormularioGerarSimplesNacional.fieldbyName("PPERIODOSELECIONADO").getvalue());

          $(".twMiniCardValueDisplayer").each((index, element) => {
            if (moment(PPERIODOSELECIONADO).isSame(moment(element.dataset["filterCard"], "DD/MM/YYYY"), 'month')) {
              $(element).click();
            }
          });
        });
    }
  });

	configWidgetLink()
	$(".col").remove();
});

var DataFiltroMes = null;

function configWidgetLink() {
  $("#widget_link_Icms").on('click', IcmsClick);  
  $("#widget_link_Issqn").on('click', IssqnClick);
  $("#widget_link_FatorR").on('click', FatorRClick);
  $("#widget_link_TotalImpostos").on('click', ImpostosClick);
}

function actFiltrarGrid(el) {
  let filter = el.dataset["filterCard"];
  let start = moment(filter, "DD/MM/YYYY");
  let end =  moment(filter, "DD/MM/YYYY").endOf("month");
  let gridReceita = dxDataGrid.getInstance("#dataGridConteudocdsReceita");
  let gridAnexo = dxDataGrid.getInstance("#dataGridConteudocdsAnexos");
  let gridReceita12Meses = dxDataGrid.getInstance("#dataGridConteudocdsReceita12Meses");
  
  gridReceita.clearFilter();
  gridAnexo.clearFilter();
  gridReceita12Meses.clearFilter();

  gridReceita.filter([ ["COMPETENCIA", ">=", start.toDate()], "and", ["COMPETENCIA", "<=", end.toDate()] ]);
  gridAnexo.filter([ ["COMPETENCIA", ">=", start.toDate()], "and", ["COMPETENCIA", "<=", end.toDate()] ]);
  
  let dataini = moment(filter, "DD/MM/YYYY").subtract(12, "month");
  let datafim = moment(filter, "DD/MM/YYYY").subtract(1, "month");
  gridReceita12Meses.filter([ ["COMPETENCIA", ">=", dataini.toDate()], "and", ["COMPETENCIA", "<=", datafim.toDate()] ]);
  
  AJaxProcessoExecuteMethodGetProperty({
    _AClass: 'TnFisDPGerarSimplesNacional',
    _AMethodName: 'CarregarTotais',
    _AValues: start.format("YYYY/MM/DD"),
    _ANamePropertys: 'JSONTotais',
    onSuccess: onGetTotais,
  });
}

function onGetTotais(retorno){
  let totais = JSON.parse(retorno.data.JSONTotais);
  $('#widget_text_FatorR').text(totais.FatorR);
  $('#widget_text_TotalImpostos').text(totais.TotalImposto);
  $('#widget_text_Icms').text(totais.Icms);  
  $('#widget_text_Issqn').text(totais.Issqn);  
  $('#widget_text_Juros').text(totais.Juros);  
  $('#widget_text_Multa').text(totais.Multa);  
}

function AbrirCadastroModalReducaoAliquota(imposto) {
  var filtro = {};
  var FormularioGerarSimplesNacional = FormManager.byname('TnFisDPGerarSimplesNacional', '');

  filtro.CODIGOEMPRESA = SessionManager.selecao.CODIGOEMPRESA;
  filtro.DATATOTAL = FormularioGerarSimplesNacional.fieldbyName("PPERIODOSELECIONADO").getvalue();

  AbrirCadastroModal({
    _AClasse: 'TnFisDMReducaoAliquota'+imposto,
    AFiltros: filtro,
    AGrid: null,
    ANovo: false,
    AChaveMestre: ['CODIGOEMPRESA', 'DATATOTAL'],
    AClasseForm: null,
    ACustomWidth: 600,
    ACustomHeigth: 600
  });
}

function IssqnClick() {
  AbrirCadastroModalReducaoAliquota('ISSQN');
}

function IcmsClick() {
  AbrirCadastroModalReducaoAliquota('ICMS');
}

function FatorRClick(){
  var filtro = {};
  var FormularioGerarSimplesNacional = FormManager.byname('TnFisDPGerarSimplesNacional', '');
  
  filtro.CODIGOEMPRESA = SessionManager.selecao.CODIGOEMPRESA;
  filtro.DATATOTAL = FormularioGerarSimplesNacional.fieldbyName("PPERIODOSELECIONADO").getvalue();
  AbrirCadastroModal({
    _AClasse: 'TnFisDMTotalSSimplesFederalFatorR',
    AFiltros: filtro,
    AGrid: null,
    ANovo: false,
    AChaveMestre: ['CODIGOEMPRESA'],
    AClasseForm: null,
    ACustomWidth: 600,
    ACustomHeigth: 390
  });
}

function ImpostosClick(){
  var filtro = {};
  var FormularioGerarSimplesNacional = FormManager.byname('TnFisDPGerarSimplesNacional', '');
  
  filtro.CODIGOEMPRESA = SessionManager.selecao.CODIGOEMPRESA;
  filtro.DATATOTAL = FormularioGerarSimplesNacional.fieldbyName("PPERIODOSELECIONADO").getvalue();
  AbrirCadastroModal({
    _AClasse: 'TnFisDMTotalSSimplesFederalResumo',
    AFiltros: filtro,
    AGrid: null,
    ANovo: false,
    AChaveMestre: ['CODIGOEMPRESA'],
    AClasseForm: null,
    ACustomWidth: 600
  });
}