var alterarPeriodoAquis = false;
var alterarPeriodoAquisEmpresa = 0;
var alterarPeriodoAquisCodigoFuncContr = 0;
var alterarPeriodoAquisData = 0;

function DoBeforeDeleteAfastamento(element, data) {
    KTApp.blockPage();

    var d = $.Deferred();

    let afastamento = data;
    
    AJaxCadastroExecuteMethodGetProperty('TnFpaDMAfastamento', 'PegaTipoSit', afastamento.CODIGOSIT, '', (retorno) => {
        let TipoSit = retorno.data.result;        
        if (TipoSit == '02' || TipoSit == '07') {
            criarDialogSimNao('Atenção! Afastamento de Férias / Rescisão! Deseja excluir mesmo assim?', 
                'Exclusão', 
                (a) => { 
                    BuscarDadosPeriodoAquisitivo(afastamento.CODIGOEMPRESA, afastamento.CODIGOFUNCCONTR, afastamento.DATAAFAST).then(() => {
                        d.resolve(); 
                    });                    
                },
                (a) => { d.reject(); });            
        } else if (['27', '99'].includes(TipoSit) && afastamento.OBSERV.trimRight() === 'Férias Coletivas') {
            criarDialogSimNao('Atenção! Afastamento de Licença Remunerada referente Férias Coletivas! Deseja excluir mesmo assim?', 
                'Exclusão', 
                (a) => { 
                    BuscarDadosPeriodoAquisitivo(afastamento.CODIGOEMPRESA, afastamento.CODIGOFUNCCONTR, afastamento.DATAAFAST).then(() => {
                        d.resolve(); 
                    });
                },
                (a) => { d.reject(); }); 
        } else {
            d.resolve(); 
        }
    });
    
    return d.promise();
}

function BuscarDadosPeriodoAquisitivo(_ACodigoEmpresa, _ACodigoFuncContr, _AData) {   
    var promisePeriodoAquis = $.Deferred(); 

    alterarPeriodoAquis = false;
    alterarPeriodoAquisEmpresa = 0;
    alterarPeriodoAquisCodigoFuncContr = 0;
    alterarPeriodoAquisData = 0;

    let achave = _ACodigoEmpresa + ';' + _ACodigoFuncContr + ';' + _AData;
    AJaxCadastroExecuteMethodGetProperty('TnFpaDMAfastamento', 'PegarDadosPeriodoAquis', achave, '', (retorno) => {
        alterarPeriodoAquis = retorno.data.result.PeriodoAquis;
        alterarPeriodoAquisEmpresa = retorno.data.result.CodigoEmpresa;
        alterarPeriodoAquisCodigoFuncContr = retorno.data.result.CodigoFuncContr;
        alterarPeriodoAquisData =  retorno.data.result.Data;
        promisePeriodoAquis.resolve();
    });    
    
    return promisePeriodoAquis.promise();
}

function DoAfterDeleteAfastamento() {
    AbrirCadastroPeriodoAquis();           
}

function AbrirCadastroPeriodoAquis() {
    if (alterarPeriodoAquis) {
        criarDialogOk('Afastamento menor que o último Período Aquisitivo!\nSerá necessário verificar os Períodos Aquisitivos!', 
        'Atenção', () => {
            let afiltro = {
                CODIGOEMPRESA: alterarPeriodoAquisEmpresa,
                CODIGOFUNCCONTR: alterarPeriodoAquisCodigoFuncContr,
                DATAINICIAL: alterarPeriodoAquisData
            };
            AbrirCadastroModal({
              _AClasse: 'TnFpaDMPeriodoAquis',
              AFiltros: afiltro,
              AGrid: '',
              ANovo: false,
              AChaveMestre: ['CODIGOEMPRESA', 'CODIGOFUNCCONTR', 'DATAINICIAL']
            });
        }, false);        
    }
}