FormManager.afterCreateAllForms.subscribe(function () {
	let formAtual = FormManager.byname('TnFpaDMBeneficioQtde', '');

	$("#dataGridConteudoTnFpaDMBeneficioQtdeDet").dxDataGrid({
		onContentReady: function () {
			atualizarTotalizadores();
		}
	});

	formAtual.afterExecuteTnAction.subscribe(function () {
		dxDataGrid.getInstance('#dataGridConteudoTnFpaDMBeneficioQtdeDet').refresh();
	});

	function atualizarTotalizadores() {
		let codigoEmpresa = formAtual.getvalue('CODIGOEMPRESA');
		let codigoFuncContr = formAtual.getvalue('CODIGOFUNCCONTR');
		let compet = moment(formAtual.getvalue('COMPET'), 'YYYY-MM-DD').format('DD/MM/YYYY');

		if ((codigoEmpresa) && (codigoFuncContr) && (compet)) {
			let params = JSON.stringify({
				"CODIGOEMPRESA": codigoEmpresa,
				"CODIGOFUNCCONTR": codigoFuncContr,
				"COMPET": compet
			});

			AJaxCadastroExecuteMethodGetProperty('TnFpaDMBeneficioQtdeDet', 'GetValoresTotalizadoresCloudAjax', params, '', (retorno) => {
				if (retorno.data.result) {
					$('#widget_wdgQtde')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.QTDEBENEFICIO;
					$('#widget_wdgValor')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.VALORBENEFICIO;
				}
			});
		}
	}
});

function actCalcular_BeneficioExecute(sender) {
	win = AbrirProcesso("TnFpaDPCalculoBeneficio", true);
	win.focus();
}
