FormManager.afterCreateAllForms.subscribe(function () {
    const className = 'TNFPADMCFGCALCAUTOCALCULO';
    if (!ehDetalheAtivo(className)) return;
    const form = FormManager.byname(className, '');
    var DynamicImport = FormManager.getUtil('DynamicImport');
    const VerificarExisteConfiguracao = DynamicImport.Import('PageScripts/nFpa/AutomatizadoConfiguracoes', 'VerificarExisteConfiguracao');
    const HabilitaDesabilitaPasso = DynamicImport.Import('PageScripts/nFpa/AutomatizadoConfiguracoes', 'HabilitaDesabilitaPasso');

    WizardManager.setCustomEvent(className, function (item) {
        if ([FormState.cadInsert, FormState.cadAlterando].includes(form.estado)) {
            const subs = form.AfterSave.subscribe(() => {
                subs.unsubscribe();

                GoToWizardItem(item);
            });

            form.executeAction('actDataSetPostExecute', 'btnpost1', { forcePostType: true });
        } else {
            GoToWizardItem(item);
        }
    });

    form.getcomponent('CODIGOCONFIG').change(() => {
        const perfilCalculo = WizardManager.context.Params.PERFILCALCULO;
        const ehPerfilAdto = [epcCalculo13Adiantamento, epcCalculoAdtoSalarial].includes(perfilCalculo);

        form.setenabled('EVENTOSCALCAUTOGERAR', !ehPerfilAdto);
        if (ehPerfilAdto) {
            setEnabledCheckbox(form, 'EVENTOSCALCAUTOGERAR', '1200', false, false);
            setEnabledCheckbox(form, 'EVENTOSCALCAUTOGERAR', '1210', false, false);
            setEnabledCheckbox(form, 'EVENTOSCALCAUTOGERAR', '1299', false, false);
        } else if ([epcCalculo13Integral].includes(perfilCalculo)) {
            setEnabledCheckbox(form, 'EVENTOSCALCAUTOGERAR', '1210', false, false);
        }

        setEnabledCheckbox(form, 'CFGCALCAUTOCALCULORR', '3',
            perfilCalculo != epcCalculo13Adiantamento,
            perfilCalculo != epcCalculo13Adiantamento);
    });

    let enabled = WizardManager.context.Params.PASSOSEXECUCAO?.split(';').includes('CALCULO');
    HabilitaDesabilitaPasso.then((method) => {
        method(form, enabled);
    });

    VerificarExisteConfiguracao.then((method) => {
        method(form, enabled);
    });
});

function setEnabledCheckbox(form, fieldName, checkboxName, isEnabled, isChecked) {
    form.fieldbyName(`${fieldName}_checkbox_${checkboxName}`).setenabled(isEnabled);
    document.getElementById(`ctrl${fieldName}_checkbox_${checkboxName}_ctrl${fieldName}`).checked = isChecked;
}
