FormManager.afterCreateAllForms.subscribe(function () {
    const className = 'TNFPADMCFGCALCAUTOEXPORTSAL';
    if (!ehDetalheAtivo(className)) return;
    const form = FormManager.byname(className, '');
    var DynamicImport = FormManager.getUtil('DynamicImport');
    const VerificarExisteConfiguracao = DynamicImport.Import('PageScripts/nFpa/AutomatizadoConfiguracoes', 'VerificarExisteConfiguracao');
    const HabilitaDesabilitaPasso = DynamicImport.Import('PageScripts/nFpa/AutomatizadoConfiguracoes', 'HabilitaDesabilitaPasso');

    WizardManager.setCustomEvent(className, function (item) {
        if ([FormState.cadInsert, FormState.cadAlterando].includes(form.estado)) {
            const subs = form.AfterSave.subscribe(() => {
                subs.unsubscribe();

                GoToWizardItem(item);
            });

            form.executeAction('actDataSetPostExecute', 'btnpost1', { forcePostType: true });
        } else {
            if (WizardManager.context.Params.CODIGOCONFIG) {
                AJaxCadastroExecuteMethodGetProperty(className, 'GetEtapasNaoConfiguradasAjax', WizardManager.context.Params.CODIGOCONFIG, '', (retorno) => {
                    let msg;
                    if (retorno.data.result === 'falhas') {
                        msg = `Registro salvo com falhas! Verificar as etapas.`;
                    } else if (!retorno.data.result) {
                        msg = `Registro salvo com sucesso!<br>
                               Código da configuração: ${WizardManager.context.Params.CODIGOCONFIG}.`;
                    } else {
                        msg = `Registro salvo com advertências!<br>
                               Confira as etapas: ${retorno.data.result}.<br>
                               Código da configuração: ${WizardManager.context.Params.CODIGOCONFIG}`;
                    }
                    criarDialogOk(msg, 'Aviso', () => {
                        GoToWizardItem(item);
                    });
                });
            }
        }
    });

    let enabled = WizardManager.context.Params.PASSOSEXECUCAO?.split(';').includes('EXPORTSAL');
    HabilitaDesabilitaPasso.then((method) => {
        method(form, enabled);
    });

    VerificarExisteConfiguracao.then((method) => {
        method(form, enabled);
    });
});
