FormManager.afterCreateAllForms.subscribe(function () {
    const className = 'TNFPADMCFGCALCAUTOGERCONTABEIS';
    if (!ehDetalheAtivo(className)) return;
    const form = FormManager.byname(className, '');
    var DynamicImport = FormManager.getUtil('DynamicImport');
    const VerificarExisteConfiguracao = DynamicImport.Import('PageScripts/nFpa/AutomatizadoConfiguracoes', 'VerificarExisteConfiguracao');
    const HabilitaDesabilitaPasso = DynamicImport.Import('PageScripts/nFpa/AutomatizadoConfiguracoes', 'HabilitaDesabilitaPasso');

    WizardManager.setCustomEvent(className, function (item) {
        if ([FormState.cadInsert, FormState.cadAlterando].includes(form.estado)) {
            const subs = form.AfterSave.subscribe(() => {
                subs.unsubscribe();

                GoToWizardItem(item);
            });

            form.executeAction('actDataSetPostExecute', 'btnpost1', { forcePostType: true });
        } else {
            GoToWizardItem(item);
        }
    });

    form.getcomponent('CODIGOCONFIG').change(() => {
        const perfilCalculo = WizardManager.context.Params.PERFILCALCULO;
        const ativar = ![epcCalculo13Adiantamento, epcCalculo13Integral, epcCalculoAdtoSalarial].includes(perfilCalculo);

        setEnabledCheckbox(form, 'CALCULOPROVISOES', '1', ativar, ativar);
        setEnabledCheckbox(form, 'CALCULOPROVISOES', '2', ativar, ativar);
        setEnabledCheckbox(form, 'CFGCALCAUTOPROVISOESRR', '1', ativar, ativar);
        setEnabledCheckbox(form, 'CFGCALCAUTOPROVISOESRR', '2', ativar, ativar);
    });

    let enabled = WizardManager.context.Params.PASSOSEXECUCAO?.split(';').includes('GERCONTABEIS');
    HabilitaDesabilitaPasso.then((method) => {
        method(form, enabled);
    });

    VerificarExisteConfiguracao.then((method) => {
        method(form, enabled);
    });
});

function setEnabledCheckbox(form, fieldName, checkboxName, isEnabled, isChecked) {
    form.fieldbyName(`${fieldName}_checkbox_${checkboxName}`).setenabled(isEnabled);
    document.getElementById(`ctrl${fieldName}_checkbox_${checkboxName}_ctrl${fieldName}`).checked = isChecked;
}
