//#region Funções Gerais
const epcProLaboreSemFunc = '1';
const epcCalculoFolhaGeral = '2';
const epcCalculo13Adiantamento = '3';
const epcCalculo13Integral = '4';
const epcCalculoAdtoSalarial = '5';

function ehDetalheAtivo(formName) {
	return (formName.toUpperCase() === WizardManager.context.DetalheAtivo.toUpperCase());
}
//#endregion

FormManager.afterCreateAllForms.subscribe(function () {
	const className = 'TNFPADMCFGCALCAUTOINICIAL';
	if (!ehDetalheAtivo(className)) return;
	const form = FormManager.byname(className, '');

	WizardManager.setCustomEvent(className, function (item) {
		if ([FormState.cadInsert, FormState.cadAlterando].includes(form.estado)) {
			const subs = form.AfterSave.subscribe(() => {
				subs.unsubscribe();

				GoToWizardItem(item);
			});

			form.executeAction('actDataSetPostExecute', 'btnpost1', { forcePostType: true });
		} else {
			GoToWizardItem(item);
		}
	});

	form.getcomponent('PERFILCALCULO').change(() => {
		const perfilCalculo = form.getvalue('PERFILCALCULO');

		setEnabledCheckbox(form, 'PASSOSEXECUCAO', 'CALCULO',
			([epcCalculoFolhaGeral, epcCalculo13Adiantamento, epcCalculo13Integral, epcCalculoAdtoSalarial].includes(perfilCalculo)),
			([epcProLaboreSemFunc, epcCalculo13Adiantamento, epcCalculo13Integral, epcCalculoAdtoSalarial].includes(perfilCalculo))
		);
		setEnabledCheckbox(form, 'PASSOSEXECUCAO', 'GPS',
			([epcCalculoFolhaGeral, epcCalculo13Integral].includes(perfilCalculo)),
			([epcProLaboreSemFunc, epcCalculoFolhaGeral, epcCalculo13Integral].includes(perfilCalculo))
		);
		setEnabledCheckbox(form, 'PASSOSEXECUCAO', 'GUIASFED',
			([epcCalculoFolhaGeral].includes(perfilCalculo)),
			([epcProLaboreSemFunc, epcCalculoFolhaGeral].includes(perfilCalculo))
		);
		setEnabledCheckbox(form, 'PASSOSEXECUCAO', 'SINDICAL',
			([epcCalculoFolhaGeral].includes(perfilCalculo)),
			([epcCalculoFolhaGeral].includes(perfilCalculo))
		);
		setEnabledCheckbox(form, 'PASSOSEXECUCAO', 'SEFIP',
			([epcCalculoFolhaGeral, epcCalculo13Integral].includes(perfilCalculo)),
			([epcProLaboreSemFunc, epcCalculoFolhaGeral, epcCalculo13Integral].includes(perfilCalculo))
		);
		setEnabledCheckbox(form, 'PASSOSEXECUCAO', 'GERCONTABEIS',
			([epcCalculoFolhaGeral, epcCalculo13Adiantamento, epcCalculo13Integral, epcCalculoAdtoSalarial].includes(perfilCalculo)),
			([epcProLaboreSemFunc, epcCalculo13Adiantamento, epcCalculo13Integral, epcCalculoAdtoSalarial].includes(perfilCalculo))
		);
		setEnabledCheckbox(form, 'PASSOSEXECUCAO', 'HOLERITE',
			([epcCalculoFolhaGeral, epcCalculo13Adiantamento, epcCalculo13Integral, epcCalculoAdtoSalarial].includes(perfilCalculo)),
			([epcProLaboreSemFunc, epcCalculo13Adiantamento, epcCalculo13Integral, epcCalculoAdtoSalarial].includes(perfilCalculo))
		);
		setEnabledCheckbox(form, 'PASSOSEXECUCAO', 'EXPORTSAL',
			([epcCalculoFolhaGeral, epcCalculo13Adiantamento, epcCalculo13Integral].includes(perfilCalculo)),
			([epcCalculoFolhaGeral, epcCalculoFolhaGeral].includes(perfilCalculo))
		);
	});
});

function setEnabledCheckbox(form, fieldName, checkboxName, isEnabled, isChecked) {
	form.fieldbyName(`${fieldName}_checkbox_${checkboxName}`).setenabled(isEnabled);
	document.getElementById(`ctrl${fieldName}_checkbox_${checkboxName}_ctrl${fieldName}`).checked = isChecked;
}
