FormManager.afterCreateAllForms.subscribe(function () {
    let form = FormManager.byname('TnFpaDMCfgCalcAutoRRCalculo', '');

    form.getcomponent('CODIGOCONFIG').change(configRequiredFields);

    function configRequiredFields() {
        let codigoConfig = form.getvalue('CODIGOCONFIG');

        if (codigoConfig) {
            buscarRelatoriosSelecionados('CFGCALCAUTOCALCULO', 'CFGCALCAUTOCALCULORR', codigoConfig)
                .then((result) => {
                    const relatorios = result.split(';');
                    relacaoCalculo = relatorios.includes('1');
                    liquidoCalculo = relatorios.includes('2');
                    relacaoCalculoResumo = relatorios.includes('5');

                    form.setrequired('PTIPOREL', relacaoCalculo);
                    form.setrequired('PSEPARARPROVDESC ', relacaoCalculo);
                    form.setrequired('PIMPRIMIREVENTOFGTSPIS', relacaoCalculo);
                    form.setrequired('PQUEBRAPAGINA_GERAL', relacaoCalculo);
                    form.setrequired('PQUEBRAIMP', relacaoCalculo);
                    form.setrequired('PQUEBRAPAGINAANALITSINT', relacaoCalculo);
                    form.setrequired('PDETALHARMEMORIACALCINSS', relacaoCalculo);
                    form.setrequired('PEXIBIRUSUARIO', relacaoCalculo);
                    form.setrequired('PDETALHARSALARIOPORAULA', relacaoCalculo);
                    form.setrequired('PHORADIA', relacaoCalculo);
                    form.setrequired('PAJUSTARPAGINA', relacaoCalculo);
                    form.setrequired('PORDENAREVENTO', relacaoCalculo || relacaoCalculoResumo);
                    form.setrequired('PORDENARFUNC', relacaoCalculo);
                    form.setrequired('PTOTALIZAR', relacaoCalculo);
                    form.setrequired('PQUEBRA_LIQUIDOS', liquidoCalculo);
                });
            KTApp.unblockPage();
        }
    }

    async function buscarRelatoriosSelecionados(tabela, campo, codigoConfig) {
        var executor = new nExpressionExecutor();
        return await executor.execute(`EXTERNO("CALCAUTORELATSELECIONADO",["${tabela}","${campo}",${codigoConfig}])`);
    }
});
