FormManager.afterCreateAllForms.subscribe(function () {
    let form = FormManager.byname('TnFpaDMCfgCalcAutoRRGPS', '');

    form.getcomponent('CODIGOCONFIG').change(configRequiredFields);

    function configRequiredFields() {
        let codigoConfig = form.getvalue('CODIGOCONFIG');

        if (codigoConfig) {
            buscarRelatoriosSelecionados('CFGCALCAUTOGPS', 'CFGCALCAUTOGPSRR', codigoConfig)
                .then((result) => {
                    const relatorios = result.split(';');
                    demonstrativoINSSResumido = relatorios.includes('1');
                    demonstINSS = relatorios.includes('2');

                    form.setrequired('PQUEBRAPAGINA', demonstrativoINSSResumido);
                    form.setrequired('PQUEBRA', demonstrativoINSSResumido);
                    form.setrequired('PORDENAR', demonstrativoINSSResumido);
                    form.setrequired('PTIPOGPSCOMBO', demonstINSS);
                    form.setrequired('PTIPO', demonstINSS);
                    form.setrequired('PIMPRIMIRDEBITO', demonstINSS);
                });
            KTApp.unblockPage();
        }
    }

    async function buscarRelatoriosSelecionados(tabela, campo, codigoConfig) {
        var executor = new nExpressionExecutor();
        return await executor.execute(`EXTERNO("CALCAUTORELATSELECIONADO",["${tabela}","${campo}",${codigoConfig}])`);
    }
});
