FormManager.afterCreateAllForms.subscribe(function () {
    let form = FormManager.byname('TnFpaDMCfgCalcAutoRRGerContabeis', '');

    form.getcomponent('CODIGOCONFIG').change(configRequiredFields);

    function configRequiredFields() {
        let codigoConfig = form.getvalue('CODIGOCONFIG');

        if (codigoConfig) {
            buscarRelatoriosSelecionados('CFGCALCAUTOGERCONTABEIS', 'CFGCALCAUTOPROVISOESRR', codigoConfig)
                .then((result) => {
                    const relatorios = result.split(';');
                    provisao13Graf = relatorios.includes('1');
                    provisaoFeriasGraf = relatorios.includes('2');

                    form.setrequired('PTIPO', provisao13Graf || provisaoFeriasGraf);
                });
            buscarRelatoriosSelecionados('CFGCALCAUTOGERCONTABEIS', 'CFGCALCAUTOCONTABILIZACAORR', codigoConfig)
                .then((result) => {
                    const relatorios = result.split(';');
                    contab = relatorios.includes('1');

                    form.setrequired('PLISTAROUTRASEMP', contab);
                    form.setrequired('PLISTARTERCEIROS', contab);
                });

            KTApp.unblockPage();
        }
    }

    async function buscarRelatoriosSelecionados(tabela, campo, codigoConfig) {
        var executor = new nExpressionExecutor();
        return await executor.execute(`EXTERNO("CALCAUTORELATSELECIONADO",["${tabela}","${campo}",${codigoConfig}])`);
    }
});
