FormManager.afterCreateAllForms.subscribe(function () {
    let form = FormManager.byname('TnFpaDMCfgCalcAutoRRGuiasFederais', '');

    form.getcomponent('CODIGOCONFIG').change(configRequiredFields);

    async function configRequiredFields() {
        let codigoConfig = form.getvalue('CODIGOCONFIG');

        if (codigoConfig) {
            buscarRelatoriosSelecionados('CFGCALCAUTOGUIASFEDERAIS', 'CFGCALCAUTOIRRFRR', codigoConfig)
                .then((result) => {
                    const relatorios = result.split(';');
                    relacaoIRRFFunc = relatorios.includes('1');
                    relacaoIRRFTerc = relatorios.includes('2');

                    form.setrequired('PTIPO', relacaoIRRFFunc);
                    form.setrequired('PQUEBRA', relacaoIRRFFunc);
                    form.setrequired('PQUEBRAPAGINA', relacaoIRRFFunc);
                    form.setrequired('PORDENACAO', relacaoIRRFFunc);
                    form.setrequired('PFILTRAR', relacaoIRRFTerc);
                });
            KTApp.unblockPage();
        }
    }

    async function buscarRelatoriosSelecionados(tabela, campo, codigoConfig) {
        var executor = new nExpressionExecutor();
        return await executor.execute(`EXTERNO("CALCAUTORELATSELECIONADO",["${tabela}","${campo}",${codigoConfig}])`);
    }
});
