FormManager.afterCreateAllForms.subscribe(function () {
    let form = FormManager.byname('TnFpaDMCfgCalcAutoRRHolerite', '');

    form.getcomponent('CODIGOCONFIG').change(configRequiredFields);

    function configRequiredFields() {
        let codigoConfig = form.getvalue('CODIGOCONFIG');

        if (codigoConfig) {
            buscarRelatoriosSelecionados('CFGCALCAUTOHOLERITE', 'CFGCALCAUTOHOLERITERR', codigoConfig)
                .then((result) => {
                    const relatorios = result.split(';');
                    requerido = relatorios.length > 0;

                    form.setrequired('CONSIDERAEMITEENV', requerido);
                    form.setrequired('EVENTOFERIAS', requerido);
                    form.setrequired('EXIBIREVENTOAUXDOENCA', requerido);
                    form.setrequired('EXIBIREVENTOLIQUIDOZERADO', requerido);
                    form.setrequired('EXIBIRFELICITACAOANIVERSARIO', requerido);
                    form.setrequired('EXIBIREVENTOPLANOSAUDE', requerido);
                    form.setrequired('DETALHAREVENTOPENSAOJUDICIAL', requerido);
                    form.setrequired('DETALHARPROFESSORES', requerido);
                    form.setrequired('QUEBRARATEIO', requerido);
                    form.setrequired('PUTILIZAQCOLABORE', requerido);
                });

            KTApp.unblockPage();
        }
    }

    async function buscarRelatoriosSelecionados(tabela, campo, codigoConfig) {
        var executor = new nExpressionExecutor();
        return await executor.execute(`EXTERNO("CALCAUTORELATSELECIONADO",["${tabela}","${campo}",${codigoConfig}])`);
    }
});
