FormManager.afterCreateAllForms.subscribe(function () {
    let form = FormManager.byname('TnFpaDMCfgCalcAutoRRSEFIP', '');

    form.getcomponent('CODIGOCONFIG').change(configRequiredFields);

    function configRequiredFields() {
        let codigoConfig = form.getvalue('CODIGOCONFIG');

        if (codigoConfig) {
            buscarRelatoriosSelecionados('CFGCALCAUTOSEFIP', 'CFGCALCAUTOSEFIPRR', codigoConfig)
                .then((result) => {
                    const relatorios = result.split(';');
                    sefip = relatorios.includes('1');
                    resRecolFGTSFunc = relatorios.includes('3');

                    form.setrequired('PQUEBRACATEG', sefip);
                    form.setrequired('PTOTALIZAR', sefip);
                    form.setrequired('PORDENAR_SEFIP', sefip);
                    form.setrequired('PLISTAR', resRecolFGTSFunc);

                });
            KTApp.unblockPage();
        }
    }

    async function buscarRelatoriosSelecionados(tabela, campo, codigoConfig) {
        var executor = new nExpressionExecutor();
        return await executor.execute(`EXTERNO("CALCAUTORELATSELECIONADO",["${tabela}","${campo}",${codigoConfig}])`);
    }
});
