FormManager.afterCreateAllForms.subscribe(function() { 
    const form = FormManager.byname('TNFPADMDADOSNAOOBRIGATORIOSADMISSAO', '');

    var DynamicImport = FormManager.getUtil('DynamicImport');
    const VerificarExisteConfiguracao = DynamicImport.Import('PageScripts/nFpa/AutomatizadoConfiguracoes', 'VerificarExisteConfiguracao');

    VerificarExisteConfiguracao.then((method) => {
        method(form, true);
    });

    WizardManager.setCustomEvent("TNFPADMDADOSNAOOBRIGATORIOSADMISSAO", function() {
        if ([FormState.cadInsert, FormState.cadAlterando].includes(form.estado)) {
            form.executeAction('actDataSetPostExecute', 'btnpost1', { forcePostType: true });
        }
        else {
            GoToWizardItem(WizardManager.context.DetalheProximo); 
        }
    });
    
    form.AfterSave.subscribe(() => {
        GoToWizardItem(WizardManager.context.DetalheProximo);
    });

	const subs = form.AfterLoadDataSubject.subscribe(() => {
        if (WizardManager.context.Params['EHREGISTRODADONAOOBRIGATORIO']) {
            form.changeState(FormState.cadAlterando)
        };

        form.fields.forEach((field) => {
            if (field.nome in WizardManager.context.Params && WizardManager.context.Params[field.nome]) field.setvalue(WizardManager.context.Params[field.nome]);
        });

        subs.unsubscribe();
	});
});