FormManager.afterCreateAllForms.subscribe(function() { 
    const form = FormManager.byname('TNFPADMDADOSOBRIGATORIOSADMISSAO', '');

    var DynamicImport = FormManager.getUtil('DynamicImport');
    const VerificarExisteConfiguracao = DynamicImport.Import('PageScripts/nFpa/AutomatizadoConfiguracoes', 'VerificarExisteConfiguracao');

    VerificarExisteConfiguracao.then((method) => {
        method(form, true);
    });

    WizardManager.setCustomEvent("TNFPADMDADOSOBRIGATORIOSADMISSAO", function() {
        if ([FormState.cadInsert, FormState.cadAlterando].includes(form.estado)) {
            form.executeAction('actDataSetPostExecute', 'btnpost1', { forcePostType: true });
        }
        else {
            GoToWizardItem(WizardManager.context.DetalheProximo); 
        }
    });
    
    form.AfterSave.subscribe(() => {
        GoToWizardItem(WizardManager.context.DetalheProximo);
    });

    const confereAlteracaoValor = {
        _codigo: 0,
        alterou(codigoAtual) {
            let resultado = this._codigo != codigoAtual;
            if (resultado) {
                this._codigo = codigoAtual;
            }
            return resultado;
        }
    };

    const escala = {__proto__: confereAlteracaoValor};
    const tipoJornada = {__proto__: confereAlteracaoValor};

    form.getcomponent('CODIGOESCALA').change(LimparCampoDescricaoJornada);
    form.getcomponent('TIPOJORNADA').change(LimparCampoDescricaoJornada);
    
    function LimparCampoDescricaoJornada() {
        if ((escala.alterou(form.getvalue('CODIGOESCALA'))) || (tipoJornada.alterou(form.getvalue('TIPOJORNADA')))) {
            form.setvalue('DESCRTIPOJORNADA', "");
        };
    };

    const subs = form.AfterLoadDataSubject.subscribe(() => {
        if (WizardManager.context.Params['EHREGISTRODADOOBRIGATORIO']) {
            form.changeState(FormState.cadAlterando)
        };

        form.fields.forEach((field) => {
            if (field.nome in WizardManager.context.Params && WizardManager.context.Params[field.nome]) field.setvalue(WizardManager.context.Params[field.nome]);
        });

        subs.unsubscribe();
	});
});