FormManager.afterCreateAllForms.subscribe(function () {
    let formAtual = FormManager.byname('TnFpaDMEventoIntermitenteVarFuncionario', '');
    var Executor = new nExpressionExecutor();

    formAtual.getcomponent('CODIGOEVENTO').change(habilitaDesabilitaCampos);    
    formAtual.getcomponent('CODIGOEVENTO').blur(habilitaDesabilitaCampos); 

    formAtual.getcomponent('CODIGOCONVOCACAO').blur(setConvocacao);

    function habilitaDesabilitaCampos() {
        if (formAtual.getvalue('CODIGOEVENTO')) {
            requestConfigField();
            formAtual.getvalueLookup('CODIGOEVENTO', 'CODIGOPROCED').done((proced) => {
                formAtual.getvalueLookup('CODIGOEVENTO', 'REFEREVENTO').done((refer) => {                 
                    if (['0', '3', '16', '20', '23', '24', '93', '97', '98'].includes(proced)) {                        
                        formAtual.setenabled('REFEREVENTO', true);                        
                        formAtual.setenabled('VALOREVENTO', true);
                    }
                    else if (((refer == '1') || (proced == '75') || ((refer == '4') && ((proced == '1') || (proced == '4') || (proced == '36'))))) {                        
                        formAtual.setenabled('REFEREVENTO', true);                        
                        formAtual.setenabled('VALOREVENTO', false);
                    }
                    else {                        
                        formAtual.setenabled('REFEREVENTO', false);                       
                        formAtual.setenabled('VALOREVENTO', true);
                    }
                });
            });
        }
    }

    function setConvocacao() {
        let codigoEmpresa = formAtual.getvalue('CODIGOEMPRESA');
        let codigoConvocacao = formAtual.getvalue('CODIGOCONVOCACAO');    
        
        if ((codigoEmpresa) && (codigoConvocacao)) {
            buscarDatasConvocacao(codigoEmpresa, codigoConvocacao)
                .then((retorno) => {
                    let datas = JSON.parse(retorno);
                    let mesmaCompet = startOfTheMonth(datas.DataInicial) === startOfTheMonth(datas.DataFinal);
                    if(mesmaCompet){
                        formAtual.setvalue('COMPET', datas.DataFinal);
                    }else 
                        formAtual.setvalue('');
                    KTApp.unblockPage();
                });
        }
    };
    
    async function buscarDatasConvocacao(codigoEmpresa, codigoConvocacao) {
        let Executor = new nExpressionExecutor();
        return await Executor.execute(`EXTERNO("BUSCARDATASCONVOCACAO",[${codigoEmpresa},${codigoConvocacao}])`);        
    }
     
    async function requestConfigField() {
        let newMask = await Executor.execute(`EXTERNO("PEGARMASCARAREFEREVENTO", [${formAtual.getvalue("CODIGOEVENTO") || '""'}])`);
        changeDataMask('REFEREVENTO', newMask);
        KTApp.unblockPage();
    }

    function startOfTheMonth(data) {
		let date = (new Date(moment(data, 'DD/MM/YYYY').add(1, 'days').format('YYYY-MM-DD')));
		return moment(new Date(date.getFullYear(), date.getMonth(), 1), 'YYYY-MM-DD').format('DD/MM/YYYY');
	}

    function changeDataMask(fieldName, mask) {
        let fieldComponent = formAtual.fieldbyName(fieldName).componente;

		fieldComponent.val(fieldComponent.data("value"));
        $(fieldComponent).unmask();
        fieldComponent[0].dataset['mask'] = mask;
        $.applyDataMask(fieldComponent);
    };

});
