FormManager.afterCreateAllForms.subscribe(function () {
	let formAtual = FormManager.byname('TnFpaDMFUNCCATSST', '');
	let nomeRelatorio = 'nFpaRRCATSST';

	formAtual.getcomponent('TIPOCAT').blur(sugerirDadosOriginais);
	formAtual.getcomponent('LOCALACID').blur(sugerirEndereco);
	formAtual.getcomponent('CODIGOOUTEMP').blur(sugerirEndereco);

	function sugerirDadosOriginais() {
		let codigoEmpresa = formAtual.getvalue('CODIGOEMPRESA');
		let codigoFuncContr = formAtual.getvalue('CODIGOFUNCCONTR');
		let numeroAcidente = formAtual.getvalue('NUMEROACIDENTE');
		let dataCat = moment(formAtual.getvalue('DATACAT')).format('DD/MM/YYYY');
		let tipoCat = formAtual.getvalue('TIPOCAT');

		if ((codigoEmpresa) && (codigoFuncContr) && (numeroAcidente) && (dataCat) && (tipoCat > 1)) {
			$achave = `${codigoEmpresa};${codigoFuncContr};${numeroAcidente};'${dataCat}'`;

			if (formAtual.estado === FormState.cadInsert || formAtual.estado === FormState.cadAlterando) {
				KTApp.blockPage();
				AJaxCadastroExecuteMethodGetProperty('TnFpaDMFUNCCATSST', 'CarregaDadosOriginaisAjax', $achave, '', (retorno) => {
					let ignoredFields = ['SEQ','TIPOCAT', 'ULTIMODIATRAB', 'DATAATENDIMENTO', 'HORAATENDIMENTO',
										'HOUVEINTERNACAO', 'AFASTTRATAMENTO', 'DURACAOTRATAMENTO', 'CODIGOLESAO',
										'DESCRICAOCOMPLESAO', 'DIAGNOSTICOPROVAVEL', 'CODIGOCID', 'OBSATESTADOMEDICO',
										'CODIGOCORPOCLINICO'];
					let timeFields = ['HORAAFAST', 'HORAATEACIDTRAB', 'HORAATENDIMENTO'];

					if (retorno.data.result) {
						formAtual.fields.forEach((field) => {
							if ((!ignoredFields.includes(field.nome)) && (retorno.data.result.hasOwnProperty(field.nome)))
								field.setvalue(timeFields.includes(field.nome) ? valueToTime(retorno.data.result[field.nome]) : retorno.data.result[field.nome]);
						})
					}
				});
				KTApp.unblockPage();
			}
		}
	}

	function sugerirEndereco() {
		let localAcidente = formAtual.getvalue('LOCALACID');
		let codigoFuncContr = formAtual.getvalue('CODIGOFUNCCONTR');
		let codigoEmpresa = empresaLocalAcidente(localAcidente);

		if ((localAcidente) && (codigoEmpresa) && (codigoFuncContr)) {
			$achave = `${localAcidente};${codigoEmpresa};${codigoFuncContr}`;

			if (formAtual.estado === FormState.cadInsert || formAtual.estado === FormState.cadAlterando) {
				KTApp.blockPage();
				AJaxCadastroExecuteMethodGetProperty('TnFpaDMFUNCCATSST', 'CarregaEnderecoAjax', $achave, '', (retorno) => {
					if (retorno.data.result) {
						if (retorno.data.result.CodigoTipoLograd)
							formAtual.setvalue('CODIGOTIPOLOGRAD', retorno.data.result.CodigoTipoLograd);
						formAtual.setvalue('ENDERECO', retorno.data.result.Endereco);
						formAtual.setvalue('NUMERO', retorno.data.result.Numero);
						formAtual.setvalue('COMPLEMENTO', retorno.data.result.Complemento);
						formAtual.setvalue('BAIRRO', retorno.data.result.Bairro);
						formAtual.setvalue('SIGLAESTADO', retorno.data.result.SiglaEstado);
						formAtual.setvalue('CODIGOMUNIC', retorno.data.result.CodigoMunic);
						formAtual.setvalue('CEP', retorno.data.result.Cep);
					}
				});
				KTApp.unblockPage();
			}
		}
	}

	function empresaLocalAcidente(localAcidente) {
		switch (localAcidente) {
			case '1':
				return formAtual.getvalue('CODIGOEMPRESA');
				break;
			case '3':
				return formAtual.getvalue('CODIGOOUTEMP');
				break;
			default:
				return '';
				break;
		}
	}

	function valueToTime(minutes) {
		return moment.utc(minutes * 60 * 1000).format('HH:mm');
	}

	FormManager.setReportCustomEvent({
		Class: 'TnFpaDMFUNCCATSST',
		reportName: nomeRelatorio,
		fn: ({ Class, Alias, Tipo, NameItem, Text }) => {
			let params = CadastroGetImputData(formAtual);
			params.pCodigoEmpresa = formAtual.getvalue('CODIGOEMPRESA');
			params.pCodigoFuncContr = formAtual.getvalue('CODIGOFUNCCONTR');
			params.pDataInicial = moment(formAtual.getvalue('DATACAT')).format('DD/MM/YYYY');
			params.pDataFinal = moment(formAtual.getvalue('DATACAT')).format('DD/MM/YYYY');
			params.pSeqCat = formAtual.getvalue('SEQ');
			params.pNumAcidente = formAtual.getvalue('NUMEROACIDENTE');

			if ((params.pCodigoEmpresa) && (params.pCodigoFuncContr) && (params.pDataInicial) &&
				(params.pDataFinal) && (params.pSeqCat) && (params.pNumAcidente))
				DoExecuteReportWithParams(nomeRelatorio, params);
			else
				window.open("Relatorio?Scope=" + JSON.stringify({Class: nomeRelatorio}), '_blank')
		} 
	})

})
