FormManager.afterCreateAllForms.subscribe(function() {
    let formDetalhe;

    $("#framemodal").on("load", function() {
        this.contentWindow.FormManager.runAfterCreateAllForms(function(FormManagerModal, items) {
            formDetalhe = FormManagerModal.byname('TnFpaDMFaixaValorAdicionalItem', '');

            if (formDetalhe) {
                formDetalhe.AfterLoadDataSubject.subscribe(function() {
                    if (formDetalhe.estado === FormState.cadInsert) {
                        BuscarUltimaFaixa();
                    }
                });
            };
        });
    });

    function BuscarUltimaFaixa() {
		let codigoFaixaSalario = document.getElementById('ctrlCODIGOFAIXASALARIO').value;
		let dataInicial = formDetalhe.fieldbyName('DATAINICIAL').getDatepickerElement().val();
		
		if ((codigoFaixaSalario) && (dataInicial)) {
			$achave = `${codigoFaixaSalario};${dataInicial}`;
				AJaxCadastroExecuteMethodGetProperty('TnFpaDMFaixaValorAdicionalItem', 'BuscarUltimaFaixaCloudAjax', $achave, '', (retorno) => {										
					if (retorno.data.result) {					
                        formDetalhe.setvalue('FAIXAINICIAL', retorno.data.result);
					}
				});			
		} else {
            formDetalhe.setvalue('FAIXAINICIAL', '0,01');
        } 			
	}
});
