FormManager.afterCreateAllForms.subscribe(function () {
	let formAtual = FormManager.byname('TnFpaDMFuncContrato', '');

	$ATipoContr = '';

	if (formAtual != null) {

		formAtual.getcomponent('CODIGOFUNCCONTR').change(requestSituacao);
		formAtual.getcomponent('CODIGOTIPOCONTR').change(requestTipoContrato);
		formAtual.getcomponent('DIACONTREXP').change(HabilitarDesabilitarCampos);
		formAtual.getcomponent('DIAPRORROGCONTREXP').change(HabilitarDesabilitarCampos);
		formAtual.getcomponent('OPTANTEFGTS').change(HabilitarDesabilitarCampos);
		formAtual.getcomponent('RECEBEADTO').change(HabilitarDesabilitarCampos);
		formAtual.getcomponent('MODOPGTO').change(HabilitarDesabilitarCampos);
		formAtual.getcomponent('MOTIVOCONTRAT').change(HabilitarDesabilitarCampos);
		formAtual.getcomponent('POSSUIALVARA').change(HabilitarDesabilitarCampos);
		formAtual.getcomponent('EMITIRCARNE').change(HabilitarDesabilitarCampos);
		formAtual.getcomponent('TIPOINSCRSEFIP').change(HabilitarDesabilitarCampos);
		formAtual.getcomponent('RECEBE13SAL').change(HabilitarDesabilitarCampos);

		HabilitarDesabilitarCampos();
		carregarUltimoContrato();
	}

	function carregarUltimoContrato() {
		if (formAtual.getvalue('CODIGOEMPRESA') == '') {
			$achave = SessionManager.selecao.CODIGOEMPRESA + ';';
		} else {
			$achave = formAtual.getvalue('CODIGOEMPRESA') + ';';
		}

		AJaxCadastroExecuteMethodGetProperty('TnFpaDMFuncContrato', 'PegarUltimoContratoFuncionario', $achave, '', requestUltimoContratoSucesso);
	}

	function requestUltimoContratoSucesso(retorno) {
		FormManager.loadCadastro({
			_ACadastro: 'TnFpaDMFuncContrato',
			_AAlias: '',
			_AFiltros: retorno.data.result
		});

		formAtual.setvalue('CODIGOFUNCCONTR', retorno.data.result.CODIGOFUNCCONTR);
		formAtual.setenabled('CODIGOFUNCCONTR', false);
	}

	function HabilitarDesabilitarCampos() {
		formAtual = FormManager.byname('TnFpaDMFuncContrato', '');

		if (formAtual.getvalue('DIACONTREXP') > 0) {
			var dat = new Date(formAtual.getvalue('DATAADM'));
			var inc = parseInt(formAtual.getvalue('DIACONTREXP'));
			var datinc = dat.addDays(inc);
			formAtual.fieldbyName('DIACONTREXP').setdatadireita(datinc.yyyymmdd());
		}
		else {
			formAtual.fieldbyName('DIACONTREXP').setdatadireita('');
		}

		if (formAtual.getvalue('DIAPRORROGCONTREXP') > 0) {
			var dat = new Date(formAtual.getvalue('DATAADM'));
			var inc = parseInt(formAtual.getvalue('DIACONTREXP')) +
				parseInt(formAtual.getvalue('DIAPRORROGCONTREXP'));
			var datinc = dat.addDays(inc);
			formAtual.fieldbyName('DIAPRORROGCONTREXP').setdatadireita(datinc.yyyymmdd());
		}
		else {
			formAtual.fieldbyName('DIAPRORROGCONTREXP').setdatadireita('');
		}

		formAtual.setenabled('FORMACALCULO', formAtual.configextra.gUtilCalcProf == '1');
		formAtual.setenabled('CODIGOESCALAREFEICAO', formAtual.configextra.gUtilCalcProf != '1');
		formAtual.setenabled('DATAOPCAOFGTS', formAtual.getvalue('OPTANTEFGTS') == '1');
		formAtual.setenabled('CONTAFGTS', formAtual.getvalue('OPTANTEFGTS') == '1');

		var AAtivar = formAtual.configextra.gUtilValeTransp != '1';
		formAtual.setenabled('PREVTERMAFASTVT', AAtivar);
		formAtual.setenabled('NUMEROCARTAOVT', AAtivar);

		var AAtivar = formAtual.getvalue('RECEBEADTO') == '1' ||
			formAtual.getvalue('RECEBEADTO') == '2' ||
			formAtual.getvalue('RECEBEADTO') == '4';
		formAtual.setenabled('PERCADTO', AAtivar);

		var AAtivar = (formAtual.getvalue('MODOPGTO') == '3');
		formAtual.setrequired('TIPOCONTA', AAtivar);
		formAtual.setenabled('TIPOCONTA', AAtivar);
		formAtual.setenabled('NUMEROAGENCIA', AAtivar);
		formAtual.setenabled('NUMEROCONTA', AAtivar);
		formAtual.setenabled('DIGITOCONTA', AAtivar);
		var AAtivar = AAtivar || (formAtual.getvalue('ModoPgto') == '2');
		formAtual.setenabled('CODIGOBANCO', AAtivar);

		formAtual.setenabled('CODIGOPROCESSOJUDADM', formAtual.getvalue('POSSUIALVARA') == '1');
		formAtual.setenabled('TIPOINSCRSEFIP', ($ATipoContr == '06') || ($ATipoContr == '99'));

		if (formAtual.getvalue('TIPOINSCRSEFIP') == '') {
			if (($ATipoContr == '04') || ($ATipoContr == '06') || ($ATipoContr == '99')) {
				formAtual.setvalue('TIPOINSCRSEFIP', '2')
			}
			else {
				formAtual.setvalue('TIPOINSCRSEFIP', '1');
			}
		}

		var AAtivar = ($ATipoContr == '05') || ($ATipoContr == '10');
		formAtual.setenabled('DATATERMINO', AAtivar);
		formAtual.setrequired('DATATERMINO', AAtivar);

		var AAtivar = ($ATipoContr != '05') && ($ATipoContr != '10');
		formAtual.setenabled('DIACONTREXP', AAtivar);
		formAtual.setrequired('DIACONTREXP', AAtivar);

		formAtual.setenabled('DIAPRORROGCONTREXP', AAtivar);
		formAtual.setrequired('DIAPRORROGCONTREXP', AAtivar);

		if (formAtual.getvalue('CODIGOSIT') == '') {
			formAtual.setvalue('CODIGOSIT', '1');
		}

		formAtual.setenabledrequired('PERCADTO', formAtual.getvalue('RECEBEADTO') != '3');
	}

	function requestSituacao() {
		formAtual = FormManager.byname('TnFpaDMFuncContrato', '');

		if (formAtual.getvalue('CODIGOFUNCCONTR') != '') {
			if (formAtual.getvalue('CODIGOEMPRESA') == '') {
				$achave = SessionManager.selecao.CODIGOEMPRESA + ';';
			} else {
				$achave = formAtual.getvalue('CODIGOEMPRESA') + ';';
			}
			$achave = $achave + formAtual.getvalue('CODIGOFUNCCONTR');
			AJaxCadastroExecuteMethodGetProperty('TnFpaDMFuncContrato', 'PegarSituacaoFuncionario', $achave, '', requestSituacaoSucesso);
		}
	}

	function requestTipoContrato() {
		formAtual = FormManager.byname('TnFpaDMFuncContrato', '');
		fieldsValues = [];
		fieldsValues[0] = JSON.parse('{"FieldName":"CODIGOTIPOCONTR","Value":"' + formAtual.getvalue('CODIGOTIPOCONTR') + '"}');
		$.ajax({
			'type': 'GET',
			'url': "nHttpServicos/DadosLookup?_AConsulta=TnFpaDCTipoContrato" +
				"&_ALookupkeyfieldsValues=" + JSON.stringify(fieldsValues) +
				"&_AResultField=TIPOCONTR" +
				"&_AControleResult=result" +
				"&_ADMClassName=TnFpaDMFuncContrato" +
				"&_AAlias=" +
				"&_AOrigem=lookup",
			'cache': true,
			'error': function (jqXHR) { if (verifyAjaxRedirect(jqXHR)) return; },
			'success': AjaxSucessoContrato
		});
	}

	function requestSituacaoSucesso(retorno) {
		formAtual = FormManager.byname('TnFpaDMFuncContrato', '');
		var resultarray = retorno.data.result.split(';');
		formAtual.fieldbyName('CODIGOFUNCCONTR').settextolabelesquerda(resultarray[0], 'green');
		if (resultarray.length = 3) {
			formAtual.fieldbyName('CODIGOFUNCCONTR').settextolabeldireita(resultarray[1], resultarray[2]);
		}
		else {
			formAtual.fieldbyName('CODIGOFUNCCONTR').settextolabeldireita('', '');
		}
	}

	function AjaxSucessoContrato(retorno) {
		formAtual = FormManager.byname('TnFpaDMFuncContrato', '');
		if (retorno.data != null) {
			dados = retorno.data;
		} else {
			dados = retorno;
		}

		$ATipoContr = dados.result;
		HabilitarDesabilitarCampos();
	}
});

function actNovo_DiretorExecute(sender) {
	AbrirCadastro("TnFpaDMFuncionarioINS", true);
}

function actNovo_FuncionarioExecute(sender) {
	AbrirCadastro("TnFpaDMFuncionarioINS", true);
}

function actDataSetInsertExecute(Sender) {
	AbrirCadastro("TnFpaDMFuncionarioINS", true);
}