FormManager.afterCreateAllForms.subscribe(function() {
    const form = FormManager.byname('TNFPADMFUNCCONTRATOPREAREATRAB', '');

    WizardManager.setCustomEvent("TNFPADMFUNCCONTRATOPREAREATRAB", function() {
        if ([FormState.cadInsert, FormState.cadAlterando].includes(form.estado)) {
            form.executeAction('actDataSetPostExecute', 'btnpost1', { forcePostType: true });
        }
        else {
            GoToWizardItem(WizardManager.context.DetalheProximo); 
        }
    });
    
    form.AfterSave.subscribe(() => {
        GoToWizardItem(WizardManager.context.DetalheProximo);
    });

    const requestDataPessoa = function () {
		let codigoEmpresa = form.getvalue('CODIGOEMPRESA');
		let codigoFuncContr = form.getvalue('CODIGOFUNCCONTR');
		let cpfFuncPessoa = form.getvalue('CPFFUNC');
        let carregarWizard = false;

		if ((codigoEmpresa) && (codigoFuncContr) && (cpfFuncPessoa)) {
			$achave = `${codigoEmpresa};${codigoFuncContr};${cpfFuncPessoa};${carregarWizard}`;

            AJaxCadastroExecuteMethodGetProperty('TNFPADMFUNCCONTRATOPREAREATRAB', 'CarregarFuncGravaControleAdmissao', $achave, 'ImportaNomeFuncGrava;ImportaCPFFunc;ImportaDataNasc;ImportaCodigoFuncPessoa', requestDataSucesso);
        }
    }
    
    	
	const requestDataSucesso = function (retorno) {
		form.setvalue('NOMEFUNC', retorno.data.ImportaNomeFuncGrava);
     
        if (retorno.data.ImportaCodigoFuncPessoa != 0) {        
          form.setvalue('CODIGOFUNCPESSOA', retorno.data.ImportaCodigoFuncPessoa);
        }

		if (retorno.data.ImportaDataNasc != '1899-12-30 00:00:00') {		
		  form.setvalue('DATANASC', retorno.data.ImportaDataNasc);
		}
	}
	

    $('.ctrlCPFFUNC').change(() => {
	  setTimeout(() => {		 
		  if ([FormState.cadInsert].includes(form.estado)) {		
			  form.setvalue('NOMEFUNC', null);	
			  form.setvalue('DATANASC', null);
			  setTimeout(requestDataPessoa);
		  }
	  });
    });

    form.AfterLoadDataSubject.subscribe(() => {
        if (form.getvalue('INTEGRADOFUNCCONTRATO') == 1) {
            $(`button[data-action-name="actGerar_Evento_eSocial"]`).attr('disabled', 'disabled');
            document.getElementById('widget_valor_Integrado').innerHTML = "Integrado";
            document.getElementById('widget_valor_Integrado').style.color = "#008000";
        } else {
            $(`button[data-action-name="actGerar_Evento_eSocial"]`).removeAttr('disabled');
            document.getElementById('widget_valor_Integrado').innerHTML = "Não Integrado";
            document.getElementById('widget_valor_Integrado').style.color = "#FF0000";
        };
    });
});