FormManager.afterCreateAllForms.subscribe(function () {
	let formMaster = FormManager.byname('TnFpaDMFuncContratoProfGrid', '');
	let formContratos = FormManager.byname('TnFpaDMFuncContratoProfTipoAula', '');
	let formEscalas = FormManager.byname('TnFpaDMFuncEscalaProf', '');

	formMaster?.executeAction('actDataSetRefreshExecute');

	formContratos?.afterCreateGridConteudo.subscribe(() => {
		let gridContratos = dxDataGrid.getInstance($('#dataGridConteudoTnFpaDMFuncContratoProfTipoAula'));
		let gridDetail = dxDataGrid.getInstance($('#dataGridConteudoTnFpaDMFuncContratoProf'));
		let formAtual = FormManager.byname('TnFpaDMFuncContratoProf', '');
		gridContratos.option("onSelectionChanged", (e) => {
			if (e.selectedRowsData.length === 1) {
				let filter = [];
				filter.push(["CODIGOEMPRESA", "=", e.selectedRowsData[0].CODIGOEMPRESA]);
				filter.push(["CODIGOFUNCCONTR", "=", e.selectedRowsData[0].CODIGOFUNCCONTR]);
				filter.push(["CODIGOPROFTIPOAULA", "=", e.selectedRowsData[0].CODIGOPROFTIPOAULA]);

				gridDetail.filter(filter);
			} else {
				gridDetail.clearFilter();
			}
			gridDetail.refresh();
		});

		formAtual.AfterSave.subscribe(formAtual.AfterDelete = () => {
			gridContratos.refresh();
		});
	});

	formEscalas?.afterCreateGridConteudo.subscribe(() => {
		let gridEscalas = dxDataGrid.getInstance($('#dataGridConteudoTnFpaDMFuncEscalaProf'));
		gridEscalas.option("onSelectionChanged", (e) => {
			if (e.selectedRowsData.length === 1) {
				atualizarTotalizadores(e.selectedRowsData[0]);
			} else {
				limparTotalizadores();
			}
			dxDataGrid.getInstance($('#dataGridConteudoTnFpaDMFuncEscalaProfDet')).refresh();
		});
	});

	$("#framemodal").on("load", function() {
		const contentWindow = this.contentWindow;
		contentWindow.FormManager.runAfterCreateAllForms((FormManagerModal, items) => {
			formContratosModal = FormManagerModal.byname('TnFpaDMFuncContratoProf', '');
			if (formContratosModal) {
				formContratosModal.setenabled('VALORAULA', ([FormState.cadInsert].includes(formContratosModal.estado)));
			}
		});
	});

	function atualizarTotalizadores(data) {
		let codigoEmpresa = data.CODIGOEMPRESA;
		let codigoFuncContr = data.CODIGOFUNCCONTR;
		let dataInicial = moment(data.DATAINICIAL, 'MM/DD/YYYY').format('DD/MM/YYYY');

		if ((codigoEmpresa) && (codigoFuncContr) && (dataInicial)) {
			let params = `${codigoEmpresa};${codigoFuncContr};'${dataInicial}'`;

			AJaxCadastroExecuteMethodGetProperty('TnFpaDMFuncEscalaProfDet', 'GetValoresTotalizadoresCloudAjax', params, '', (retorno) => {
				if (retorno.data.result) {
					$('#widget_wdgHorasDiurnas')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.HorasDiurnas;
					$('#widget_wdgHorasNoturnas')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.HorasNoturnas;
					$('#widget_wdgCargaHoraria')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = retorno.data.result.HorasTotais;
				}
			});
		}
	}

	function limparTotalizadores() {
		$('#widget_wdgHorasDiurnas')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = '000:00';
		$('#widget_wdgHorasNoturnas')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = '000:00';
		$('#widget_wdgCargaHoraria')[0].getElementsByClassName('twMiniCardValueDisplayer-value')[0].innerText = '000:00';
	}
});
