FormManager.afterCreateAllForms.subscribe(function () {
    let form = FormManager.byname('TnFpaDMPeriodoAquis', '');
    form.AfterLoadData = DoAfterLoadData;
    form.getcomponent('CODIGOFUNCCONTR').blur(DoChangeCodigoFuncContr);
    form.getcomponent('DATAINICIAL').blur(DoAfterLoadData);
    form.getcomponent('SITPERIODO').blur(DoAfterLoadData);

    const PERIODO_ABERTO = 1;

    function DoAfterLoadData() {
        if (form.getvalue('SITPERIODO') == PERIODO_ABERTO) {
            let codigoEmpresa = form.getvalue('CODIGOEMPRESA');
            let codigoFuncContr = form.getvalue('CODIGOFUNCCONTR');
            let dataInicial = moment(form.getvalue('DATAINICIAL'), 'YYYY-MM-DD').format('DD/MM/YYYY');
            let dataFinal = moment(form.getvalue('DATAFINAL'), 'YYYY-MM-DD').format('DD/MM/YYYY');
            let diasJaPagos = form.getvalue('DIASJAPAGOS');
            let diasAbono = form.getvalue('DIASABONO');

            if ((codigoEmpresa) && (codigoFuncContr) && (dataInicial) && (dataFinal) && (diasJaPagos) && (diasAbono)) {
                KTApp.blockPage();

                $achave = `${codigoEmpresa};${codigoFuncContr};'${dataInicial}';'${dataFinal}';${diasJaPagos};${diasAbono}`;
                AJaxCadastroExecuteMethodGetProperty('TnFpaDMPeriodoAquis', 'PegarDiasPeriodoAquisAberto', $achave, '', (retorno) => {
                    if (retorno.data.result) {
                        form.setvalue('DIASDIREITO', retorno.data.result.DiasDireito);
                        form.setvalue('DIASSALDO', retorno.data.result.DiasSaldo);
                        form.setvalue('DIASFALTASVIS', retorno.data.result.DiasFaltasVis);
                        form.setvalue('DIASLICREMVIS', retorno.data.result.DiasLicRemVis);
                        form.setvalue('DIASLICMATERNVIS', retorno.data.result.DiasLicMaternVis);
                        form.setvalue('DIASSERVMILITVIS', retorno.data.result.DiasServMilitVis);
                        form.setvalue('DIASAFASTVIS', retorno.data.result.DiasAfastVis);
                        form.setvalue('AVOSFERIAS', retorno.data.result.AvosFerias);
                    }
                    KTApp.unblockPage();
                });
            }
        } else {
            form.setvalue('AVOSFERIAS', 0);
            form.setvalue('DIASDIREITO', 0);
            form.setvalue('DIASSALDO', 0);
            form.setvalue('DIASFALTASVIS', form.getvalue('DIASFALTAS'));
            form.setvalue('DIASAFASTVIS', form.getvalue('DIASAFAST'));
            form.setvalue('DIASLICREMVIS', form.getvalue('DIASLICREM'));
            form.setvalue('DIASLICMATERNVIS', form.getvalue('DIASLICMATERN'));
            form.setvalue('DIASLICMILITVIS', form.getvalue('DIASLICMILIT'));
        }
    }

    function DoChangeCodigoFuncContr() {
        if ((form.estado === FormState.cadInsert) && (form.getvalue('CODIGOFUNCCONTR'))) {
            form.getvalueLookup('CODIGOFUNCCONTR', 'DATAADM').done((dataAdm) => {
                if (dataAdm) {
                    let codigoEmpresa = form.getvalue('CODIGOEMPRESA');
                    let codigoFuncContr = form.getvalue('CODIGOFUNCCONTR');

                    if ((codigoEmpresa) && (codigoFuncContr)) {
                        KTApp.blockPage();

                        $achave = `${codigoEmpresa};${codigoFuncContr};'${moment(dataAdm, 'MM-DD-YYYY').format('DD/MM/YYYY')}'`;
                        AJaxCadastroExecuteMethodGetProperty('TnFpaDMPeriodoAquis', 'PegarDatasPeriodoAquis05', $achave, '', (retorno) => {
                            if (retorno.data.result) {
                                form.setvalue('DATAINICIAL', retorno.data.result.DataInicial);
                                form.setvalue('DATAFINAL', retorno.data.result.DataFinal);
                                form.setvalue('DATALIMPGTO', retorno.data.result.DataLimPgto);
                                form.setvalue('SITPERIODO', PERIODO_ABERTO);
                            }
                            KTApp.unblockPage();
                        });
                    }
                }
            });
        }
    }
    
});


